/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.test.CheckMetazones;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CharUtilities;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitPathType;

public class ExtraPaths {
    private static final boolean DEBUG = false;
    private static final SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
    private static final ImmutableSet<String> casesNominativeOnly = ImmutableSet.of(GrammarInfo.GrammaticalFeature.grammaticalCase.getDefault(null));
    private static final Set<String> CONST_EXTRA_PATHS = CharUtilities.internImmutableSet(Set.of("//ldml/dates/timeZoneNames/zone[@type=\"Pacific/Honolulu\"]/short/generic", "//ldml/dates/timeZoneNames/zone[@type=\"Pacific/Honolulu\"]/short/standard", "//ldml/dates/timeZoneNames/zone[@type=\"Pacific/Honolulu\"]/short/daylight", "//ldml/dates/timeZoneNames/zone[@type=\"Europe/Dublin\"]/long/daylight", "//ldml/dates/timeZoneNames/zone[@type=\"Europe/London\"]/long/daylight", "//ldml/dates/timeZoneNames/zone[@type=\"Etc/UTC\"]/long/standard", "//ldml/dates/timeZoneNames/zone[@type=\"Etc/UTC\"]/short/standard", "//ldml/personNames/sampleName[@item=\"nativeG\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"nativeGS\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"nativeGS\"]/nameField[@type=\"surname\"]", "//ldml/personNames/sampleName[@item=\"nativeGGS\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"nativeGGS\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"nativeGGS\"]/nameField[@type=\"surname\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"title\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"given-informal\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"surname-prefix\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"surname-core\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"surname2\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"generation\"]", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"credentials\"]", "//ldml/personNames/sampleName[@item=\"foreignG\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"foreignGS\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"foreignGS\"]/nameField[@type=\"surname\"]", "//ldml/personNames/sampleName[@item=\"foreignGGS\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"foreignGGS\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"foreignGGS\"]/nameField[@type=\"surname\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"title\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"given-informal\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-prefix\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-core\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname2\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"generation\"]", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"credentials\"]"));

    public static void addConstant(Collection<String> toAddTo) {
        toAddTo.addAll(SingletonHelper.INSTANCE.paths);
    }

    public static void addLocaleDependent(Set<String> toAddTo, Iterable<String> file, String localeID) {
        SupplementalDataInfo.PluralInfo plurals = supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, localeID);
        if (plurals == null) {
            // empty if block
        }
        Set<SupplementalDataInfo.PluralInfo.Count> pluralCounts = Collections.emptySet();
        ExtraPaths.addUnitPlurals(toAddTo, file, plurals);
        ExtraPaths.addDayPlurals(toAddTo, localeID);
        ExtraPaths.addCurrencies(toAddTo, pluralCounts);
        ExtraPaths.addGrammar(toAddTo, pluralCounts, localeID);
    }

    private static void addUnitPlurals(Set<String> toAddTo, Iterable<String> file, SupplementalDataInfo.PluralInfo plurals) {
        if (plurals != null) {
            Set<SupplementalDataInfo.PluralInfo.Count> pluralCounts = plurals.getAdjustedCounts();
            Set<SupplementalDataInfo.PluralInfo.Count> pluralCountsRaw = plurals.getCounts();
            if (pluralCountsRaw.size() != 1) {
                ExtraPaths.addPluralCounts(toAddTo, pluralCounts, pluralCountsRaw, file);
            }
        }
    }

    private static void addPluralCounts(Collection<String> toAddTo, Set<SupplementalDataInfo.PluralInfo.Count> pluralCounts, Set<SupplementalDataInfo.PluralInfo.Count> pluralCountsRaw, Iterable<String> file) {
        for (String path : file) {
            Set<SupplementalDataInfo.PluralInfo.Count> pluralCountsNeeded;
            String countAttr;
            int countPos = path.indexOf(countAttr = "[@count=\"other\"]");
            if (countPos < 0 || (pluralCountsNeeded = path.startsWith("//ldml/numbers/minimalPairs") ? pluralCountsRaw : pluralCounts).size() <= 1) continue;
            String start = path.substring(0, countPos) + "[@count=\"";
            String end = "\"]" + path.substring(countPos + countAttr.length());
            for (SupplementalDataInfo.PluralInfo.Count count : pluralCounts) {
                if (count == SupplementalDataInfo.PluralInfo.Count.other) continue;
                toAddTo.add(start + count + end);
            }
        }
    }

    private static void addDayPlurals(Set<String> toAddTo, String localeID) {
        DayPeriodInfo dayPeriods = supplementalData.getDayPeriods(DayPeriodInfo.Type.format, localeID);
        if (dayPeriods != null) {
            LinkedHashSet<DayPeriodInfo.DayPeriod> items = new LinkedHashSet<DayPeriodInfo.DayPeriod>(dayPeriods.getPeriods());
            items.add(DayPeriodInfo.DayPeriod.am);
            items.add(DayPeriodInfo.DayPeriod.pm);
            for (String context : new String[]{"format", "stand-alone"}) {
                for (String width : new String[]{"narrow", "abbreviated", "wide"}) {
                    for (DayPeriodInfo.DayPeriod dayPeriod : items) {
                        toAddTo.add("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"" + context + "\"]/dayPeriodWidth[@type=\"" + width + "\"]/dayPeriod[@type=\"" + dayPeriod + "\"]");
                    }
                }
            }
        }
    }

    private static void addCurrencies(Set<String> toAddTo, Set<SupplementalDataInfo.PluralInfo.Count> pluralCounts) {
        if (!pluralCounts.isEmpty()) {
            for (String code : StandardCodes.make().getGoodAvailableCodes(StandardCodes.CodeType.currency)) {
                for (SupplementalDataInfo.PluralInfo.Count count : pluralCounts) {
                    toAddTo.add("//ldml/numbers/currencies/currency[@type=\"" + code + "\"]/displayName[@count=\"" + count.toString() + "\"]");
                }
            }
        }
    }

    private static void addGrammar(Set<String> toAddTo, Set<SupplementalDataInfo.PluralInfo.Count> pluralCounts, String localeID) {
        GrammarInfo grammarInfo = supplementalData.getGrammarInfo(localeID, true);
        if (grammarInfo != null && grammarInfo.hasInfo(GrammarInfo.GrammaticalTarget.nominal)) {
            Collection<String> nomCases;
            Collection<String> genders = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
            Collection<String> rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
            Collection<String> collection = nomCases = rawCases.isEmpty() ? casesNominativeOnly : rawCases;
            if (!genders.isEmpty()) {
                for (String unit : GrammarInfo.getUnitsToAddGrammar()) {
                    toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + unit + "\"]/gender");
                }
                for (SupplementalDataInfo.PluralInfo.Count plural : pluralCounts) {
                    for (String gender : genders) {
                        for (String case1 : nomCases) {
                            String grammaticalAttributes = GrammarInfo.getGrammaticalInfoAttributes(grammarInfo, UnitPathType.power, plural.toString(), gender, case1);
                            toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/compoundUnit[@type=\"power2\"]/compoundUnitPattern1" + grammaticalAttributes);
                            toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/compoundUnit[@type=\"power3\"]/compoundUnitPattern1" + grammaticalAttributes);
                        }
                    }
                }
                for (String gender : genders) {
                    toAddTo.add("//ldml/numbers/minimalPairs/genderMinimalPairs[@gender=\"" + gender + "\"]");
                }
            }
            if (!rawCases.isEmpty()) {
                for (String case1 : rawCases) {
                    toAddTo.add("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + case1 + "\"]");
                    for (SupplementalDataInfo.PluralInfo.Count plural : pluralCounts) {
                        for (String unit : GrammarInfo.getUnitsToAddGrammar()) {
                            toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + unit + "\"]/unitPattern" + GrammarInfo.getGrammaticalInfoAttributes(grammarInfo, UnitPathType.unit, plural.toString(), null, case1));
                        }
                    }
                }
            }
        }
    }

    private static class Singleton {
        private final Collection<String> paths;
        private Collection<String> pathsTemp = new TreeSet<String>();

        Singleton() {
            this.addPaths(NameType.LANGUAGE);
            this.addPaths(NameType.SCRIPT);
            this.addPaths(NameType.TERRITORY);
            this.addPaths(NameType.VARIANT);
            this.addMetazones();
            this.pathsTemp.addAll(CONST_EXTRA_PATHS);
            this.paths = ImmutableSet.copyOf(this.pathsTemp);
            this.pathsTemp = null;
        }

        private void addPaths(NameType nameType) {
            StandardCodes.CodeType codeType = nameType.toCodeType();
            StandardCodes sc = StandardCodes.make();
            TreeSet<String> codes = new TreeSet<String>(sc.getGoodAvailableCodes(codeType));
            this.adjustCodeSet(codes, nameType);
            for (String code : codes) {
                this.pathsTemp.add(nameType.getKeyPath(code));
            }
            this.addAltPaths(nameType);
        }

        private void adjustCodeSet(Set<String> codes, NameType nameType) {
            switch (nameType) {
                case LANGUAGE: {
                    codes.remove("root");
                    codes.addAll(List.of("ar_001", "de_AT", "de_CH", "en_AU", "en_CA", "en_GB", "en_US", "es_419", "es_ES", "es_MX", "fa_AF", "fr_CA", "fr_CH", "frc", "hi_Latn", "lou", "nds_NL", "nl_BE", "pt_BR", "pt_PT", "ro_MD", "sw_CD", "zh_Hans", "zh_Hant"));
                    break;
                }
                case TERRITORY: {
                    codes.addAll(List.of("XA", "XB"));
                }
            }
        }

        private void addAltPaths(NameType nameType) {
            switch (nameType) {
                case LANGUAGE: {
                    this.addAltPath("en_GB", "short", nameType);
                    this.addAltPath("en_US", "short", nameType);
                    this.addAltPath("az", "short", nameType);
                    this.addAltPath("ckb", "menu", nameType);
                    this.addAltPath("ckb", "variant", nameType);
                    this.addAltPath("hi_Latn", "variant", nameType);
                    this.addAltPath("yue", "menu", nameType);
                    this.addAltPath("zh", "menu", nameType);
                    this.addAltPath("zh_Hans", "long", nameType);
                    this.addAltPath("zh_Hant", "long", nameType);
                    break;
                }
                case SCRIPT: {
                    this.addAltPath("Hans", "stand-alone", nameType);
                    this.addAltPath("Hant", "stand-alone", nameType);
                }
                case TERRITORY: {
                    this.addAltPath("GB", "short", nameType);
                    this.addAltPath("HK", "short", nameType);
                    this.addAltPath("MO", "short", nameType);
                    this.addAltPath("PS", "short", nameType);
                    this.addAltPath("US", "short", nameType);
                    this.addAltPath("CD", "variant", nameType);
                    this.addAltPath("CG", "variant", nameType);
                    this.addAltPath("CI", "variant", nameType);
                    this.addAltPath("CZ", "variant", nameType);
                    this.addAltPath("FK", "variant", nameType);
                    this.addAltPath("TL", "variant", nameType);
                    this.addAltPath("SZ", "variant", nameType);
                    this.addAltPath("IO", "biot", nameType);
                    this.addAltPath("IO", "chagos", nameType);
                    this.addAltPath("NZ", "variant", nameType);
                    this.addAltPath("TR", "variant", nameType);
                }
            }
        }

        private void addAltPath(String code, String alt, NameType nameType) {
            String fullpath = nameType.getKeyPath(code);
            StringBuilder fullpathBuf = new StringBuilder(fullpath);
            String altPath = fullpathBuf.insert(fullpathBuf.lastIndexOf("]") + 1, "[@alt=\"" + alt + "\"]").toString();
            this.pathsTemp.add(altPath);
        }

        private void addMetazones() {
            for (String zone : supplementalData.getAllMetazones()) {
                boolean metazoneUsesDST = CheckMetazones.metazoneUsesDST(zone);
                for (String width : new String[]{"long", "short"}) {
                    for (String type : new String[]{"generic", "standard", "daylight"}) {
                        if (!metazoneUsesDST && !type.equals("standard")) continue;
                        String path = "//ldml/dates/timeZoneNames/metazone[@type=\"" + zone + "\"]/" + width + "/" + type;
                        this.pathsTemp.add(path);
                    }
                }
            }
        }
    }

    private static class SingletonHelper {
        private static final Singleton INSTANCE = new Singleton();

        private SingletonHelper() {
        }
    }
}

