/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UCharacter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;

public class LocaleValidator {
    static final SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();
    public static final AllowedValid ALLOW_IN_LIKELY = new AllowedValid(null, new Object[]{StandardCodes.LstrType.region, new AllowedMatch("001|419"), StandardCodes.LstrType.language, new AllowedMatch("und|in|iw|ji|jw|mo|tl")});
    static final Validity VALIDITY = Validity.getInstance();
    static final Set<StandardCodes.LstrType> FIELD_ALLOWS_EMPTY = Set.of(StandardCodes.LstrType.script, StandardCodes.LstrType.region);
    static final Map<String, Validity.Status> VALID_VARIANTS = ImmutableMap.copyOf(StandardCodes.getEnumLstreg().get((Object)StandardCodes.LstrType.variant).entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), y -> ((Map)y.getValue()).get((Object)StandardCodes.LstrField.Deprecated) == null ? Validity.Status.regular : Validity.Status.deprecated)));
    private static final Map<String, Validity.Status> KR_REORDER = SupplementalDataInfo.getInstance().getBcp47Keys().get("kr").stream().filter(x -> !x.equals("REORDER_CODE")).collect(Collectors.toMap(Function.identity(), y -> {
        String temp = SupplementalDataInfo.getInstance().getBcp47Deprecated().get(Row.of("kr", y));
        return "false".equals(temp) ? Validity.Status.regular : Validity.Status.deprecated;
    }));
    private static final Map<String, Validity.Status> LOWERCASE_SCRIPT = VALIDITY.getCodeToStatus(StandardCodes.LstrType.script).entrySet().stream().collect(Collectors.toMap(x -> UCharacter.toLowerCase((String)x.getKey()), x -> (Validity.Status)((Object)((Object)x.getValue()))));
    private static final Map<String, Validity.Status> LOWERCASE_REGION = VALIDITY.getCodeToStatus(StandardCodes.LstrType.script).entrySet().stream().collect(Collectors.toMap(x -> UCharacter.toLowerCase((String)x.getKey()), x -> (Validity.Status)((Object)((Object)x.getValue()))));

    public static boolean isValid(LanguageTagParser ltp, AllowedValid allowed, Set<String> errors) {
        if (errors != null) {
            errors.clear();
        }
        if (allowed == null) {
            allowed = new AllowedValid(null, null);
        }
        if (ltp.isLegacy() && allowed.isAllowed(Validity.Status.deprecated)) {
            return true;
        }
        if (Validation.abort == LocaleValidator.validates(StandardCodes.LstrType.language, ltp.getLanguage(), null, allowed, errors)) {
            return false;
        }
        if (Validation.abort == LocaleValidator.validates(StandardCodes.LstrType.script, ltp.getScript(), null, allowed, errors)) {
            return false;
        }
        if (Validation.abort == LocaleValidator.validates(StandardCodes.LstrType.region, ltp.getRegion(), null, allowed, errors)) {
            return false;
        }
        for (String string : ltp.getVariants()) {
            if (Validation.abort != LocaleValidator.validates(StandardCodes.LstrType.variant, string, null, allowed, errors)) continue;
            return false;
        }
        for (Map.Entry entry : ltp.getLocaleExtensionsDetailed().entrySet()) {
            if (Validation.abort != LocaleValidator.validates(StandardCodes.LstrType.extension, (String)entry.getKey(), (List)entry.getValue(), allowed, errors)) continue;
            return false;
        }
        for (Map.Entry entry : ltp.getExtensionsDetailed().entrySet()) {
            if (Validation.abort != LocaleValidator.validates(StandardCodes.LstrType.extension, (String)entry.getKey(), (List)entry.getValue(), allowed, errors)) continue;
            return false;
        }
        return errors.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Validation validates(StandardCodes.LstrType type, String field, List<String> values, AllowedValid allowed, Set<String> errors) {
        Validity.Status status;
        block2 : switch (type) {
            case language: 
            case script: 
            case region: {
                status = VALIDITY.getCodeToStatus(type).get(field);
                if (status == null) {
                    status = Validity.Status.invalid;
                }
                if (!allowed.isAllowed(status) && !allowed.isAllowed(type, field, null, null) && field.length() != 0) break;
                return Validation.keepOn;
            }
            case variant: {
                status = VALID_VARIANTS.get(field);
                if (status == null) {
                    status = Validity.Status.invalid;
                }
                if (!allowed.isAllowed(status)) break;
                return Validation.keepOn;
            }
            case extension: {
                switch (field.length()) {
                    case 1: {
                        switch (field) {
                            case "t": {
                                String lsvr = Joiner.on("-").join(values);
                                Validity.Status status2 = Validity.Status.invalid;
                                try {
                                    LanguageTagParser ltp2 = new LanguageTagParser().set(lsvr);
                                    if (!LocaleValidator.isValid(ltp2, allowed, errors)) return Validation.abort;
                                    return Validation.keepOn;
                                }
                                catch (Exception e) {
                                    if (errors == null) return Validation.abort;
                                    errors.add(String.format("Disallowed %s=%s, tlang=%s, status=%s", new Object[]{type, lsvr, field, status2}));
                                    return Validation.keepOn;
                                }
                            }
                            case "x": {
                                status = Validity.Status.private_use;
                                break block2;
                            }
                            case "u": {
                                status = Validity.Status.invalid;
                                break block2;
                            }
                        }
                        status = Validity.Status.invalid;
                        break block2;
                    }
                    case 2: {
                        Validity.Status status3;
                        String tOrU = field.charAt(1) < 'A' ? "t" : "u";
                        Set<String> subtypes = SDI.getBcp47Keys().get(field);
                        if (subtypes == null) {
                            status = Validity.Status.invalid;
                            break block2;
                        }
                        String subtype = Joiner.on("-").join(values);
                        Map<Row.R2<String, String>, String> bcp47Deprecated = SDI.getBcp47Deprecated();
                        if ("true".equals(bcp47Deprecated.get(Row.of(field, subtype)))) {
                            status3 = Validity.Status.deprecated;
                        } else if (subtypes.contains(subtype)) {
                            status3 = Validity.Status.regular;
                        } else {
                            boolean mapUnknownToRegular = false;
                            block29 : switch (field) {
                                case "x0": {
                                    status3 = Validity.Status.deprecated;
                                    break;
                                }
                                case "dx": {
                                    status3 = LocaleValidator.checkSpecials(type, field, values, allowed, LOWERCASE_SCRIPT);
                                    break;
                                }
                                case "kr": {
                                    status3 = LocaleValidator.checkSpecials(type, field, values, allowed, LOWERCASE_SCRIPT, KR_REORDER);
                                    break;
                                }
                                case "rg": {
                                    mapUnknownToRegular = true;
                                }
                                case "sd": {
                                    status3 = LocaleValidator.checkSpecials(type, field, values, allowed, VALIDITY.getCodeToStatus(StandardCodes.LstrType.subdivision));
                                    break;
                                }
                                case "vt": {
                                    status3 = Validity.Status.invalid;
                                    if (values.isEmpty()) break;
                                    for (String value : values) {
                                        try {
                                            int intValue = Integer.parseInt(value, 16);
                                            if (intValue < 0 || intValue > 0x10FFFF) break block29;
                                            if (55296 > intValue || intValue > 57343) continue;
                                        }
                                        catch (NumberFormatException e) {}
                                        break block29;
                                    }
                                    status3 = Validity.Status.regular;
                                    break;
                                }
                                default: {
                                    status3 = Validity.Status.invalid;
                                }
                            }
                            if (mapUnknownToRegular && status3 == Validity.Status.unknown) {
                                status3 = Validity.Status.regular;
                            }
                        }
                        if (allowed.isAllowed(status3) || allowed.isAllowed(StandardCodes.LstrType.extension, field, subtype, status3)) {
                            return Validation.keepOn;
                        }
                        if (errors == null) {
                            return Validation.abort;
                        }
                        errors.add(String.format("Disallowed %s=%s=%s, status=%s", new Object[]{type, field, subtype, status3}));
                        return Validation.keepOn;
                    }
                }
                status = Validity.Status.invalid;
                break;
            }
            default: {
                status = null;
            }
        }
        if (errors == null) {
            return Validation.abort;
        }
        errors.add(String.format("Disallowed %s=%s, status=%s", new Object[]{type, field, status}));
        return Validation.keepOn;
    }

    public static Validity.Status checkSpecials(StandardCodes.LstrType type, String field, List<String> values, AllowedValid allowed, Map<String, Validity.Status> ... validityMaps) {
        if (values.size() > 1 && (field.equals("sd") || field.equals("rg"))) {
            return Validity.Status.invalid;
        }
        Validity.Status best = null;
        for (String value : values) {
            Map<String, Validity.Status> validityMap;
            Validity.Status status = null;
            Map<String, Validity.Status>[] mapArray = validityMaps;
            int n = mapArray.length;
            for (int i = 0; i < n && (status = (validityMap = mapArray[i]).get(value)) == null; ++i) {
            }
            if (status == null) {
                return Validity.Status.invalid;
            }
            if (allowed.isAllowed(status) || allowed.isAllowed(type, field, value, status)) {
                if (best != null) continue;
                best = status;
                continue;
            }
            return status;
        }
        return best == null ? Validity.Status.invalid : best;
    }

    public Validity.Status checkRegion(StandardCodes.LstrType type, String field, List<String> values, AllowedValid allowed) {
        Validity.Status best = null;
        for (String value : values) {
            String value2 = UCharacter.toTitleCase(value, null);
            Validity.Status status = VALIDITY.getCodeToStatus(StandardCodes.LstrType.script).get(value2);
            if (status == null) {
                return Validity.Status.invalid;
            }
            if (allowed.isAllowed(status) || allowed.isAllowed(type, field, value, null)) {
                if (best != null) continue;
                best = status;
                continue;
            }
            return status;
        }
        return best == null ? Validity.Status.invalid : best;
    }

    private static enum Validation {
        abort,
        keepOn;

    }

    public static class AllowedValid {
        private final Set<Validity.Status> allowedStatus;
        private final Multimap<StandardCodes.LstrType, AllowedMatch> allowedExceptions;

        public boolean isAllowed(Validity.Status status) {
            return this.allowedStatus.contains((Object)status);
        }

        public boolean isAllowed(StandardCodes.LstrType lstrType, String key, String value, Validity.Status status) {
            Collection<AllowedMatch> allowedMatches = this.allowedExceptions.get(lstrType);
            if (allowedMatches == null) {
                return false;
            }
            for (AllowedMatch allowedMatch : allowedMatches) {
                if (!allowedMatch.matches(key, value, status)) continue;
                return true;
            }
            return false;
        }

        public AllowedValid(Set<Validity.Status> allowedStatus, Object ... allowedExceptions) {
            this.allowedStatus = allowedStatus == null ? Set.of(Validity.Status.regular) : Set.copyOf(allowedStatus);
            HashMultimap<StandardCodes.LstrType, AllowedMatch> allowed = HashMultimap.create();
            if (allowedExceptions != null) {
                for (int i = 0; i < allowedExceptions.length; i += 2) {
                    allowed.put((StandardCodes.LstrType)((Object)allowedExceptions[i]), (AllowedMatch)allowedExceptions[i + 1]);
                }
            }
            this.allowedExceptions = ImmutableMultimap.copyOf(allowed);
        }

        public String toString() {
            return this.allowedStatus + " " + this.allowedExceptions;
        }
    }

    public static class AllowedMatch {
        final Pattern key;
        final Pattern value;
        final Validity.Status status;

        public AllowedMatch(String code) {
            this(code, null, null);
        }

        public AllowedMatch(String code, String value) {
            this(code, value, null);
        }

        public AllowedMatch(String code, String value, Validity.Status status) {
            this.key = code == null ? null : Pattern.compile(code);
            this.value = value == null ? null : Pattern.compile(value);
            this.status = status;
        }

        public boolean matches(String key0, String value0, Validity.Status status) {
            return !(this.key != null && !this.key.matcher(key0).matches() || this.value != null && (!this.value.matcher(value0).matches() || status != null && status != status));
        }

        public String toString() {
            return this.key + "\u2192" + this.value;
        }
    }
}

