/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;

public class RangeAbbreviator {
    private BreakIterator breaker1;
    private BreakIterator breaker2;
    private String separator;
    private StringBuilder buffer = new StringBuilder();

    public RangeAbbreviator(BreakIterator breaker, String separator) {
        this.breaker1 = (BreakIterator)breaker.clone();
        this.breaker2 = (BreakIterator)breaker.clone();
        this.separator = separator;
    }

    public RangeAbbreviator(ULocale breaker, String separator) {
        this(BreakIterator.getWordInstance(breaker), separator);
    }

    public String abbreviate(String firstString, String secondString) {
        if (firstString.equals(secondString)) {
            return firstString;
        }
        this.buffer.setLength(0);
        this.breaker1.setText(firstString);
        this.breaker2.setText(secondString);
        int start1 = this.breaker1.first();
        int start2 = this.breaker2.first();
        while (true) {
            this.breaker1.next();
            int current1 = this.breaker1.current();
            if (current1 == -1) break;
            this.breaker2.next();
            int current2 = this.breaker2.current();
            if (current2 == -1 || !firstString.regionMatches(start1, secondString, start2, current1 - start1)) break;
            start1 = current1;
            start2 = current2;
        }
        int end1 = this.breaker1.last();
        while (true) {
            this.breaker1.previous();
            int current1 = this.breaker1.current();
            if (current1 == -1) break;
            this.breaker2.previous();
            int current2 = this.breaker2.current();
            if (current2 == -1 || !firstString.regionMatches(current1, secondString, current2, end1 - current1)) break;
            end1 = current1;
        }
        return this.buffer.append(firstString.substring(0, end1)).append(this.separator).append(secondString.substring(start2)).toString();
    }
}

