/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Row;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ChartDelta;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CollatorHelper;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.ZoneFormats;

public class VerifyZones {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final String DIR = CLDRPaths.CHART_DIRECTORY + "verify/zones/";
    private static final boolean DEBUG = false;
    static final Option.Options myOptions = new Option.Options();
    static long date = new Date(new Date().getYear(), 0, 15, 0, 0, 0).getTime();
    static long date6 = date + 15724800000L;
    private static final SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    private static final Map<String, Map<String, String>> metazoneToRegionToZone = sdi.getMetazoneToRegionToZone();
    private static final Set<MetazoneRow> rows = new TreeSet<MetazoneRow>();
    private static final Set<String> goldenZones = new HashSet<String>();
    private static final Map<String, Integer> countryToOrder = new HashMap<String, Integer>();
    private static final List<TimezoneFormatter.Format> FORMAT_LIST = Arrays.asList(TimezoneFormatter.Format.VVVV, TimezoneFormatter.Format.vvvv, TimezoneFormatter.Format.v, TimezoneFormatter.Format.zzzz, TimezoneFormatter.Format.z, TimezoneFormatter.Format.zzzz, TimezoneFormatter.Format.z);
    private static String surveyUrl;
    private static String METAZONE_PREFIX;
    private static String METAZONE_SUFFIX;
    private static String METAZONE_SUFFIX2;

    private static void addRow(String metaZone, String tz_string, int orderInMetazone) {
        TimeZone currentZone = TimeZone.getTimeZone(tz_string);
        String container = PathHeader.getMetazonePageTerritory(metaZone);
        if (container == null) {
            return;
        }
        int order = Containment.getOrder(container);
        int offsetOrder = currentZone.getRawOffset();
        orderInMetazone = orderInMetazone << 16 | (VerifyZones.hasDaylight(currentZone) ? 0 : 1) | countryToOrder.get(TimeZone.getRegion(tz_string));
        MetazoneRow row = new MetazoneRow(order, offsetOrder, container, orderInMetazone, metaZone, tz_string);
        if (metaZone.equals("Europe_Central")) {
            // empty if block
        }
        rows.add(row);
    }

    private static void showVennSets(Set<String> zoneSet, Set<String> zonesInMetazones) {
        LinkedHashSet common = new LinkedHashSet();
        LinkedHashSet firstMinusSecond = new LinkedHashSet();
        LinkedHashSet secondMinusFirst = new LinkedHashSet();
        VerifyZones.vennSets(zoneSet, zonesInMetazones, common, firstMinusSecond, secondMinusFirst);
        if (!common.isEmpty()) {
            System.out.println("A & B:\t" + common.size() + "\t" + common);
        }
        if (!firstMinusSecond.isEmpty()) {
            System.out.println("A - B:\t" + firstMinusSecond.size() + "\t" + firstMinusSecond);
        }
        if (!secondMinusFirst.isEmpty()) {
            System.out.println("B - A:\t" + secondMinusFirst.size() + "\t" + secondMinusFirst);
        }
    }

    private static <T> void vennSets(Set<T> first, Set<T> second, Set<T> common, Set<T> firstMinusSecond, Set<T> secondMinusFirst) {
        common.clear();
        common.addAll(first);
        common.retainAll(second);
        firstMinusSecond.clear();
        firstMinusSecond.addAll(first);
        firstMinusSecond.removeAll(common);
        secondMinusFirst.clear();
        secondMinusFirst.addAll(second);
        secondMinusFirst.removeAll(common);
    }

    private static <T> void vennSets(Set<T> first, Set<T> second, Set<T> common) {
        common.clear();
        common.addAll(first);
        common.retainAll(second);
        first.removeAll(common);
        second.removeAll(common);
    }

    private static <T> void vennSets(Set<T> first, Set<T> second) {
        first.removeAll(second);
        second.removeAll(first);
    }

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.organization, args, true);
        String organization = MyOptions.organization.option.getValue();
        String filter = MyOptions.filter.option.getValue();
        String timezoneFilterString = MyOptions.timezoneFilter.option.getValue();
        Matcher timezoneFilter = timezoneFilterString == null ? null : PatternCache.get(timezoneFilterString).matcher("");
        Factory factory2 = Factory.make(CLDRPaths.MAIN_DIRECTORY, filter);
        CLDRFile englishCldrFile = factory2.make("en", true);
        new File(DIR).mkdirs();
        FileCopier.copy(ShowData.class, "verify-index.html", CLDRPaths.VERIFY_DIR, "index.html");
        FileCopier.copy(ChartDelta.class, "index.css", CLDRPaths.VERIFY_DIR, "index.css");
        FormattedFileWriter.copyIncludeHtmls(CLDRPaths.VERIFY_DIR);
        DateTimeFormats.writeCss(DIR);
        CLDRFile english = CLDR_CONFIG.getEnglish();
        TreeMap<Object, CallSite> indexMap = new TreeMap<Object, CallSite>(CollatorHelper.EMOJI_COLLATOR);
        for (String localeID : factory2.getAvailableLanguages()) {
            Level level = StandardCodes.make().getLocaleCoverageLevel(organization, localeID);
            if (Level.MODERN.compareTo(level) > 0) continue;
            CLDRFile cldrFile = factory2.make(localeID, true);
            PrintWriter out = FileUtilities.openUTF8Writer(DIR, localeID + ".html");
            String title = "Verify Time Zones: " + englishCldrFile.nameGetter().getNameFromIdentifier(localeID);
            out.println("<!doctype HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN'><html><head>\n<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>" + title + "</title>\n<link rel='stylesheet' type='text/css' href='index.css'>\n</head><body><h1>" + title + "</h1>\n<p><a href='index.html'>Index</a></p>\n");
            VerifyZones.showZones(timezoneFilter, englishCldrFile, cldrFile, out);
            out.println("</body></html>");
            out.close();
            indexMap.put(english.nameGetter().getNameFromIdentifier(localeID), (CallSite)((Object)(localeID + ".html")));
        }
        try (PrintWriter index = DateTimeFormats.openIndex(DIR, "Time Zones");){
            DateTimeFormats.writeIndexMap(indexMap, index);
        }
    }

    public static void showZones(Matcher timezoneFilter, CLDRFile englishCldrFile, CLDRFile nativeCdrFile, Appendable out) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().setTableAttributes("class='dtf-table'").addColumn("Metazone").setHeaderCell(true).setSpanRows(true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Region: TZID").setHeaderCell(true).setSpanRows(true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'");
        boolean daylight = false;
        for (TimezoneFormatter.Format s2 : FORMAT_LIST) {
            tablePrinter.addColumn(s2.toString() + "<br>" + s2.type.toString(daylight) + "<br>" + s2.location + "<br>" + s2.length).setSpanRows(true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'");
            if (s2 != TimezoneFormatter.Format.z) continue;
            daylight = true;
        }
        tablePrinter.addColumn("View").setHeaderCell(true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'");
        ZoneFormats englishZoneFormats = new ZoneFormats().set(englishCldrFile);
        VerifyZones.addZones(englishZoneFormats, nativeCdrFile, timezoneFilter, tablePrinter);
        out.append(tablePrinter.toString() + "\n");
    }

    private static void addZones(ZoneFormats englishZoneFormats, CLDRFile cldrFile, Matcher timezoneFilter, TablePrinter output) throws IOException {
        CLDRFile englishCldrFile = englishZoneFormats.cldrFile;
        TimezoneFormatter tzformatter = new TimezoneFormatter(cldrFile);
        long timeInMillis = Calendar.getInstance().getTimeInMillis();
        for (MetazoneRow row : rows) {
            String path;
            String view;
            TimeZone currentZone;
            String tzid;
            String metazone = row.getMetazone();
            if (sdi.metazoneIsOutdated(metazone, tzid = row.getZone(), timeInMillis)) continue;
            String grouping = row.getContainer();
            TimeZone tz = currentZone = TimeZone.getTimeZone(tzid);
            String englishGrouping = englishCldrFile.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, grouping);
            String metazoneInfo = englishGrouping + "<br>" + englishZoneFormats.formatGMT(currentZone) + "<br>MZ: " + metazone;
            boolean isGolden = goldenZones.contains(tzid);
            String countryCode2 = TimeZone.getRegion(tzid);
            if (countryCode2.equals("001")) continue;
            String englishTerritory = englishCldrFile.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, countryCode2);
            output.addRow().addCell((Comparable)((Object)metazoneInfo)).addCell((Comparable)((Object)(englishTerritory + ": " + tzid.replace("/", "/\u200b"))));
            long date2 = VerifyZones.getStandardDate(tz);
            for (TimezoneFormatter.Format pattern : FORMAT_LIST) {
                Object formattedZone = tzformatter.getFormattedZone(tzid, pattern.toString(), date2);
                if (isGolden) {
                    formattedZone = "<b>" + (String)formattedZone + "</b>";
                }
                output.addCell((Comparable)formattedZone);
                if (pattern != TimezoneFormatter.Format.z) continue;
                if (!VerifyZones.hasDaylight(tz)) {
                    output.addCell((Comparable)((Object)"<i>n/a</i>"));
                    output.addCell((Comparable)((Object)"<i>n/a</i>"));
                    break;
                }
                date2 = date2 == date ? date6 : date;
            }
            if ((view = PathHeader.getLinkedView(surveyUrl, cldrFile, path = METAZONE_PREFIX + metazone + METAZONE_SUFFIX)) == null) {
                path = METAZONE_PREFIX + metazone + METAZONE_SUFFIX2;
                view = PathHeader.getLinkedView(surveyUrl, cldrFile, path);
            }
            output.addCell((Comparable)((Object)(view == null ? "" : view)));
            output.finishRow();
        }
    }

    private static boolean hasDaylight(TimeZone tz) {
        int dateOffset = tz.getOffset(date);
        return dateOffset != tz.getRawOffset() || dateOffset != tz.getOffset(date6);
    }

    private static long getStandardDate(TimeZone tz) {
        return tz.getOffset(date) == tz.getRawOffset() ? date : date6;
    }

    private static long getDaylightDate(TimeZone tz) {
        return tz.getOffset(date) == tz.getRawOffset() ? date6 : date;
    }

    private static void captureErrors(Set<String> debugCreationErrors, Set<String> errors, String locale, String length) {
        if (debugCreationErrors.size() != 0) {
            for (String s2 : debugCreationErrors) {
                errors.add(locale + "\t" + length + "\t" + s2);
            }
            debugCreationErrors.clear();
        }
    }

    static {
        TreeMap<String, String> nameToCountry = new TreeMap<String, String>();
        String[] zones = TimeZone.getAvailableIDs();
        LinkedHashSet<String> zoneSet = new LinkedHashSet<String>();
        LinkedHashSet<Object> noncanonical = new LinkedHashSet<Object>();
        for (String zone : zones) {
            String countryCode = TimeZone.getRegion(zone);
            String englishTerritory = ULocale.getDisplayCountry("und-" + countryCode, ULocale.ENGLISH);
            nameToCountry.put(englishTerritory, countryCode);
            String canon = TimeZone.getCanonicalID(zone);
            if (canon.equals(zone)) {
                zoneSet.add(canon);
                continue;
            }
            noncanonical.add(zone);
        }
        int i = 0;
        for (Map.Entry entry : nameToCountry.entrySet()) {
            countryToOrder.put((String)entry.getValue(), i++);
        }
        Set<String> metazones = sdi.getAllMetazones();
        LinkedHashSet<String> zonesInMetazones = new LinkedHashSet<String>();
        for (String metazone : metazones) {
            Map<String, String> regionToZone = metazoneToRegionToZone.get(metazone);
            String zone = regionToZone.get("001");
            goldenZones.add(zone);
            zonesInMetazones.add(zone);
            VerifyZones.addRow(metazone, zone, 0);
        }
        VerifyZones.vennSets(zoneSet, zonesInMetazones);
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        block3: for (String zone : zoneSet) {
            Set<SupplementalDataInfo.MetaZoneRange> metaZoneRanges = sdi.getMetaZoneRanges(zone);
            if (metaZoneRanges == null) continue;
            for (SupplementalDataInfo.MetaZoneRange metaZoneRange : metaZoneRanges) {
                if (metaZoneRange.dateRange.getTo() != Long.MAX_VALUE) continue;
                found.add(zone);
                VerifyZones.addRow(metaZoneRange.metazone, zone, 1);
                continue block3;
            }
        }
        for (MetazoneRow row : rows) {
            if (!row.getMetazone().equals("Europe_Central")) continue;
        }
        surveyUrl = CLDR_CONFIG.getProperty("CLDR_SURVEY_URL", "http://st.unicode.org/cldr-apps/survey");
        METAZONE_PREFIX = "//ldml/dates/timeZoneNames/metazone[@type=\"";
        METAZONE_SUFFIX = "\"]/long/generic";
        METAZONE_SUFFIX2 = "\"]/long/standard";
    }

    static class MetazoneRow
    extends Row.R5<Long, String, String, Integer, String> {
        public MetazoneRow(Integer order, Integer rawOffset, String container, int orderInMetazone, String metazone, String zone) {
            super(((long)order.intValue() << 32) + (long)rawOffset.intValue(), container, metazone, orderInMetazone, zone);
        }

        public String getContainer() {
            return (String)this.get1();
        }

        public String getMetazone() {
            return (String)this.get2();
        }

        public String getZone() {
            return (String)this.get4();
        }
    }

    static enum MyOptions {
        organization(".*", "CLDR", "organization"),
        filter(".*", ".*", "locale filter (regex)"),
        timezoneFilter(".*", null, "timezone filter (regex)");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

