/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class XPPUtil {
    public static String getXpathName(String xpath) {
        XPathParts xpp = XPathParts.getFrozenInstance(xpath);
        return xpp.getElement(-1);
    }

    public static String getXpathName(String xpath, int pos) {
        XPathParts xpp = XPathParts.getFrozenInstance(xpath);
        return xpp.getElement(pos);
    }

    public static String getAttributeValue(String xpath, String element, String attribute) {
        XPathParts xpp = XPathParts.getFrozenInstance(xpath);
        int el = xpp.findElement(element);
        if (el == -1) {
            return null;
        }
        return xpp.getAttributeValue(el, attribute);
    }

    public static String getAttributeValue(String xpath, String attribute) {
        XPathParts xpp = XPathParts.getFrozenInstance(xpath);
        return xpp.getAttributeValue(-1, attribute);
    }

    public static String getBasicAttributeValue(CLDRFile whichFile, String xpath, String attribute) {
        String fullPath = whichFile.getFullXPath(xpath);
        if (fullPath == null) {
            return null;
        }
        return XPPUtil.getAttributeValue(fullPath, attribute);
    }

    public static String findAttributeValue(CLDRFile file, String xpath, String attribute) {
        String fullPath = file.getFullXPath(xpath);
        XPathParts xpp = XPathParts.getFrozenInstance(fullPath);
        for (int j = 1; j <= xpp.size(); ++j) {
            String v = xpp.getAttributeValue(0 - j, attribute);
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

