/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ListGrammarInfo {
    public static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    public static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    public static final CLDRFile english = CONFIG.getEnglish();

    public static void main(String[] args) {
        Set<String> locales = GrammarInfo.getGrammarLocales();
        LanguageTagParser ltp = new LanguageTagParser();
        TreeSet<String> sortedGenderLocales = new TreeSet<String>();
        TreeSet<String> sortedCaseLocales = new TreeSet<String>();
        TreeSet<String> sortedBothLocales = new TreeSet<String>();
        for (String locale : locales) {
            boolean hasCase;
            GrammarInfo grammarInfo;
            if (locale.equals("root")) continue;
            ltp.set(locale);
            String region = ltp.getRegion();
            if (!region.isEmpty() || (grammarInfo = SDI.getGrammarInfo(locale, true)) == null || !grammarInfo.hasInfo(GrammarInfo.GrammaticalTarget.nominal)) continue;
            Collection<String> genders = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
            Collection<String> rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
            boolean hasGender = genders != null && genders.size() > 1;
            boolean bl = hasCase = rawCases != null && rawCases.size() > 1;
            if (hasGender) {
                if (hasCase) {
                    sortedBothLocales.add(ListGrammarInfo.format(locale, genders, rawCases));
                    continue;
                }
                sortedGenderLocales.add(ListGrammarInfo.format(locale, genders));
                continue;
            }
            if (!hasCase) continue;
            sortedCaseLocales.add(ListGrammarInfo.format(locale, rawCases));
        }
        System.out.println("Gender\t" + Joiner.on(", ").join(sortedGenderLocales));
        System.out.println("Case\t" + Joiner.on(", ").join(sortedCaseLocales));
        System.out.println("Gender & Case\t" + Joiner.on(", ").join(sortedBothLocales));
    }

    private static String format(String locale, Collection<String> genders, Collection<String> rawCases) {
        return english.nameGetter().getNameFromIdentifier(locale) + " (" + locale + "/" + genders.size() + "\u00d7" + rawCases.size() + ")";
    }

    public static String format(String locale, Collection<String> genders) {
        return english.nameGetter().getNameFromIdentifier(locale) + " (" + locale + "/" + genders.size() + ")";
    }
}

