/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.DateIntervalFormat;
import com.ibm.icu.text.DateIntervalInfo;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.DateInterval;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ChartDelta;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.util.BidiUtils;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CodePointEscaper;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PreferredAndAllowedHour;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class DateTimeFormats {
    private static final UnicodeSet TO_ESCAPE = new UnicodeSet(CodePointEscaper.FORCE_ESCAPE).remove(CodePointEscaper.SP.getCodePoint()).freeze();
    private static final String MISSING_PART = "\u24dc\u24d8\u24e2\u24e2\u24d8\u24dd\u24d6";
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final Date SAMPLE_DATE_DEFAULT_END = new Date(199, 0, 13, 14, 45, 59);
    private static final String DIR = CLDRPaths.CHART_DIRECTORY + "/verify/dates/";
    private static SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    private static Map<String, PreferredAndAllowedHour> timeData = sdi.getTimeData();
    static final Option.Options myOptions = new Option.Options();
    private static final String TIMES_24H_TITLE = "Times 24h";
    private static final boolean DEBUG = false;
    private static final String DEBUG_SKELETON = "y";
    private static final ULocale DEBUG_LIST_PATTERNS = ULocale.JAPANESE;
    private static final String FIELDS_TITLE = "Fields";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final UnicodeSet BIDI_MARKS = new UnicodeSet("[:Bidi_Control:]").freeze();
    private static final String ltrBackground = "background-color:#EEE;";
    private static final String tableBackground = "background-color:#DDF; border: 1px solid blue;";
    private static final String rtlStart = "<div dir='rtl'>";
    private static final String autoLtrStart = "<div dir='auto' style='background-color:#EEE;'>";
    private static final String autoStart = "<div dir='auto'>";
    private static final String divEnd = "</div>";
    private static final String tableStyle = "style='border-collapse: collapse;background-color:#DDF; border: 1px solid blue; margin: auto'";
    private static final String ltrSpan = "<span style='background-color:#EEE;'>";
    private static final String tableSpan = "<span style='background-color:#DDF; border: 1px solid blue;'>";
    private static final String spanEnd = "</span>";
    private static final String[] STOCK = new String[]{"short", "medium", "long", "full"};
    private static final String[] CALENDAR_FIELD_TO_PATTERN_LETTER = new String[]{"G", "y", "M", "w", "W", "d", "D", "E", "F", "a", "h", "H", "m"};
    private static final Date SAMPLE_DATE = new Date(112, 0, 13, 14, 45, 59);
    private static final String SAMPLE_DATE_STRING = CldrUtility.isoFormat(SAMPLE_DATE);
    private static final Map<String, Date> SAMPLE_DATE_END = ImmutableMap.builder().put("G", SAMPLE_DATE_DEFAULT_END).put("y", new Date(113, 0, 13, 14, 45, 59)).put("M", new Date(112, 1, 13, 14, 45, 59)).put("w", SAMPLE_DATE_DEFAULT_END).put("W", SAMPLE_DATE_DEFAULT_END).put("d", new Date(112, 0, 14, 14, 45, 59)).put("D", SAMPLE_DATE_DEFAULT_END).put("E", new Date(112, 0, 14, 14, 45, 59)).put("F", SAMPLE_DATE_DEFAULT_END).put("a", new Date(112, 0, 13, 2, 45, 59)).put("h", new Date(112, 0, 13, 15, 45, 59)).put("H", new Date(112, 0, 13, 15, 45, 59)).put("m", new Date(112, 0, 13, 14, 46, 59)).build();
    private DateTimePatternGenerator generator;
    private ULocale locale;
    private ICUServiceBuilder icuServiceBuilder;
    private ICUServiceBuilder icuServiceBuilderEnglish = new ICUServiceBuilder().setCldrFile(CONFIG.getEnglish());
    private DateIntervalInfo dateIntervalInfo = new DateIntervalInfo();
    private String calendarID;
    private CLDRFile file;
    private boolean isRTL;
    private static String surveyUrl = CONFIG.getProperty("CLDR_SURVEY_URL", "http://st.unicode.org/cldr-apps/survey");
    private static final String[] FIELD_NAMES = new String[]{"era", "year", "quarter", "month", "week", "week_of_month", "weekday", "day", "day_of_year", "day_of_week_in_month", "dayperiod", "hour", "minute", "second", "fractional_second", "zone"};
    private static final String[][] NAME_AND_PATTERN;
    static final Pattern RELATIVE_DATE;
    private static final boolean RETIRE = false;
    private static final String LOCALES = ".*";

    public DateTimeFormats set(CLDRFile file, String calendarID) {
        return this.set(file, calendarID, true);
    }

    public DateTimeFormats set(CLDRFile file, String calendarID, boolean useStock) {
        this.file = file;
        this.locale = new ULocale(file.getLocaleID());
        this.icuServiceBuilder = new ICUServiceBuilder().setCldrFile(file);
        DateTimePatternGenerator.PatternInfo returnInfo = new DateTimePatternGenerator.PatternInfo();
        this.generator = DateTimePatternGenerator.getEmptyInstance();
        this.calendarID = calendarID;
        boolean haveDefaultHourChar = false;
        String characterOrder = file.getStringValue("//ldml/layout/orientation/characterOrder");
        this.isRTL = characterOrder != null && characterOrder.equals("right-to-left");
        block0: for (String stock : STOCK) {
            String path = "//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/dateFormats/dateFormatLength[@type=\"" + stock + "\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
            String dateTimePattern = file.getStringValue(path);
            if (useStock) {
                this.generator.addPattern(dateTimePattern, true, returnInfo);
            }
            path = "//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/timeFormats/timeFormatLength[@type=\"" + stock + "\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
            dateTimePattern = file.getStringValue(path);
            if (useStock) {
                this.generator.addPattern(dateTimePattern, true, returnInfo);
            }
            if (haveDefaultHourChar) continue;
            DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
            fp.set(dateTimePattern);
            List<Object> items = fp.getItems();
            for (int idx = 0; idx < items.size(); ++idx) {
                DateTimePatternGenerator.VariableField fld;
                Object item = items.get(idx);
                if (!(item instanceof DateTimePatternGenerator.VariableField) || (fld = (DateTimePatternGenerator.VariableField)item).getType() != 11) continue;
                this.generator.setDefaultHourFormatChar(fld.toString().charAt(0));
                haveDefaultHourChar = true;
                continue block0;
            }
        }
        for (String path : With.in(file.iterator("//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/dateTimeFormats/appendItems/appendItem"))) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String request = parts.getAttributeValue(-1, "request");
            int requestNumber = DateTimePatternGenerator.getAppendFormatNumber(request);
            String value = file.getStringValue(path);
            this.generator.setAppendItemFormat(requestNumber, value);
        }
        for (String path : With.in(file.iterator("//ldml/dates/fields/field"))) {
            if (!path.contains("displayName")) continue;
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String type = parts.getAttributeValue(-2, "type");
            int requestNumber = this.find(FIELD_NAMES, type);
            String value3 = file.getStringValue(path);
            this.generator.setAppendItemName(requestNumber, value3);
        }
        for (String path : With.in(file.iterator("//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/dateTimeFormats/availableFormats/dateFormatItem"))) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            if ("ascii".equals(parts.findAttributeValue("dateFormatItem", "alt"))) continue;
            String key = parts.getAttributeValue(-1, "id");
            String value2 = file.getStringValue(path);
            if (key.equals(DEBUG_SKELETON)) {
                boolean value3 = false;
            }
            this.generator.addPatternWithSkeleton(value2, key, true, returnInfo);
        }
        this.generator.setDateTimeFormat(Calendar.getDateTimePattern(Calendar.getInstance(this.locale), this.locale, 2));
        for (String path : With.in(file.iterator("//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/dateTimeFormats/intervalFormats/intervalFormatItem"))) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String skeleton = parts.getAttributeValue(-2, "id");
            String diff = parts.getAttributeValue(-1, "id");
            int diffNumber = this.find(CALENDAR_FIELD_TO_PATTERN_LETTER, diff);
            String intervalPattern = file.getStringValue(path);
            this.dateIntervalInfo.setIntervalPattern(skeleton, diffNumber, intervalPattern);
        }
        if (useStock) {
            this.dateIntervalInfo.setFallbackIntervalPattern(file.getStringValue("//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/dateTimeFormats/intervalFormats/intervalFormatFallback"));
        }
        return this;
    }

    private <T> int find(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return 0;
    }

    public void addTable(DateTimeFormats comparison, Appendable output) {
        UnicodeSet allEscapedCharactersFound = new UnicodeSet();
        try {
            output.append("<h2>" + this.hackDoubleLinked("Patterns") + "</h2><p>Normally, there is a single line containing an example in each Native Example cell. " + (!this.isRTL ? "" : "However, two examples are provided if the locale is right-to-left, like Arabic or Hebrew, <i>and</i> the paragraph direction can cause a different display. The first has a <b>RTL</b> paragraph direction, while the second has a <b>auto</b> paragraph direction (LTR unless the first 'strong' character is RTL) <span style='background-color:#EEE;'><i>and</i> a different background</span>. If the display of either example appears to cause strings of letters or numbers to collide, then a \u26a0\ufe0f is shown followed by differences (this is still experimental). ") + "When an example has hidden characters, then <span style='background-color:#DDF; border: 1px solid blue;'>an extra line</span> shows those characters with short IDs \u2770\u2026\u2771: see the <b>Key</b> below the table. So that the ordering of the characters in memory is clear, they are presented left-to-right one at a time. so that the placement is clear. When a pattern (or a component of a pattern) is missing, it is displayed as \u24dc\u24d8\u24e2\u24e2\u24d8\u24dd\u24d6.</p>\n<table class='dtf-table'>");
            Diff diff = new Diff();
            boolean is24h = this.generator.getDefaultHourFormatChar() == 'H';
            this.showRow(output, RowStyle.header, FIELDS_TITLE, "Skeleton", "English Example", "Native Example", false);
            for (String[] nameAndSkeleton : NAME_AND_PATTERN) {
                String name = nameAndSkeleton[0];
                String skeleton = nameAndSkeleton[1];
                if (skeleton.equals(DEBUG_SKELETON)) {
                    boolean bl = false;
                }
                if (name.equals("-")) {
                    if (is24h && skeleton.equals(TIMES_24H_TITLE)) continue;
                    this.showRow(output, RowStyle.separator, skeleton, null, null, null, false);
                    continue;
                }
                if (is24h && skeleton.contains("H")) continue;
                this.showRow(output, RowStyle.normal, name, skeleton, comparison.getExample(skeleton, allEscapedCharactersFound), this.getExample(skeleton, allEscapedCharactersFound), diff.isPresent(skeleton));
            }
            if (!diff.availablePatterns.isEmpty()) {
                this.showRow(output, RowStyle.separator, "Additional Patterns in Locale data", null, null, null, false);
                for (String skeleton : diff.availablePatterns) {
                    if (skeleton.equals(DEBUG_SKELETON)) {
                        int n = 0;
                    }
                    if (is24h && (skeleton.contains("h") || skeleton.contains("a")) || skeleton.contains("v") || skeleton.contains("z") || skeleton.contains("Q") && !skeleton.contains("QQ") || skeleton.equals("D") || skeleton.equals("F") || skeleton.equals("S") || skeleton.equals("W") || skeleton.equals("w")) continue;
                    this.showRow(output, RowStyle.normal, skeleton, skeleton, comparison.getExample(skeleton, allEscapedCharactersFound), this.getExample(skeleton, allEscapedCharactersFound), true);
                }
            }
            output.append("</table>");
            if (!allEscapedCharactersFound.isEmpty()) {
                output.append("\n<h3>Key to Escaped Characters</h3>\n");
                String keyToEscaped = CodePointEscaper.getHtmlRows(allEscapedCharactersFound, " style='border:1px solid blue; border-collapse: collapse'", " style='border:1px solid blue'");
                output.append(keyToEscaped);
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private String getExample(String skeleton, UnicodeSet escapedCharactersFound) {
        String example;
        if (skeleton.contains("\u00ae")) {
            example = this.getRelativeExampleFromSkeleton(skeleton);
        } else {
            int slashPos = skeleton.indexOf(47);
            if (slashPos >= 0) {
                String mainSkeleton = skeleton.substring(0, slashPos);
                DateIntervalFormat dateIntervalFormat = new DateIntervalFormat(mainSkeleton, this.dateIntervalInfo, this.icuServiceBuilder.getDateFormat(this.calendarID, this.generator.getBestPattern(mainSkeleton)));
                String diffString = skeleton.substring(slashPos + 1).replace('j', 'H');
                Date endDate = SAMPLE_DATE_END.get(diffString);
                try {
                    example = dateIntervalFormat.format(new DateInterval(SAMPLE_DATE.getTime(), endDate.getTime()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(skeleton + ", " + String.valueOf(endDate), e);
                }
            } else {
                if (skeleton.equals(DEBUG_SKELETON)) {
                    boolean mainSkeleton = false;
                }
                SimpleDateFormat format = this.getDateFormatFromSkeleton(skeleton);
                format.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
                example = format.format(SAMPLE_DATE);
            }
        }
        Object transformedExample = TransliteratorUtilities.toHTML.transform(example);
        ArrayList<String> listOfReorderings = new ArrayList<String>();
        if ((this.isRTL || BIDI_MARKS.containsSome(example)) && !example.contains(MISSING_PART)) {
            if (!BidiUtils.isOrderingUnchanged(example, listOfReorderings, 126, 1)) {
                String rtlVersion = rtlStart + (String)transformedExample + divEnd;
                String autoVersion = autoLtrStart + (String)transformedExample + divEnd;
                String alert = BidiUtils.getAlert(listOfReorderings);
                transformedExample = rtlVersion + autoVersion + alert;
            } else {
                String autoVersion = autoStart + (String)transformedExample + divEnd;
                transformedExample = autoVersion;
            }
        }
        if (TO_ESCAPE.containsSome(example)) {
            StringBuilder processed = new StringBuilder();
            example.codePoints().forEach(x -> processed.append("<td>").append(TransliteratorUtilities.toHTML.transform(CodePointEscaper.getEscaped(x, TO_ESCAPE))).append("</td>"));
            transformedExample = (String)transformedExample + "<table style='border-collapse: collapse;background-color:#DDF; border: 1px solid blue; margin: auto'><tr>" + String.valueOf(processed) + "</tr></table>";
            escapedCharactersFound.addAll(new UnicodeSet().addAll(example).retainAll(TO_ESCAPE));
        }
        return transformedExample;
    }

    private String getRelativeExampleFromSkeleton(String skeleton) {
        RelativePattern rp = new RelativePattern(this.file, skeleton);
        String value = rp.value;
        if (value == null) {
            value = MISSING_PART;
        } else {
            DecimalFormat format = this.icuServiceBuilder.getNumberFormat(0);
            value = value.replace("{0}", format.format(Math.abs(rp.offset)).replace("'", "''"));
        }
        if (rp.time == null) {
            return value;
        }
        SimpleDateFormat format2 = this.getDateFormatFromSkeleton(rp.time);
        format2.setTimeZone(GMT);
        String formattedTime = format2.format(SAMPLE_DATE);
        String path2 = this.getDTSeparator("full", "atType");
        String datetimePattern = this.file.getStringValue(this.getDTSeparator("full", "atType"));
        if (datetimePattern == null) {
            datetimePattern = this.file.getStringValue(this.getDTSeparator("full", "standard"));
        }
        datetimePattern = datetimePattern.replace("'", "");
        return MessageFormat.format(datetimePattern, formattedTime, value);
    }

    private String getDTSeparator(String length, String type) {
        String path = "//ldml/dates/calendars/calendar[@type=\"" + this.calendarID + "\"]/dateTimeFormats/dateTimeFormatLength[@type=\"" + length + "\"]/dateTimeFormat[@type=\"" + type + "\"]/pattern[@type=\"standard\"]";
        return path;
    }

    public SimpleDateFormat getDateFormatFromSkeleton(String skeleton) {
        String pattern = this.getBestPattern(skeleton);
        return this.getDateFormat(pattern);
    }

    private SimpleDateFormat getDateFormat(String pattern) {
        SimpleDateFormat format = this.icuServiceBuilder.getDateFormat(this.calendarID, pattern);
        format.setTimeZone(GMT);
        return format;
    }

    public String getBestPattern(String skeleton) {
        String pattern = this.generator.getBestPattern(skeleton);
        return pattern;
    }

    private void showRow(Appendable output, RowStyle rowStyle, String name, String skeleton, String english, String example, boolean isPresent) throws IOException {
        output.append("<tr>");
        switch (rowStyle) {
            case separator: {
                String link = name.replace(' ', '_');
                output.append("<th colSpan='3' class='dtf-sep'>").append(this.hackDoubleLinked(link, name)).append("</th>");
                break;
            }
            case header: 
            case normal: {
                String fix;
                String endCell;
                String startCell = rowStyle == RowStyle.header ? "<th class='dtf-h'>" : "<td class='dtf-s'>";
                String string = endCell = rowStyle == RowStyle.header ? "</th>" : "</td>";
                if (name.equals(FIELDS_TITLE)) {
                    output.append("<th class='dtf-th'>").append(name).append("</a></th>");
                } else {
                    String indent = "";
                    if (name.startsWith(" ")) {
                        indent = "&nbsp;&nbsp;&nbsp;";
                        name = name.trim();
                    }
                    output.append("<th class='dtf-left'>" + indent + this.hackDoubleLinked(skeleton, name) + "</th>");
                }
                output.append(startCell).append(english).append(endCell).append(startCell).append(example).append(endCell);
                if (rowStyle == RowStyle.header || (fix = this.getFix(skeleton)) == null) break;
                output.append(startCell).append(fix).append(endCell);
            }
        }
        output.append("</tr>\n");
    }

    private String getFix(String skeleton) {
        String value;
        Object path;
        if (skeleton.contains("\u00ae")) {
            RelativePattern rp = new RelativePattern(this.file, skeleton);
            path = rp.path;
            value = rp.value;
        } else {
            int slashPos = (skeleton = skeleton.replace('j', this.generator.getDefaultHourFormatChar())).indexOf(47);
            if (slashPos >= 0) {
                String mainSkeleton = skeleton.substring(0, slashPos);
                String diff = skeleton.substring(slashPos + 1);
                path = "//ldml/dates/calendars/calendar[@type=\"" + this.calendarID + "\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"" + mainSkeleton + "\"]/greatestDifference[@id=\"" + diff + "\"]";
            } else {
                path = this.getAvailableFormatPath(skeleton);
            }
            value = this.file.getStringValue((String)path);
        }
        if (value == null) {
            String skeleton2 = skeleton.replace("MMMM", "MMM").replace("EEEE", "E").replace("QQQQ", "QQQ");
            if (!skeleton.equals(skeleton2)) {
                return this.getFix(skeleton2);
            }
            return null;
        }
        return this.getFixFromPath((String)path);
    }

    private String getAvailableFormatPath(String skeleton) {
        String path = "//ldml/dates/calendars/calendar[@type=\"" + this.calendarID + "\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + skeleton + "\"]";
        return path;
    }

    public String getFixFromPath(String path) {
        String result = PathHeader.getLinkedView(surveyUrl, this.file, path);
        return result == null ? "" : result;
    }

    public void addDateTable(CLDRFile english, Appendable output) {
        try {
            output.append("<h2>" + this.hackDoubleLinked("Weekdays") + "</h2>\n");
            this.addDateSubtable("//ldml/dates/calendars/calendar[@type=\"CALENDAR\"]/days/dayContext[@type=\"FORMAT\"]/dayWidth[@type=\"WIDTH\"]/day[@type=\"TYPE\"]", english, output, "sun", "mon", "tue", "wed", "thu", "fri", "sat");
            output.append("<h2>" + this.hackDoubleLinked("Months") + "</h2>\n");
            this.addDateSubtable("//ldml/dates/calendars/calendar[@type=\"CALENDAR\"]/months/monthContext[@type=\"FORMAT\"]/monthWidth[@type=\"WIDTH\"]/month[@type=\"TYPE\"]", english, output, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12");
            output.append("<h2>" + this.hackDoubleLinked("Quarters") + "</h2>\n");
            this.addDateSubtable("//ldml/dates/calendars/calendar[@type=\"CALENDAR\"]/quarters/quarterContext[@type=\"FORMAT\"]/quarterWidth[@type=\"WIDTH\"]/quarter[@type=\"TYPE\"]", english, output, "1", "2", "3", "4");
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void addDateSubtable(String path, CLDRFile english, Appendable output, String ... types) throws IOException {
        path = path.replace("CALENDAR", this.calendarID);
        output.append("<table class='dtf-table'>\n<tr><th class='dtf-th'>English</th><th class='dtf-th'>Wide</th><th class='dtf-th'>Abbr.</th><th class='dtf-th'>Narrow</th></tr>\n");
        for (String type : types) {
            String path1 = path.replace("TYPE", type);
            output.append("<tr>");
            boolean first = true;
            for (String width : Arrays.asList("wide", "abbreviated", "narrow")) {
                String path2 = path1.replace("WIDTH", width);
                String last = null;
                String lastPath = null;
                for (String format : Arrays.asList("format", "stand-alone")) {
                    String value;
                    String path3 = path2.replace("FORMAT", format);
                    if (first) {
                        value = english.getStringValue(path3);
                        output.append("<th class='dtf-left'>").append(TransliteratorUtilities.toHTML.transform(value)).append("</th>");
                        first = false;
                    }
                    value = this.file.getStringValue(path3);
                    if (last == null) {
                        last = value;
                        lastPath = path3;
                        continue;
                    }
                    String lastFix = this.getFixFromPath(lastPath);
                    output.append("<td class='dtf-nopad'><table class='dtf-int'><tr><td>").append(TransliteratorUtilities.toHTML.transform(last));
                    if (lastFix != null) {
                        output.append("</td><td class='dtf-fix'>").append(lastFix);
                    }
                    if (!value.equals(last)) {
                        String fix = this.getFixFromPath(path3);
                        output.append("</td></tr><tr><td>").append(TransliteratorUtilities.toHTML.transform(value));
                        if (fix != null) {
                            output.append("</td><td class='dtf-fix'>").append(fix);
                        }
                    }
                    output.append("</td></tr></table></td>");
                }
            }
            output.append("</tr>\n");
        }
        output.append("</table>\n");
    }

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.organization, args, true);
        String organization = MyOptions.organization.option.getValue();
        String filter = MyOptions.filter.option.getValue();
        boolean hasFilter = MyOptions.filter.option.doesOccur();
        CLDRFile englishFile = CONFIG.getEnglish();
        Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, filter);
        Set<String> availableLocales = hasFilter ? factory.getAvailable() : factory.getAvailableLanguages();
        System.out.println("Total locales: " + availableLocales.size());
        DateTimeFormats english = new DateTimeFormats().set(englishFile, "gregorian");
        new File(DIR).mkdirs();
        FileCopier.copy(ShowData.class, "verify-index.html", CLDRPaths.VERIFY_DIR, "index.html");
        FileCopier.copy(ChartDelta.class, "index.css", CLDRPaths.VERIFY_DIR, "index.css");
        FormattedFileWriter.copyIncludeHtmls(CLDRPaths.VERIFY_DIR);
        PrintWriter index = DateTimeFormats.openIndex(DIR, "Date/Time");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
        Set<String> defaultContent = sdi.getDefaultContentLocales();
        for (String localeID : availableLocales) {
            Level level = StandardCodes.make().getLocaleCoverageLevel(organization, localeID);
            if (Level.MODERN.compareTo(level) > 0) continue;
            if (defaultContent.contains(localeID)) {
                System.out.println("Skipping default content: " + localeID);
                continue;
            }
            sorted.put(englishFile.nameGetter().getNameFromIdentifierCompoundOnly(localeID), localeID);
        }
        DateTimeFormats.writeCss(DIR);
        int oldFirst = 0;
        for (Map.Entry nameAndLocale : sorted.entrySet()) {
            String name = (String)nameAndLocale.getKey();
            String localeID = (String)nameAndLocale.getValue();
            DateTimeFormats formats = new DateTimeFormats().set(factory.make(localeID, true), "gregorian");
            String filename = localeID + ".html";
            PrintWriter out = FileUtilities.openUTF8Writer(DIR, filename);
            String redirect = "http://st.unicode.org/cldr-apps/survey?_=" + localeID + "&x=r_datetime&calendar=gregorian";
            out.println("<!doctype HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN'><html><head>\n<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>Date/Time Charts: " + name + "</title>\n<link rel='stylesheet' type='text/css' href='index.css'>\n</head><body><h1>Date/Time Charts: " + name + "</h1><p><a href='index.html'>Index</a></p>\n<p>The following chart shows typical usage of date and time formatting with the Gregorian calendar and default number system. <i>There is important information on <a target='CLDR_ST_DOCS' href='http://cldr.unicode.org/translation/date-time-review'>Date/Time Review</a>, so please read that page before starting!</i></p>\n");
            formats.addTable(english, out);
            formats.addDateTable(englishFile, out);
            formats.addDayPeriods(englishFile, out);
            out.println("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");
            out.println("</body></html>");
            out.close();
            int first = name.codePointAt(0);
            if (oldFirst != first) {
                index.append("<hr>");
                oldFirst = first;
            } else {
                index.append(" \u00a0");
            }
            index.append("<a href='").append(filename).append("'>").append(name).append("</a>\n");
            index.flush();
        }
        index.println("</div></body></html>");
        index.close();
    }

    public static PrintWriter openIndex(String directory, String title) throws IOException {
        String dateString = CldrUtility.isoFormatDateOnly(new Date());
        PrintWriter index = FileUtilities.openUTF8Writer(directory, "index.html");
        index.println("<!doctype HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN'><html><head>\n<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>" + title + " Charts</title>\n</head><body><h1>" + title + " Charts</h1><p style='float:left; text-align:left'><a href='../index.html'>Index</a></p>\n<p style='float:right; text-align:right'>" + dateString + "</p>\n<div style='clear:both; margin:2em'>");
        return index;
    }

    public static void writeCss(String directory) throws IOException {
        PrintWriter out = FileUtilities.openUTF8Writer(directory, "index.css");
        out.println(".dtf-table, .dtf-int {margin-left:auto; margin-right:auto; border-collapse:collapse;}\n.dtf-table, .dtf-s, .dtf-nopad, .dtf-fix, .dtf-th, .dtf-h, .dtf-sep, .dtf-left, .dtf-int {border:1px solid gray;}\n.dtf-th {background-color:#EEE; padding:4px}\n.dtf-s, .dtf-nopad, .dtf-fix {padding:3px; text-align:center}\n.dtf-sep {background-color:#EEF; text-align:center}\n.dtf-s {text-align:center;}\n.dtf-int {width:100%; height:100%}\n.dtf-fix {width:1px}\n.dtf-left {text-align:left;}\n.dtf-nopad {padding:0px; align:top}\n.dtf-gray {background-color:#EEF}\n");
        out.close();
    }

    public void addDayPeriods(CLDRFile englishFile, Appendable output) {
        try {
            output.append("<h2>" + this.hackDoubleLinked("Day Periods") + "</h2>\n");
            output.append("<p>Please review these and correct if needed. The Wide fields are the most important. To correct them, go to " + this.getFixFromPath(ICUServiceBuilder.getDayPeriodPath(DayPeriodInfo.DayPeriod.am, ICUServiceBuilder.Context.format, ICUServiceBuilder.Width.wide)) + " and following. <b>Note: </b>Day Periods can be a bit tricky; for more information, see <a target='CLDR-ST-DOCS' href='http://cldr.unicode.org/translation/date-time-names#TOC-Day-Periods-AM-and-PM-'>Day Periods</a>.</p>\n");
            output.append("<table class='dtf-table'>\n<tr><th class='dtf-th' rowSpan='3'>DayPeriodID</th><th class='dtf-th' rowSpan='3'>Time Span(s)</th><th class='dtf-th' colSpan='4'>Format</th><th class='dtf-th' colSpan='4'>Standalone</th></tr>\n<tr><th class='dtf-th' colSpan='2'>Wide</th><th class='dtf-th'>Abbreviated</th><th class='dtf-th'>Narrow</th><th class='dtf-th' colSpan='2'>Wide</th><th class='dtf-th'>Abbreviated</th><th class='dtf-th'>Narrow</th></tr>\n<tr><th class='dtf-th'>English</th><th class='dtf-th'>Native</th><th class='dtf-th'>Native</th><th class='dtf-th'>Native</th><th class='dtf-th'>English</th><th class='dtf-th'>Native</th><th class='dtf-th'>Native</th><th class='dtf-th'>Native</th></tr>\n");
            DayPeriodInfo dayPeriodInfo = sdi.getDayPeriods(DayPeriodInfo.Type.format, this.file.getLocaleID());
            LinkedHashSet<DayPeriodInfo.DayPeriod> dayPeriods = new LinkedHashSet<DayPeriodInfo.DayPeriod>(dayPeriodInfo.getPeriods());
            DayPeriodInfo dayPeriodInfo2 = sdi.getDayPeriods(DayPeriodInfo.Type.format, "en");
            EnumSet<DayPeriodInfo.DayPeriod> eDayPeriods = EnumSet.copyOf(dayPeriodInfo2.getPeriods());
            Output<Boolean> real = new Output<Boolean>();
            Output<Boolean> realEnglish = new Output<Boolean>();
            for (DayPeriodInfo.DayPeriod period : dayPeriods) {
                Row.R3<Integer, Integer, Boolean> first = dayPeriodInfo.getFirstDayPeriodInfo(period);
                int midPoint = ((Integer)first.get0() + (Integer)first.get1()) / 2;
                output.append("<tr>");
                output.append("<th class='dtf-left'>").append(TransliteratorUtilities.toHTML.transform(period.toString())).append("</th>\n");
                String periods = dayPeriodInfo.toString(period);
                output.append("<th class='dtf-left'>").append(TransliteratorUtilities.toHTML.transform(periods)).append("</th>\n");
                for (ICUServiceBuilder.Context context : ICUServiceBuilder.Context.values()) {
                    for (ICUServiceBuilder.Width width : ICUServiceBuilder.Width.values()) {
                        String dayPeriodPath = ICUServiceBuilder.getDayPeriodPath(period, context, width);
                        if (width == ICUServiceBuilder.Width.wide) {
                            String englishValue;
                            if (context == ICUServiceBuilder.Context.format) {
                                englishValue = this.icuServiceBuilderEnglish.formatDayPeriod(midPoint, context, width);
                                realEnglish.value = true;
                            } else {
                                englishValue = this.icuServiceBuilderEnglish.getDayPeriodValue(dayPeriodPath, null, realEnglish);
                            }
                            output.append("<th class='dtf-left" + ((Boolean)realEnglish.value != false ? "" : " dtf-gray") + "'>").append(this.getCleanValue(englishValue, width, "<i>unused</i>")).append("</th>\n");
                        }
                        String nativeValue = this.icuServiceBuilder.getDayPeriodValue(dayPeriodPath, "\ufffd", real);
                        if (context == ICUServiceBuilder.Context.format) {
                            nativeValue = this.icuServiceBuilder.formatDayPeriod(midPoint, nativeValue);
                        }
                        output.append("<td class='dtf-left" + ((Boolean)real.value != false ? "" : " dtf-gray") + "'>").append(this.getCleanValue(nativeValue, width, "<i>missing</i>")).append("</td>\n");
                    }
                }
                output.append("</tr>\n");
            }
            output.append("</table>\n");
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private String getCleanValue(String evalue, ICUServiceBuilder.Width width, String fallback) {
        String replacement = width == ICUServiceBuilder.Width.wide ? fallback : "<i>optional</i>";
        String qevalue = evalue != null ? TransliteratorUtilities.toHTML.transform(evalue) : replacement;
        return qevalue.replace("\ufffd", replacement);
    }

    private String hackDoubleLinked(String link, String name) {
        return name;
    }

    private String hackDoubleLinked(String string) {
        return string;
    }

    static void writeIndexMap(Map<String, String> nameToFile, PrintWriter index) {
        int oldFirst = 0;
        for (Map.Entry<String, String> entry : nameToFile.entrySet()) {
            String name = entry.getKey();
            String file = entry.getValue();
            int first = name.codePointAt(0);
            if (oldFirst != first) {
                index.append("<hr>");
                oldFirst = first;
            } else {
                index.append(" \u00a0");
            }
            index.append("<a href='").append(file).append("'>").append(name).append("</a>\n");
            index.flush();
        }
        index.println("</div></body></html>");
    }

    static {
        if (FIELD_NAMES.length != 16) {
            throw new IllegalArgumentException("Internal error " + FIELD_NAMES.length + "\t16");
        }
        NAME_AND_PATTERN = new String[][]{{"-", "Full Month"}, {"year month", "yMMMM"}, {" to  month+1", "yMMMM/M"}, {" to  year+1", "yMMMM/y"}, {"year month day", "yMMMMd"}, {" to  day+1", "yMMMMd/d"}, {" to  month+1", "yMMMMd/M"}, {" to  year+1", "yMMMMd/y"}, {"year month day weekday", "yMMMMEEEEd"}, {" to  day+1", "yMMMMEEEEd/d"}, {" to  month+1", "yMMMMEEEEd/M"}, {" to  year+1", "yMMMMEEEEd/y"}, {"month day", "MMMMd"}, {" to  day+1", "MMMMd/d"}, {" to  month+1", "MMMMd/M"}, {"month day weekday", "MMMMEEEEd"}, {" to  day+1", "MMMMEEEEd/d"}, {" to  month+1", "MMMMEEEEd/M"}, {"-", "Abbreviated Month"}, {"year month<sub>a</sub>", "yMMM"}, {" to  month+1", "yMMM/M"}, {" to  year+1", "yMMM/y"}, {"year month<sub>a</sub> day", "yMMMd"}, {" to  day+1", "yMMMd/d"}, {" to  month+1", "yMMMd/M"}, {" to  year+1", "yMMMd/y"}, {"year month<sub>a</sub> day weekday", "yMMMEd"}, {" to  day+1", "yMMMEd/d"}, {" to  month+1", "yMMMEd/M"}, {" to  year+1", "yMMMEd/y"}, {"month<sub>a</sub> day", "MMMd"}, {" to  day+1", "MMMd/d"}, {" to  month+1", "MMMd/M"}, {"month<sub>a</sub> day weekday", "MMMEd"}, {" to  day+1", "MMMEd/d"}, {" to  month+1", "MMMEd/M"}, {"-", "Numeric Month"}, {"year month<sub>n</sub>", "yM"}, {" to  month+1", "yM/M"}, {" to  year+1", "yM/y"}, {"year month<sub>n</sub> day", "yMd"}, {" to  day+1", "yMd/d"}, {" to  month+1", "yMd/M"}, {" to  year+1", "yMd/y"}, {"year month<sub>n</sub> day weekday", "yMEd"}, {" to  day+1", "yMEd/d"}, {" to  month+1", "yMEd/M"}, {" to  year+1", "yMEd/y"}, {"month<sub>n</sub> day", "Md"}, {" to  day+1", "Md/d"}, {" to  month+1", "Md/M"}, {"month<sub>n</sub> day weekday", "MEd"}, {" to  day+1", "MEd/d"}, {" to  month+1", "MEd/M"}, {"-", "Other Dates"}, {"year", DEBUG_SKELETON}, {" to  year+1", "y/y"}, {"year quarter", "yQQQQ"}, {"year quarter<sub>a</sub>", "yQQQ"}, {"quarter", "QQQQ"}, {"quarter<sub>a</sub>", "QQQ"}, {"month", "MMMM"}, {" to  month+1", "MMMM/M"}, {"month<sub>a</sub>", "MMM"}, {" to  month+1", "MMM/M"}, {"month<sub>n</sub>", "M"}, {" to  month+1", "M/M"}, {"day", "d"}, {" to  day+1", "d/d"}, {"day weekday", "Ed"}, {" to  day+1", "Ed/d"}, {"weekday", "EEEE"}, {" to  weekday+1", "EEEE/E"}, {"weekday<sub>a</sub>", "E"}, {" to  weekday+1", "E/E"}, {"-", "Times"}, {"hour", "j"}, {" to  hour+1", "j/j"}, {"hour minute", "jm"}, {" to  minute+1", "jm/m"}, {" to  hour+1", "jm/j"}, {"hour minute second", "jms"}, {"minute second", "ms"}, {"minute", "m"}, {"second", "s"}, {"-", TIMES_24H_TITLE}, {"hour<sub>24</sub>", "H"}, {" to  hour+1", "H/H"}, {"hour<sub>24</sub> minute", "Hm"}, {" to  minute+1", "Hm/m"}, {" to  hour+1", "Hm/H"}, {"hour<sub>24</sub> minute second", "Hms"}, {"-", "Dates and Times"}, {"month, day, hour, minute", "Mdjm"}, {"month, day, hour, minute", "MMMdjm"}, {"month, day, hour, minute", "MMMMdjm"}, {"year month, day, hour, minute", "yMdjms"}, {"year month, day, hour, minute", "yMMMdjms"}, {"year month, day, hour, minute", "yMMMMdjms"}, {"year month, day, hour, minute, zone", "yMMMMdjmsv"}, {"year month, day, hour, minute, zone (long)", "yMMMMdjmsvvvv"}, {"-", "Relative Dates"}, {"3 years ago", "\u00aeyear-past-long-3"}, {"2 years ago", "\u00aeyear-past-long-2"}, {"Last year", "\u00aeyear-1"}, {"This year", "\u00aeyear0"}, {"Next year", "\u00aeyear1"}, {"2 years from now", "\u00aeyear-future-long-2"}, {"3 years from now", "\u00aeyear-future-long-3"}, {"3 months ago", "\u00aemonth-past-long-3"}, {"Last month", "\u00aemonth-1"}, {"This month", "\u00aemonth0"}, {"Next month", "\u00aemonth1"}, {"3 months from now", "\u00aemonth-future-long-3"}, {"6 weeks ago", "\u00aeweek-past-long-3"}, {"Last week", "\u00aeweek-1"}, {"This week", "\u00aeweek0"}, {"Next week", "\u00aeweek1"}, {"6 weeks from now", "\u00aeweek-future-long-3"}, {"Last Sunday", "\u00aesun-1"}, {"This Sunday", "\u00aesun0"}, {"Next Sunday", "\u00aesun1"}, {"Last Sunday + time", "\u00aesun-1jm"}, {"This Sunday + time", "\u00aesun0jm"}, {"Next Sunday + time", "\u00aesun1jm"}, {"3 days ago", "\u00aeday-past-long-3"}, {"Yesterday", "\u00aeday-1"}, {"This day", "\u00aeday0"}, {"Tomorrow", "\u00aeday1"}, {"3 days from now", "\u00aeday-future-long-3"}, {"3 days ago + time", "\u00aeday-past-long-3jm"}, {"Last day + time", "\u00aeday-1jm"}, {"This day + time", "\u00aeday0jm"}, {"Next day + time", "\u00aeday1jm"}, {"3 days from now + time", "\u00aeday-future-long-3jm"}};
        RELATIVE_DATE = PatternCache.get("\u00ae([a-z]+(?:-[a-z]+)?)+(-[a-z]+)?([+-]?\\d+)([a-zA-Z]+)?");
    }

    static enum RowStyle {
        header,
        separator,
        normal;

    }

    class RelativePattern {
        private static final String UNIT_PREFIX = "//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"duration-";
        final String type;
        final int offset;
        final String time;
        final String path;
        final String value;

        public RelativePattern(CLDRFile file, String skeleton) {
            Matcher m4 = RELATIVE_DATE.matcher(skeleton);
            if (m4.matches()) {
                this.type = m4.group(1);
                String length = m4.group(2);
                this.offset = Integer.parseInt(m4.group(3));
                String temp = m4.group(4);
                String string = this.time = temp == null ? null : temp.replace('j', DateTimeFormats.this.generator.getDefaultHourFormatChar());
                if (-1 <= this.offset && this.offset <= 1) {
                    this.path = "//ldml/dates/fields/field[@type=\"" + this.type + "\"]/relative[@type=\"" + this.offset + "\"]";
                    this.value = file.getStringValue(this.path);
                } else {
                    SupplementalDataInfo.PluralInfo plurals = sdi.getPlurals(file.getLocaleID());
                    String base = UNIT_PREFIX + this.type + "\"]/unitPattern[@count=\"";
                    String tempPath = base + String.valueOf((Object)plurals.getCount(this.offset)) + "\"]";
                    String tempValue = file.getStringValue(tempPath);
                    if (tempValue == null) {
                        tempPath = base + String.valueOf((Object)SupplementalDataInfo.PluralInfo.Count.other) + "\"]";
                        tempValue = file.getStringValue(tempPath);
                    }
                    this.path = tempPath;
                    this.value = tempValue;
                }
            } else {
                throw new IllegalArgumentException(skeleton);
            }
        }
    }

    private class Diff {
        Set<String> availablePatterns;

        private Diff() {
            this.availablePatterns = DateTimeFormats.this.generator.getBaseSkeletons(new LinkedHashSet<String>());
            for (Map.Entry<String, Set<String>> pat : DateTimeFormats.this.dateIntervalInfo.getPatterns().entrySet()) {
                for (String patDiff : pat.getValue()) {
                    this.availablePatterns.add(pat.getKey() + "/" + patDiff);
                }
            }
        }

        public boolean isPresent(String skeleton) {
            return this.availablePatterns.remove(skeleton.replace('j', DateTimeFormats.this.generator.getDefaultHourFormatChar()));
        }
    }

    static enum MyOptions {
        organization(".*", "CLDR", "organization"),
        filter(".*", ".*", "locale filter (regex)");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

