/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.util.Uri;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

public class DatatypeRepertoire {
    private static final int TOKEN_TYPICAL_MAX_LENGTH = 32;
    private static final int BINARY_TYPICAL_MIN_LENGTH = 128;
    private static final String[] typeNames = new String[]{"boolean", "integer", "decimal", "double", "NCName", "time", "date", "dateTime", "duration", "hexBinary", "NMTOKEN", "base64Binary", "anyURI"};
    private final Type[] types = new Type[typeNames.length];
    private int nTypes = 0;

    DatatypeRepertoire(DatatypeLibraryFactory datatypeLibraryFactory) {
        DatatypeLibrary datatypeLibrary = datatypeLibraryFactory.createDatatypeLibrary("http://www.w3.org/2001/XMLSchema-datatypes");
        if (datatypeLibrary == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            try {
                this.types[this.nTypes] = DatatypeRepertoire.makeType(typeNames[i], datatypeLibrary.createDatatype(typeNames[i]), i);
                ++this.nTypes;
                continue;
            }
            catch (DatatypeException datatypeException) {
                // empty catch block
            }
        }
    }

    public int size() {
        return this.nTypes;
    }

    Type get(int n) {
        return this.types[n];
    }

    private static Type makeType(String string, Datatype datatype, int n) {
        if (string.equals("anyURI")) {
            return new UriType(datatype, string, n);
        }
        if (string.equals("boolean")) {
            return new BooleanType(datatype, string, n);
        }
        if (string.equals("base64Binary") || string.equals("hexBinary")) {
            return new BinaryType(datatype, string, n);
        }
        return new Type(datatype, string, n);
    }

    public static String getUri() {
        return "http://www.w3.org/2001/XMLSchema-datatypes";
    }

    private static class BooleanType
    extends Type {
        private BooleanType(Datatype datatype, String string, int n) {
            super(datatype, string, n);
        }

        @Override
        public boolean isTypical(String string) {
            return (string = string.trim()).equals("true") || string.equals("false");
        }
    }

    private static class UriType
    extends Type {
        private static final String EXCLUDED = "<>\"{}|\\^`";

        private UriType(Datatype datatype, String string, int n) {
            super(datatype, string, n);
        }

        @Override
        public boolean isTypical(String string) {
            return Uri.isAbsolute(string) && !UriType.containsEmbeddedWhitespace(string) && !UriType.containsExcluded(string);
        }

        private static boolean containsExcluded(String string) {
            for (int i = 0; i < EXCLUDED.length(); ++i) {
                if (string.indexOf(EXCLUDED.charAt(i)) < 0) continue;
                return true;
            }
            return false;
        }

        private static boolean containsEmbeddedWhitespace(String string) {
            int n = 0;
            int n2 = string.length();
            block3: for (int i = 0; i < n2; ++i) {
                switch (string.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (n != true) continue block3;
                        n = 2;
                        continue block3;
                    }
                    default: {
                        if (n == 2) {
                            return true;
                        }
                        if (n != 0) continue block3;
                        n = 1;
                    }
                }
            }
            return false;
        }
    }

    private static class BinaryType
    extends Type {
        private BinaryType(Datatype datatype, String string, int n) {
            super(datatype, string, n);
        }

        @Override
        public boolean isTypical(String string) {
            return string.length() > 128;
        }
    }

    public static class Type {
        private final Datatype dt;
        private final String name;
        private final int index;

        private Type(Datatype datatype, String string, int n) {
            this.dt = datatype;
            this.name = string;
            this.index = n;
        }

        public boolean matches(String string) {
            return this.dt.isValid(string, null);
        }

        public boolean isTypical(String string) {
            return string.length() < 32;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

