/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.Transform;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EnumLookup<T extends Enum<?>> {
    private final String name;
    private final Map<String, T> map = new HashMap<String, T>();
    private Transform<String, String> transform;
    private static Transform<String, String> CLEAN = new Transform<String, String>(){

        @Override
        public String transform(String in) {
            return in.toUpperCase(Locale.ENGLISH).replace(' ', '_');
        }
    };

    public static <T extends Enum<?>> EnumLookup<T> of(Class<T> className) {
        return EnumLookup.of(className, null, null);
    }

    public static <T extends Enum<?>> EnumLookup<T> of(Class<T> className, Transform<String, String> t2, String from, T to, Object ... extras) {
        HashMap<String, Enum> newExtras = new HashMap<String, Enum>();
        newExtras.put(from, to);
        for (int i = 0; i < extras.length; i += 2) {
            newExtras.put(extras[i].toString(), (Enum)extras[i + 1]);
        }
        return EnumLookup.of(className, t2, newExtras);
    }

    public static <T extends Enum<?>> EnumLookup<T> of(Class<T> className, Transform<String, String> t2, Map<String, T> extras) {
        String name_ = className.getName();
        int lastDot = name_.lastIndexOf(46);
        EnumLookup<T> result = new EnumLookup<T>(name_.substring(lastDot + 1));
        try {
            Enum[] values;
            t2 = t2 == null ? CLEAN : t2;
            result.transform = t2;
            Method m4 = className.getMethod("values", null);
            for (Enum value : values = (Enum[])m4.invoke(null, new Object[0])) {
                result.map.put(t2.transform(value.name()), value);
                result.map.put(t2.transform(value.toString()), value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (extras == null) {
            return result;
        }
        for (Map.Entry<String, T> entry : extras.entrySet()) {
            String key = t2.transform(entry.getKey());
            Enum newValue = (Enum)entry.getValue();
            Enum old = (Enum)result.map.get(key);
            if (old == null) {
                result.map.put(key, newValue);
                continue;
            }
            if (old == newValue) continue;
            throw new IllegalArgumentException("Incompatible mapping: " + key + "=" + String.valueOf(old) + "!=" + String.valueOf(newValue));
        }
        return result;
    }

    public T forString(String s2) {
        return this.forString(s2, false);
    }

    public T forString(String s2, boolean allowNull) {
        Enum result = (Enum)this.map.get(this.transform.transform(s2));
        if (!allowNull && result == null) {
            throw new IllegalArgumentException("Can't find match for \u00ab" + s2 + "\u00bb in " + String.valueOf(this.map.keySet()) + " in " + this.name);
        }
        return (T)result;
    }

    private EnumLookup(String name) {
        this.name = name;
    }
}

