/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class VerifyConverterResults {
    public static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    public static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();

    public static void main(String[] args) {
        Matcher fileMatcher;
        String source;
        SourceType sourceType = SourceType.json;
        String dirBase = CLDRPaths.STAGING_DIRECTORY + "production/";
        String textSource = "/Users/markdavis/GitHub/macchiati/icu/icu4c/source/data";
        String jsonSource = "/Users/markdavis/Downloads/38JsonBetaAll";
        String locale = "de";
        boolean isVerbose = false;
        Matcher parentMatcher = null;
        switch (sourceType) {
            case text: {
                source = textSource;
                fileMatcher = Pattern.compile(locale + ".txt").matcher("");
                break;
            }
            case json: {
                source = jsonSource;
                fileMatcher = Pattern.compile(".*\\.json").matcher("");
                parentMatcher = Pattern.compile(locale + "|cldr-core|supplemental").matcher("");
                break;
            }
            default: {
                throw new IllegalArgumentException("No code yet for " + String.valueOf((Object)sourceType));
            }
        }
        ImmutableSet<String> skipSupplementalFiles = ImmutableSet.of("subdivisions.xml", "attributeValueValidity.xml", "coverageLevels.xml");
        Set<String> converted = VerifyConverterResults.getConvertedData(sourceType, new File(source), fileMatcher, parentMatcher, new TreeSet<String>());
        ImmutableSet<String> excludeDraftStatus = ImmutableSet.of("unconfirmed", "provisional");
        Iterator<String> iterator = Iterables.concat(DtdType.ldml.directories, DtdType.supplementalData.directories).iterator();
        block21: while (iterator.hasNext()) {
            String dir;
            switch (dir = iterator.next()) {
                case "annotationsDerived": 
                case "annotations": {
                    if (sourceType != SourceType.text) break;
                    System.out.println(dir + "\t##SKIPPING\texcluded from ICU");
                    continue block21;
                }
                case "casing": {
                    System.out.println(dir + "\t##SKIPPING\tinternal to CLDR, not applicable for conversion");
                    continue block21;
                }
                case "subdivisions": {
                    System.out.println(dir + "\t##SKIPPING\tpurposely excluded from conversion");
                    continue block21;
                }
                case "collation": 
                case "rbnf": 
                case "transforms": 
                case "segments": 
                case "validity": {
                    System.out.println(dir + "\t##SKIPPING\tformat changes so dramatically we can't compare yet");
                    continue block21;
                }
            }
            boolean isSupplemental = DtdType.supplementalData.directories.contains(dir);
            DtdData supplementalDtdData = isSupplemental ? DtdData.getInstance(DtdType.supplementalData) : null;
            Matcher cldrFileMatcher = Pattern.compile(locale + ".xml").matcher("");
            FileData filedata = new FileData(converted);
            String current = dirBase + "common/" + dir;
            for (File child : new File(current).listFiles()) {
                String name = child.getName();
                if (isSupplemental ? skipSupplementalFiles.contains(name) : !cldrFileMatcher.reset(name).matches()) continue;
                filedata.clear();
                for (Pair<String, String> line : XMLFileReader.loadPathValues(child.toString(), new ArrayList<Pair<String, String>>(), false)) {
                    String value = line.getSecond();
                    String path = line.getFirst();
                    XPathParts parts = XPathParts.getFrozenInstance(path);
                    String draftStatus = parts.getAttributeValue(-1, "draft");
                    if (draftStatus != null && excludeDraftStatus.contains(draftStatus) || path.startsWith("//supplementalData/metadata/suppress/attributes") || path.startsWith("//supplementalData/metadata/serialElements")) continue;
                    filedata.checkValue(dir, name, path, value);
                    if (!isSupplemental) continue;
                    for (int elementIndex = 0; elementIndex < parts.size(); ++elementIndex) {
                        String element = parts.getElement(elementIndex);
                        for (Map.Entry<String, String> attribute : parts.getAttributes(elementIndex).entrySet()) {
                            if (DtdData.AttributeStatus.value != supplementalDtdData.getAttributeStatus(element, attribute.getKey())) continue;
                            filedata.checkValue(dir, name, path, attribute.getValue());
                        }
                    }
                }
                filedata.print(isVerbose);
                System.out.println(dir + "\t##Missing Paths #:\t" + String.valueOf(filedata.filedata.size() == 0 ? "NONE" : Integer.valueOf(filedata.filedata.size())));
            }
        }
    }

    private static Set<String> getConvertedData(SourceType sourceType, File target, Matcher fileMatcher, Matcher parentMatcher, Set<String> accummulatedValues) {
        if (target.isDirectory()) {
            for (File child : target.listFiles()) {
                VerifyConverterResults.getConvertedData(sourceType, child, fileMatcher, parentMatcher, accummulatedValues);
            }
        } else {
            if (target.toString().contains("/de/")) {
                boolean bl = false;
            }
            boolean ok = true;
            if (parentMatcher != null) {
                String parentName = target.getParentFile().getName();
                ok = parentMatcher.reset(parentName).matches();
            }
            if (ok) {
                ok = fileMatcher.reset(target.getName()).matches();
            }
            if (ok) {
                int startCount = accummulatedValues.size();
                switch (sourceType) {
                    case text: {
                        VerifyConverterResults.processText(target, accummulatedValues);
                        break;
                    }
                    case json: {
                        VerifyConverterResults.processJson(target, accummulatedValues);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No code yet for " + String.valueOf((Object)sourceType));
                    }
                }
                int endCount = accummulatedValues.size();
                System.out.println("Processed Converted" + String.valueOf(target) + "; " + (String)(startCount == endCount ? "NO CHANGE" : startCount + " => " + endCount));
            }
        }
        return accummulatedValues;
    }

    private static void processJson(File target, Set<String> accummulatedValues) {
        try (BufferedReader reader = FileUtilities.openFile(target, Charset.forName("utf8"));){
            JsonStreamParser gsonParser = new JsonStreamParser(reader);
            gsonParser.forEachRemaining(x -> VerifyConverterResults.process(x, accummulatedValues));
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private static void process(JsonElement x, Set<String> accummulatedValues) {
        if (x.isJsonPrimitive()) {
            accummulatedValues.add(x.getAsString());
        } else if (x.isJsonArray()) {
            for (JsonElement y : x.getAsJsonArray()) {
                VerifyConverterResults.process(y, accummulatedValues);
            }
        } else if (x.isJsonObject()) {
            for (Map.Entry<String, JsonElement> y : x.getAsJsonObject().entrySet()) {
                VerifyConverterResults.process(y.getValue(), accummulatedValues);
            }
        } else {
            throw new IllegalArgumentException("No code yet for ");
        }
    }

    public static void processText(File target, Set<String> accummulatedValues) {
        Matcher quoteMatcher = Pattern.compile("\"([^\"]*)\"").matcher("");
        for (String line : FileUtilities.in(target)) {
            if (line.startsWith("//")) continue;
            quoteMatcher.reset(line);
            while (quoteMatcher.find()) {
                String value = quoteMatcher.group(1);
                accummulatedValues.add(value);
            }
        }
    }

    static class FileData {
        Set<String> converted;
        TreeMultimap<String, String> filedata = TreeMultimap.create();
        TreeMap<String, String> starredData = new TreeMap();

        public FileData(Set<String> converted) {
            this.converted = converted;
        }

        public void clear() {
            this.filedata.clear();
            this.starredData.clear();
        }

        public void checkValue(String dir, String name, String path, String value) {
            if (value.isEmpty()) {
                return;
            }
            if (this.converted.contains(value = value.replace('\n', ' '))) {
                return;
            }
            this.filedata.put((Object)(dir + "\t" + name + "\t" + path), (Object)value);
            this.starredData.put(dir + "\t" + name + "\t" + PathStarrer.get(path), value);
        }

        void print(boolean isVerbose) {
            Set<Map.Entry<String, String>> items = isVerbose ? this.filedata.entries() : this.starredData.entrySet();
            for (Map.Entry<String, String> entry : items) {
                System.out.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
    }

    static enum SourceType {
        text,
        json,
        rb;

    }
}

