/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Locale;
import java.util.stream.Collectors;

public enum CodePointEscaper {
    TSP(8201, "Thin space", "A space character that is narrower (in most fonts) than the regular one."),
    NBSP(160, "No-break space", "Same as space, but doesn\u2019t line break."),
    NBTSP(8239, "No-break thin space", "Same as thin space, but doesn\u2019t line break."),
    ALB(8203, "Allow line break", "Invisible character allowing a line-break. Aka ZWSP."),
    NB(8288, "No-break", "Invisible character preventing a line break."),
    NBHY(8209, "No-break hyphen", "Same as a hyphen, but doesn\u2019t line break."),
    SHY(173, "Soft hyphen", "Invisible character that appears like a hyphen (in most fonts/languages) if there is a line-break after it."),
    NDASH(8211, "En dash", "Slightly wider (\u2013) than a hyphen (-), used for ranges of numbers or dates in some languages."),
    ZWNJ(8204, "Cursive non-joiner", "Breaks cursive connections, where possible."),
    ZWJ(8205, "Cursive joiner", "Forces cursive connections, if possible."),
    LRM(8206, "Left-right mark", "For BIDI, invisible character that behaves like Hebrew letter."),
    RLM(8207, "Right-left mark", "For BIDI, invisible character that behaves like Latin letter."),
    ALM(1564, "Arabic letter mark", "For BIDI, invisible character that behaves like Arabic letter."),
    ANS(1536, "Arabic number sign", "For use in Exemplar sets"),
    ASNS(1537, "Arabic sanah sign", "For use in Exemplar sets"),
    AFM(1538, "Arabic footnote marker", "For use in Exemplar sets"),
    ASFS(1539, "Arabic safha sign", "For use in Exemplar sets"),
    SAM(1807, "Syriac abbreviation mark", "For use in Exemplar sets"),
    SP(32, "Space", "ASCII space, for use in Exemplar sets"),
    RANGE(10134, "Range syntax mark", "heavy minus sign, for use in Exemplar sets"),
    ESCS(10096, "Escape start", "heavy open angle bracket, for use in Exemplar sets"),
    ESCE(10097, "Escape end", "heavy close angle bracket, for use in Exemplar sets");

    public static final CodePointEscaper NSP;
    public static final CodePointEscaper NBNSP;
    public static final CodePointEscaper NNBSP;
    public static final CodePointEscaper TNBSP;
    public static final CodePointEscaper ZWSP;
    public static final char RANGE_SYNTAX;
    public static final char ESCAPE_START;
    public static final char ESCAPE_END;
    private static final UnicodeMap<CodePointEscaper> _fromCodePoint;
    public static final UnicodeSet EMOJI_INVISIBLES;
    public static final UnicodeSet FORCE_ESCAPE;
    public static final UnicodeSet ESCAPE_IN_SURVEYTOOL;
    public static final UnicodeSet NON_SPACING;
    public static final UnicodeSet FORCE_ESCAPE_WITH_NONSPACING;
    private final int codePoint;
    private final String shortName;
    private final String description;
    private static final String HAS_NAME = " \u2261 ";

    private CodePointEscaper(int codePoint, String shortName, String description) {
        this.codePoint = codePoint;
        this.shortName = shortName;
        this.description = description;
    }

    public static final UnicodeSet getNamedEscapes() {
        return _fromCodePoint.keySet().freeze();
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public String getString() {
        return UTF16.valueOf(this.codePoint);
    }

    public String codePointToEscaped() {
        return ESCAPE_START + CodePointEscaper.rawCodePointToEscaped(this.codePoint) + ESCAPE_END;
    }

    public static int escapedToCodePoint(String value) {
        if (value == null || value.isEmpty()) {
            return 65533;
        }
        if (value.codePointAt(0) != ESCAPE_START || value.codePointAt(value.length() - 1) != ESCAPE_END) {
            throw new IllegalArgumentException("Must be of the form " + ESCAPE_START + "\u2026" + ESCAPE_END);
        }
        return CodePointEscaper.rawEscapedToCodePoint(value.substring(1, value.length() - 1));
    }

    public static String codePointToEscaped(int codePoint) {
        return ESCAPE_START + CodePointEscaper.rawCodePointToEscaped(codePoint) + ESCAPE_END;
    }

    public static String toEscaped(String unescaped) {
        return CodePointEscaper.toEscaped(unescaped, FORCE_ESCAPE);
    }

    public static String toEscaped(String unescaped, UnicodeSet toEscape) {
        if (unescaped == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        unescaped.codePoints().forEach(cp -> {
            if (!toEscape.contains(cp)) {
                result.appendCodePoint(cp);
            } else {
                result.append(CodePointEscaper.codePointToEscaped(cp));
            }
        });
        return result.toString();
    }

    public static String getEscaped(int cp, UnicodeSet toEscape) {
        if (!toEscape.contains(cp)) {
            return UTF16.valueOf(cp);
        }
        return CodePointEscaper.codePointToEscaped(cp);
    }

    public static String toUnescaped(String escaped) {
        if (escaped == null) {
            return null;
        }
        StringBuilder result = null;
        int donePart = 0;
        int found = escaped.indexOf(ESCAPE_START);
        while (found >= 0) {
            int foundEnd = escaped.indexOf(ESCAPE_END, found);
            if (foundEnd < 0) {
                throw new IllegalArgumentException("Malformed escaped string, missing: " + ESCAPE_END);
            }
            if (result == null) {
                result = new StringBuilder();
            }
            result.append(escaped, donePart, found);
            donePart = ++foundEnd;
            result.appendCodePoint(CodePointEscaper.escapedToCodePoint(escaped.substring(found, foundEnd)));
            found = escaped.indexOf(ESCAPE_START, foundEnd);
        }
        return donePart == 0 ? escaped : result.append(escaped, donePart, escaped.length()).toString();
    }

    public static String toExample(int codePoint) {
        CodePointEscaper cpe = CodePointEscaper.forCodePoint(codePoint);
        if (cpe == null) {
            String name = UCharacter.getExtendedName(codePoint);
            return CodePointEscaper.codePointToEscaped(codePoint) + HAS_NAME + (name != null ? name.toLowerCase() : "");
        }
        return CodePointEscaper.codePointToEscaped(cpe.codePoint) + HAS_NAME + cpe.shortName;
    }

    static CodePointEscaper forCodePoint(int codePoint) {
        return _fromCodePoint.get(codePoint);
    }

    static CodePointEscaper forCodePoint(String str) {
        return CodePointEscaper.forCodePoint(str.codePointAt(0));
    }

    public static int rawEscapedToCodePoint(CharSequence value) {
        if (value == null || value.length() == 0) {
            return 65533;
        }
        try {
            return CodePointEscaper.valueOf((String)value.toString().toUpperCase((Locale)Locale.ROOT)).codePoint;
        }
        catch (Exception exception) {
            int codePoint;
            try {
                codePoint = Integer.parseInt(value.toString(), 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Not a named or hex escape: \u2770" + String.valueOf(value) + "\u274c\u2771");
            }
            if (codePoint < 0 || codePoint > 0x10FFFF) {
                throw new IllegalArgumentException("Illegal code point: \u2770" + String.valueOf(value) + "\u274c\u2771");
            }
            return codePoint;
        }
    }

    public static String rawCodePointToEscaped(int codePoint) {
        CodePointEscaper result = _fromCodePoint.get(codePoint);
        return result == null ? Integer.toString(codePoint, 16).toUpperCase(Locale.ROOT) : result.toString();
    }

    public static String regexPattern(UnicodeSet unicodeSet, String escapePrefix, String escapePostfix) {
        return "[" + unicodeSet.rangeStream().map(x -> CodePointEscaper.hexEscape(x.codepoint, escapePrefix, escapePostfix) + (String)(x.codepointEnd == x.codepoint ? "" : "-" + CodePointEscaper.hexEscape(x.codepointEnd, escapePrefix, escapePostfix))).collect(Collectors.joining()) + "]";
    }

    public static String regexPattern(UnicodeSet unicodeSet) {
        return CodePointEscaper.regexPattern(unicodeSet, "\\x{", "}");
    }

    public static String hexEscape(int codepoint, String escapePrefix, String escapePostfix) {
        return escapePrefix + Integer.toHexString(codepoint) + escapePostfix;
    }

    public static String hexEscape(int codepoint) {
        return CodePointEscaper.hexEscape(codepoint, "\\x{", "}");
    }

    public static final String getHtmlRows(UnicodeSet escapesToShow, String tableOptions, String cellOptions) {
        if (!escapesToShow.strings().isEmpty()) {
            throw new IllegalArgumentException("No strings allowed in the unicode set.");
        }
        StringBuilder result = new StringBuilder("<table" + tableOptions + ">");
        UnicodeSet remaining = new UnicodeSet(escapesToShow);
        String tdPlus = "<td" + cellOptions + ">";
        for (CodePointEscaper cpe : CodePointEscaper.values()) {
            int cp = cpe.getCodePoint();
            remaining.remove(cp);
            if (!escapesToShow.contains(cpe.getCodePoint())) continue;
            String id = cpe.name();
            String shortName = cpe.getShortName();
            String description = cpe.getDescription();
            CodePointEscaper.addREsult(result, tdPlus, id, shortName, description);
        }
        for (String cps : remaining) {
            int cp = cps.codePointAt(0);
            String extendedName = UCharacter.getExtendedName(cp);
            CodePointEscaper.addREsult(result, tdPlus, Utility.hex(cp, 2), "", extendedName == null ? "" : extendedName.toLowerCase());
        }
        return result.append("</table>").toString();
    }

    public static void addREsult(StringBuilder result, String tdPlus, String id, String shortName, String description) {
        result.append("<tr>").append(tdPlus).append(ESCAPE_START).append(id).append(ESCAPE_END + "</td>").append(tdPlus).append(shortName).append("</td>").append(tdPlus).append(description).append("</td><tr>");
    }

    static {
        NSP = TSP;
        NBNSP = NBTSP;
        NNBSP = NBTSP;
        TNBSP = NBTSP;
        ZWSP = ALB;
        RANGE_SYNTAX = (char)RANGE.getCodePoint();
        ESCAPE_START = (char)ESCS.getCodePoint();
        ESCAPE_END = (char)ESCE.getCodePoint();
        _fromCodePoint = new UnicodeMap();
        for (CodePointEscaper abbr : CodePointEscaper.values()) {
            CodePointEscaper oldValue = _fromCodePoint.get(abbr.codePoint);
            if (oldValue != null) {
                throw new IllegalArgumentException("Abbreviation code points collide: " + oldValue.name() + ", " + abbr.name());
            }
            _fromCodePoint.put(abbr.codePoint, abbr);
        }
        _fromCodePoint.freeze();
        EMOJI_INVISIBLES = new UnicodeSet("[\\uFE0F\\U000E0020-\\U000E007F]").freeze();
        FORCE_ESCAPE = new UnicodeSet("[[:DI:][:Pat_WS:][:WSpace:][:C:][:Z:]\u200b\u2060]").addAll(CodePointEscaper.getNamedEscapes()).removeAll(EMOJI_INVISIBLES).freeze();
        ESCAPE_IN_SURVEYTOOL = FORCE_ESCAPE.cloneAsThawed().remove(SP.getCodePoint()).freeze();
        NON_SPACING = new UnicodeSet("[[:Mn:][:Me:]]").freeze();
        FORCE_ESCAPE_WITH_NONSPACING = new UnicodeSet(FORCE_ESCAPE).addAll(NON_SPACING).freeze();
    }
}

