/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.unicode.cldr.util.DtdType;
import org.xml.sax.InputSource;

public class DoctypeXmlStreamWrapper {
    private static final String DOCTYPE = "<!DOCTYPE";
    private static final char[] DOCTYPE_CHARS = "<!DOCTYPE".toCharArray();
    private static final byte[] DOCTYPE_BYTES = "<!DOCTYPE".getBytes(StandardCharsets.UTF_8);
    private static final String XMLNS_EQUALS = "xmlns=\"";
    public static int BUFFER_MAX_SIZE = 1024;
    public static int BUFFER_READ_SIZE = 512;

    public static InputSource wrap(InputSource src) throws IOException {
        Reader r = src.getCharacterStream();
        InputStream is = src.getByteStream();
        if (r != null) {
            src.setCharacterStream(DoctypeXmlStreamWrapper.wrap(r));
        } else if (is != null) {
            src.setByteStream(DoctypeXmlStreamWrapper.wrap(is, src.getEncoding()));
        } else {
            throw new NullPointerException("Internal error: Character and Byte stream are both null");
        }
        return src;
    }

    public static InputStream wrap(InputStream src, String encoding) throws IOException {
        PushbackInputStream pr;
        byte[] inbuf;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (!DoctypeXmlStreamWrapper.hasDocType(inbuf = (pr = new PushbackInputStream(src, BUFFER_MAX_SIZE)).readNBytes(BUFFER_READ_SIZE), encoding)) {
            inbuf = DoctypeXmlStreamWrapper.fixup(inbuf, encoding).getBytes(encoding);
        }
        pr.unread(inbuf);
        return pr;
    }

    public static Reader wrap(Reader src) throws IOException {
        char[] inbuf = new char[BUFFER_READ_SIZE];
        PushbackReader pr = new PushbackReader(src, BUFFER_MAX_SIZE);
        int readlen = pr.read(inbuf);
        if (!DoctypeXmlStreamWrapper.hasDocType(inbuf, readlen)) {
            char[] buf2 = Arrays.copyOf(inbuf, readlen);
            inbuf = DoctypeXmlStreamWrapper.fixup(new String(buf2)).toCharArray();
            readlen = inbuf.length;
        }
        pr.unread(inbuf, 0, readlen);
        return pr;
    }

    private static String fixup(byte[] inbuf, String encoding) {
        try {
            String s2 = new String(inbuf, encoding);
            return DoctypeXmlStreamWrapper.fixup(s2);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("While parsing " + encoding, e);
        }
    }

    private static String fixup(String s2) {
        for (DtdType d : DtdType.values()) {
            if (!s2.contains(XMLNS_EQUALS + d.getNsUrl())) continue;
            return DoctypeXmlStreamWrapper.fixup(s2, d);
        }
        return s2;
    }

    private static String fixup(String s2, DtdType d) {
        int n = s2.indexOf("?>");
        if (n == -1) {
            throw new IllegalArgumentException("Invalid XML prefix: ?> not found.");
        }
        String doctype = "\n" + d.getDoctype() + "\n";
        String s22 = s2.substring(0, n += 2) + doctype + s2.substring(n);
        return s22;
    }

    private static final boolean hasDocType(byte[] inbuf, String encoding) {
        if (inbuf == null || inbuf.length == 0) {
            return false;
        }
        if (DoctypeXmlStreamWrapper.arrayContains(inbuf, inbuf.length, DOCTYPE_BYTES)) {
            return true;
        }
        if (encoding == null || encoding.equals("UTF-8")) {
            return false;
        }
        try {
            String s2 = new String(inbuf, encoding);
            return s2.contains(DOCTYPE);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("While parsing " + encoding, e);
        }
    }

    private static final boolean hasDocType(char[] inbuf, int readlen) {
        if (inbuf == null || readlen <= 0) {
            return false;
        }
        return DoctypeXmlStreamWrapper.arrayContains(inbuf, readlen, DOCTYPE_CHARS);
    }

    private static boolean arrayContains(char[] inbuf, int inlen, char[] testbuf) {
        int testlen = testbuf.length;
        int t2 = 0;
        for (int i = 0; i < inlen; ++i) {
            if (inbuf[i] == testbuf[t2]) {
                if (++t2 != testlen) continue;
                return true;
            }
            t2 = 0;
        }
        return false;
    }

    private static boolean arrayContains(byte[] inbuf, int inlen, byte[] testbuf) {
        int testlen = testbuf.length;
        int t2 = 0;
        for (int i = 0; i < inlen; ++i) {
            if (inbuf[i] == testbuf[t2]) {
                if (++t2 != testlen) continue;
                return true;
            }
            t2 = 0;
        }
        return false;
    }
}

