/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.VoteType;

public class VoterProgress {
    private int votablePathCount = 0;
    private int votedPathCount = 0;
    private Map<VoteType, Integer> votedTypeCount = null;

    public int getVotablePathCount() {
        return this.votablePathCount;
    }

    public int getVotedPathCount() {
        return this.votedPathCount;
    }

    public Map<String, Integer> getTypeCount() {
        if (this.votedTypeCount == null) {
            return null;
        }
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (VoteType voteType : this.votedTypeCount.keySet()) {
            map.put(voteType.name(), this.votedTypeCount.get((Object)voteType));
        }
        return map;
    }

    public void incrementVotablePathCount() {
        ++this.votablePathCount;
    }

    public void incrementVotedPathCount(VoteType voteType) {
        if (voteType == null || voteType == VoteType.NONE) {
            throw new IllegalArgumentException("null/NONE not allowed for incrementVotedPathCount");
        }
        ++this.votedPathCount;
        if (this.votedTypeCount == null) {
            this.votedTypeCount = new HashMap<VoteType, Integer>();
        }
        this.votedTypeCount.put(voteType, this.votedTypeCount.getOrDefault((Object)voteType, 0) + 1);
    }
}

