/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.dtd;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.dtd.Converter;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.translate.util.AbsoluteUriParam;
import com.thaiopensource.relaxng.translate.util.AbstractParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamValueException;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.relaxng.translate.util.NCNameParam;
import com.thaiopensource.relaxng.translate.util.NmtokenParam;
import com.thaiopensource.relaxng.translate.util.Param;
import com.thaiopensource.relaxng.translate.util.ParamFactory;
import com.thaiopensource.relaxng.translate.util.ParamProcessor;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.parse.DtdParserImpl;
import com.thaiopensource.xml.dtd.parse.ParseException;
import com.thaiopensource.xml.em.EntityManager;
import com.thaiopensource.xml.em.ResolverUriEntityManager;
import com.thaiopensource.xml.em.UriEntityManager;
import com.thaiopensource.xml.util.Naming;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DtdInputFormat
implements InputFormat {
    @Override
    public SchemaCollection load(String string, String[] stringArray, String string2, ErrorHandler errorHandler, Resolver resolver) throws InvalidParamsException, IOException, SAXException {
        ErrorReporter errorReporter = new ErrorReporter(errorHandler, DtdInputFormat.class);
        final Converter.Options options = new Converter.Options();
        if ("xsd".equals(string2)) {
            options.inlineAttlistDecls = true;
            options.generateStart = false;
        }
        ParamProcessor paramProcessor = new ParamProcessor();
        paramProcessor.declare("inline-attlist", new AbstractParam(){

            @Override
            public void set(boolean bl) {
                options.inlineAttlistDecls = bl;
            }
        });
        paramProcessor.declare("xmlns", new AbsoluteUriParam(){

            @Override
            public void set(String string) throws InvalidParamValueException {
                if (string.equals("")) {
                    this.setAbsoluteUri(string);
                } else {
                    super.set(string);
                }
            }

            @Override
            protected void setAbsoluteUri(String string) {
                options.defaultNamespace = string;
            }
        });
        paramProcessor.declare("any-name", new NCNameParam(){

            @Override
            protected void setNCName(String string) {
                options.anyName = string;
            }
        });
        paramProcessor.declare("strict-any", new AbstractParam(){

            @Override
            public void set(boolean bl) {
                options.strictAny = bl;
            }
        });
        paramProcessor.declare("annotation-prefix", new NCNameParam(){

            @Override
            protected void setNCName(String string) {
                options.annotationPrefix = string;
            }
        });
        paramProcessor.declare("colon-replacement", new NmtokenParam(){

            @Override
            protected void setNmtoken(String string) {
                options.colonReplacement = string;
            }
        });
        paramProcessor.declare("generate-start", new AbstractParam(){

            @Override
            public void set(boolean bl) {
                options.generateStart = bl;
            }
        });
        paramProcessor.declare("element-define", new DeclPatternParam(errorReporter.getLocalizer()){

            @Override
            void setDeclPattern(String string) {
                options.elementDeclPattern = string;
            }
        });
        paramProcessor.declare("attlist-define", new DeclPatternParam(errorReporter.getLocalizer()){

            @Override
            void setDeclPattern(String string) {
                options.attlistDeclPattern = string;
            }
        });
        paramProcessor.setParamFactory(new NamespaceDeclParamFactory(options.prefixMap));
        paramProcessor.process(stringArray, errorHandler);
        try {
            UriEntityManager uriEntityManager = resolver != null ? new ResolverUriEntityManager(resolver) : new UriEntityManager();
            Dtd dtd = new DtdParserImpl().parse(string, (EntityManager)uriEntityManager);
            try {
                return new Converter(dtd, errorReporter, options).convert();
            }
            catch (ErrorReporter.WrappedSAXException wrappedSAXException) {
                throw wrappedSAXException.getException();
            }
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessageBody(), null, parseException.getLocation(), parseException.getLineNumber(), parseException.getColumnNumber());
        }
    }

    private static abstract class DeclPatternParam
    extends AbstractParam {
        private final Localizer localizer;

        DeclPatternParam(Localizer localizer) {
            this.localizer = localizer;
        }

        @Override
        public void set(String string) throws InvalidParamValueException {
            if (string.indexOf(37) < 0) {
                throw new InvalidParamValueException(this.localizer.message("no_percent"));
            }
            if (string.lastIndexOf(37) != string.indexOf(37)) {
                throw new InvalidParamValueException(this.localizer.message("multiple_percent"));
            }
            if (!Naming.isNcname(string.replace('%', 'x'))) {
                throw new InvalidParamValueException(this.localizer.message("not_ncname_with_percent"));
            }
            this.setDeclPattern(string);
        }

        abstract void setDeclPattern(String var1);
    }

    private static class NamespaceDeclParamFactory
    implements ParamFactory {
        private final Map<String, String> prefixMap;

        NamespaceDeclParamFactory(Map<String, String> map) {
            this.prefixMap = map;
        }

        @Override
        public Param createParam(String string) {
            if (!string.startsWith("xmlns:")) {
                return null;
            }
            final String string2 = string.substring(6);
            if (!Naming.isNcname(string2)) {
                return null;
            }
            return new AbsoluteUriParam(){

                @Override
                public void setAbsoluteUri(String string) {
                    NamespaceDeclParamFactory.this.prefixMap.put(string2, string);
                }
            };
        }
    }
}

