/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output;

import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.xml.out.CharRepertoire;
import com.thaiopensource.xml.util.EncodingMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class LocalOutputDirectory
implements OutputDirectory {
    private final File mainOutputFile;
    private final String lineSeparator;
    private final String outputExtension;
    private String defaultEncoding;
    private boolean alwaysUseDefaultEncoding;
    private int lineLength;
    private final Map<String, String> uriMap = new HashMap<String, String>();
    private final String mainInputExtension;
    private int indent;

    public LocalOutputDirectory(String string, File file, String string2, String string3, int n, int n2) {
        this.mainOutputFile = file;
        this.outputExtension = string2;
        this.defaultEncoding = string3;
        this.lineSeparator = System.getProperty("line.separator");
        this.lineLength = n;
        this.indent = n2;
        this.uriMap.put(string, file.getName());
        int n3 = string.lastIndexOf(47);
        int n4 = string.lastIndexOf(46);
        this.mainInputExtension = n4 > 0 && n4 > n3 ? string.substring(n4) : "";
    }

    @Override
    public void setEncoding(String string) {
        this.defaultEncoding = string;
        this.alwaysUseDefaultEncoding = true;
    }

    @Override
    public OutputDirectory.Stream open(String string, String string2) throws IOException {
        if (string2 == null || this.alwaysUseDefaultEncoding) {
            string2 = this.defaultEncoding;
        }
        String string3 = EncodingMap.getJavaName(string2);
        File file = new File(this.mainOutputFile.getParentFile(), this.mapFilename(string));
        return new OutputDirectory.Stream(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), string3), string2, CharRepertoire.getInstance(string3));
    }

    @Override
    public String reference(String string, String string2) {
        return this.mapFilename(string2);
    }

    private String mapFilename(String string) {
        String string2 = this.uriMap.get(string);
        if (string2 == null) {
            string2 = this.chooseFilename(string);
            this.uriMap.put(string, string2);
        }
        return string2;
    }

    private String chooseFilename(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        String string3 = string2.endsWith(this.mainInputExtension) ? string2.substring(0, string2.length() - this.mainInputExtension.length()) : string2;
        string2 = string3 + this.outputExtension;
        int n = 1;
        while (this.uriMap.containsValue(string2)) {
            string2 = string3 + Integer.toString(n) + this.outputExtension;
            ++n;
        }
        return string2;
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public int getLineLength() {
        return this.lineLength;
    }

    @Override
    public void setLineLength(int n) {
        this.lineLength = n;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public void setIndent(int n) {
        this.indent = n;
    }
}

