/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.util.DtdData;

public final class AttributeKey {
    private static final ImmutableTable<String, String, AttributeKey> KNOWN_KEYS = Arrays.stream(CldrDataType.values()).flatMap(CldrDataType::getElements).flatMap(e -> e.getAttributes().keySet().stream().filter(AttributeKey::isKnownAttribute).map(a -> new AttributeKey(e.getName(), a.getName()))).distinct().collect(ImmutableTable.toImmutableTable(AttributeKey::getElementName, AttributeKey::getAttributeName, Function.identity()));
    private static final Splitter LIST_SPLITTER = Splitter.on(CharMatcher.whitespace()).omitEmptyStrings();
    private final String elementName;
    private final String attributeName;

    private static boolean isKnownAttribute(DtdData.Attribute attr) {
        return !attr.isDeprecated() && (attr.attributeStatus == DtdData.AttributeStatus.distinguished || attr.attributeStatus == DtdData.AttributeStatus.value);
    }

    public static AttributeKey keyOf(String elementName, String attributeName) {
        if (elementName.indexOf(58) == -1) {
            Preconditions.checkArgument(attributeName.startsWith("xml:") || attributeName.indexOf(58) == -1, "attributes in an external namespace other than xml: cannot be present in elements in the default namespace: %s:%s", (Object)elementName, (Object)attributeName);
            return Preconditions.checkNotNull((AttributeKey)KNOWN_KEYS.get(elementName, attributeName), "unknown attribute (was it deprecated?): %s:%s", (Object)elementName, (Object)attributeName);
        }
        return new AttributeKey(elementName, attributeName);
    }

    private AttributeKey(String elementName, String attributeName) {
        this.elementName = AttributeKey.checkValidLabel(elementName, "element name");
        this.attributeName = AttributeKey.checkValidLabel(attributeName, "attribute name");
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String valueFrom(AttributeSupplier src) {
        Preconditions.checkState(!src.getDataType().isOptionalAttribute(this), "attribute %s is optional in %s, it should be accessed by an optional accessor", (Object)this, (Object)src.getDataType());
        return Preconditions.checkNotNull(src.get(this), "missing required attribute: %s", (Object)this);
    }

    public Optional<String> optionalValueFrom(AttributeSupplier src) {
        Preconditions.checkState(src.getDataType().isOptionalAttribute(this), "attribute %s is not optional in %s, it should not be accessed by an optional accessor", (Object)this, (Object)src.getDataType());
        return Optional.ofNullable(src.get(this));
    }

    public String valueFrom(AttributeSupplier src, String defaultValue) {
        Preconditions.checkState(src.getDataType().isOptionalAttribute(this), "attribute %s is not optional in %s, it should not be accessed by an optional accessor", (Object)this, (Object)src.getDataType());
        Preconditions.checkNotNull(defaultValue, "default value must not be null");
        String v = src.get(this);
        return v != null ? v : defaultValue;
    }

    public boolean booleanValueFrom(AttributeSupplier src, boolean defaultValue) {
        String v = src.get(this);
        if (v == null) {
            return defaultValue;
        }
        if (Ascii.equalsIgnoreCase(v, "true")) {
            return true;
        }
        if (Ascii.equalsIgnoreCase(v, "false")) {
            return false;
        }
        throw new IllegalArgumentException("value of attribute " + String.valueOf(this) + " is not boolean: " + v);
    }

    public List<String> listOfValuesFrom(AttributeSupplier src) {
        String v = src.get(this);
        return v != null ? LIST_SPLITTER.splitToList(v) : ImmutableList.of();
    }

    public <T extends Enum<T>> T valueFrom(AttributeSupplier src, Class<T> enumType) {
        return Enum.valueOf(enumType, this.valueFrom(src));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeKey)) {
            return false;
        }
        AttributeKey other = (AttributeKey)obj;
        return this.elementName.equals(other.elementName) && this.attributeName.equals(other.attributeName);
    }

    public int hashCode() {
        return Objects.hash(this.elementName, this.attributeName);
    }

    public String toString() {
        return this.elementName + ":" + this.attributeName;
    }

    private static String checkValidLabel(String value, String description) {
        Preconditions.checkArgument(!value.isEmpty(), "%s cannot be empty", (Object)description);
        Preconditions.checkArgument(CharMatcher.ascii().matchesAllOf(value), "non-ascii character in %s: %s", (Object)description, (Object)value);
        return value;
    }

    static interface AttributeSupplier {
        public String get(AttributeKey var1);

        public CldrDataType getDataType();
    }
}

