/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.tool.CldrVersion;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.StringId;

public class OutdatedPaths {
    public static String FORMAT_KEY = "odp-1";
    public static final String NO_VALUE = "\ufffd";
    public static final String OUTDATED_DIR = "births/";
    public static final String OUTDATED_ENGLISH_DATA = "outdatedEnglish.data";
    public static final String OUTDATED_DATA = "outdated.data";
    private static final boolean DEBUG = CldrUtility.getProperty("OutdatedPathsDebug", false);
    private final Map<String, Set<Long>> localeToData = new HashMap<String, Set<Long>>();
    private final Map<Long, Pair<CldrVersion, String>> pathToBirthNPrevious = new HashMap<Long, Pair<CldrVersion, String>>();
    static RegexLookup<Boolean> SKIP_PATHS = new RegexLookup<Boolean>().add("/exemplarCharacters", Boolean.valueOf(true)).add("/references", (Boolean)true).add("/delimiters/[^/]*uotation", (Boolean)true).add("/posix", (Boolean)true).add("/pattern", (Boolean)true).add("/fields/field[^/]*/displayName", (Boolean)true).add("/dateFormatItem", (Boolean)true).add("/numbers/symbols", (Boolean)true).add("/fallback", (Boolean)true).add("/quarters", (Boolean)true).add("/months", (Boolean)true);
    private static Reference<OutdatedPaths> SINGLETON = new SoftReference<Object>(null);

    public OutdatedPaths() {
        this(null);
    }

    public OutdatedPaths(String directory) {
        HashMap<Long, PathHeader> id2header = new HashMap<Long, PathHeader>();
        this.readLocaleToPaths(directory, id2header);
        OutdatedPaths.readBirthValues(directory, id2header, this.pathToBirthNPrevious);
    }

    private void readLocaleToPaths(String directory, Map<Long, PathHeader> id2header) {
        try {
            String locale;
            DataInputStream dataIn = OutdatedPaths.openDataInput(directory, OUTDATED_DATA);
            String key = dataIn.readUTF();
            if (!FORMAT_KEY.equals(key)) {
                throw new IllegalArgumentException("Mismatch in FORMAT_KEY: expected=" + FORMAT_KEY + ", read=" + key);
            }
            if (DEBUG) {
                Factory factory = CLDRConfig.getInstance().getMainAndAnnotationsFactory();
                id2header = this.getIdToPath(factory);
            }
            while (!(locale = dataIn.readUTF()).equals("$END$")) {
                if (DEBUG) {
                    System.out.println("OutdatedPaths: Locale: " + locale);
                }
                HashSet<Long> data = new HashSet<Long>();
                int size = dataIn.readInt();
                for (int i = 0; i < size; ++i) {
                    long item = dataIn.readLong();
                    data.add(item);
                    if (!DEBUG) continue;
                    System.out.println(locale + "\t" + String.valueOf(id2header.get(item)));
                }
                this.localeToData.put(locale, Collections.unmodifiableSet(data));
            }
            dataIn.close();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Data Not Available", e);
        }
    }

    public static void readBirthValues(String outdatedDirectory, Map<Long, PathHeader> id2header, Map<Long, Pair<CldrVersion, String>> pathToBirthNPrevious2) {
        try {
            DataInputStream dataIn = OutdatedPaths.openDataInput(outdatedDirectory, OUTDATED_ENGLISH_DATA);
            String key = dataIn.readUTF();
            if (!FORMAT_KEY.equals(key)) {
                throw new IllegalArgumentException("Mismatch in FORMAT_KEY: expected=" + FORMAT_KEY + ", read=" + key);
            }
            int size = dataIn.readInt();
            if (DEBUG) {
                System.out.println("English Data");
            }
            for (int i = 0; i < size; ++i) {
                long pathId = dataIn.readLong();
                String previous = dataIn.readUTF();
                CldrVersion birth = CldrVersion.from(dataIn.readUTF());
                if (DEBUG) {
                    System.out.println("en\t(" + previous + ")" + (String)(id2header == null ? "" : "\t" + String.valueOf(id2header.get(pathId))));
                }
                pathToBirthNPrevious2.put(pathId, (Pair<CldrVersion, String>)Pair.of(birth, previous).freeze());
            }
            String finalCheck = dataIn.readUTF();
            if (!finalCheck.equals("$END$")) {
                throw new IllegalArgumentException("Corrupted outdatedEnglish.data");
            }
            dataIn.close();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Data Not Available", e);
        }
    }

    public Map<Long, PathHeader> getIdToPath(Factory factory) {
        HashMap<Long, PathHeader> result = new HashMap<Long, PathHeader>();
        CLDRFile english = factory.make("en", true);
        PathHeader.Factory pathHeaders = PathHeader.getFactory(english);
        for (String s2 : english) {
            long id = StringId.getId(s2);
            PathHeader pathHeader = pathHeaders.fromPath(s2);
            result.put(id, pathHeader);
        }
        return result;
    }

    private static DataInputStream openDataInput(String directory, String filename) throws FileNotFoundException {
        String dataFileName = filename;
        InputStream fileInputStream = directory == null ? CldrUtility.getInputStream(OUTDATED_DIR + dataFileName) : InputStreamFactory.createInputStream(new File(directory, dataFileName));
        DataInputStream dataIn = new DataInputStream(fileInputStream);
        return dataIn;
    }

    public boolean isOutdated(String locale, String distinguishedPath) {
        Set<Long> data = this.localeToData.get(locale);
        if (data == null) {
            return false;
        }
        long id = StringId.getId(distinguishedPath);
        boolean result = data.contains(id);
        if (!result) {
            return false;
        }
        Boolean toSkip = SKIP_PATHS.get(distinguishedPath);
        if (toSkip != null) {
            return false;
        }
        return result;
    }

    public boolean isRawOutdated(String locale, String distinguishedPath) {
        Set<Long> data = this.localeToData.get(locale);
        if (data == null) {
            return false;
        }
        long id = StringId.getId(distinguishedPath);
        return data.contains(id);
    }

    public boolean isSkipped(String distinguishedPath) {
        return SKIP_PATHS.get(distinguishedPath) != null;
    }

    public String getPreviousEnglish(String distinguishedPath) {
        long id = StringId.getId(distinguishedPath);
        Pair<CldrVersion, String> value = this.pathToBirthNPrevious.get(id);
        return value == null ? null : value.getSecond();
    }

    public CldrVersion getEnglishBirth(String distinguishedPath) {
        long id = StringId.getId(distinguishedPath);
        Pair<CldrVersion, String> value = this.pathToBirthNPrevious.get(id);
        return value == null ? null : value.getFirst();
    }

    public int countOutdated(String locale) {
        Set<Long> data = this.localeToData.get(locale);
        return data == null ? 0 : data.size();
    }

    public static OutdatedPaths getInstance() {
        OutdatedPaths outdatedPaths = SINGLETON.get();
        if (outdatedPaths == null) {
            outdatedPaths = new OutdatedPaths();
            SINGLETON = new SoftReference<OutdatedPaths>(outdatedPaths);
        }
        return outdatedPaths;
    }
}

