/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.PathUtilities;

@CLDRTool(alias="CompareFilesBetweenReleases", description="Print a report of which files changed since the last release")
public class CompareFilesBetweenReleases2 {
    private static final String RELEASE_DIRECTORY = CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + ToolConstants.LAST_RELEASE_VERSION + "/";
    static final Set<String> SKIP = ImmutableSet.of("seed", "exemplars", "docs", "tools");

    public static void main(String[] args) throws IOException {
        File stagingFile = new File(CLDRPaths.BASE_DIRECTORY);
        File lastFile = new File(RELEASE_DIRECTORY);
        System.out.println("Comparing " + lastFile.getAbsolutePath() + " vs " + stagingFile.getAbsolutePath());
        Set<String> staging = CompareFilesBetweenReleases2.getFiles(stagingFile, SKIP);
        Set<String> lastRelease = CompareFilesBetweenReleases2.getFiles(lastFile, SKIP);
        Set<String> stagingCommon = CompareFilesBetweenReleases2.getFiles(new File(stagingFile, "common"), Collections.emptySet());
        Set<String> stagingSeed = CompareFilesBetweenReleases2.getFiles(new File(stagingFile, "seed"), Collections.emptySet());
        Set<String> lastCommon = CompareFilesBetweenReleases2.getFiles(new File(lastFile, "common"), Collections.emptySet());
        Set<String> lastSeed = CompareFilesBetweenReleases2.getFiles(new File(lastFile, "seed"), Collections.emptySet());
        Set seedToCommon = lastSeed.stream().distinct().filter(stagingCommon::contains).map(s2 -> "/common" + s2).collect(Collectors.toCollection(() -> new TreeSet()));
        Set commonToSeed = lastCommon.stream().distinct().filter(stagingSeed::contains).map(s2 -> "/seed" + s2).collect(Collectors.toCollection(() -> new TreeSet()));
        Set commonToSeedExclude = lastCommon.stream().distinct().filter(stagingSeed::contains).map(s2 -> "/common" + s2).collect(Collectors.toCollection(() -> new TreeSet()));
        if (!seedToCommon.isEmpty()) {
            System.out.println("\nMoved from Seed to Common:\n");
            seedToCommon.forEach(f -> System.out.println((String)f));
        }
        if (!commonToSeed.isEmpty()) {
            System.out.println("\nMoved from Common to Seed:\n");
            commonToSeed.forEach(f -> System.out.println((String)f));
        }
        System.out.println("\nIn main, but not " + ToolConstants.LAST_RELEASE_VERSION + ":\n");
        CompareFilesBetweenReleases2.showDiff(staging, lastRelease, seedToCommon);
        System.out.println("\nIn " + ToolConstants.LAST_RELEASE_VERSION + ", but not main:\n");
        CompareFilesBetweenReleases2.showDiff(lastRelease, staging, commonToSeedExclude);
    }

    private static void showDiff(Set<String> staging, Set<String> lastRelease, Set<String> skip) {
        LinkedHashSet<String> staging_release = new LinkedHashSet<String>(staging);
        staging_release.removeAll(lastRelease);
        int skippedItems = 0;
        for (String file : staging_release) {
            if (skip.contains(file)) {
                ++skippedItems;
                continue;
            }
            System.out.println(file);
        }
        if (skippedItems > 0) {
            System.out.println("(plus " + skippedItems + " skipped item(s) listed above)");
        }
    }

    private static Set<String> getFiles(File base, Set<String> skip) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        int baseLen = PathUtilities.getNormalizedPathString(base).length();
        CompareFilesBetweenReleases2.getFiles(baseLen, base, result, skip);
        return result;
    }

    private static void getFiles(int baseLen, File subdir, Set<String> names, Set<String> skip) throws IOException {
        String name = subdir.getName();
        if (subdir.isDirectory()) {
            if (skip.contains(name) || name.startsWith(".")) {
                return;
            }
            for (File file : subdir.listFiles()) {
                CompareFilesBetweenReleases2.getFiles(baseLen, file, names, skip);
            }
        } else {
            if (name.startsWith(".")) {
                return;
            }
            String fullName = PathUtilities.getNormalizedPathString(subdir);
            names.add(fullName.substring(baseLen));
        }
    }
}

