/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Normalizer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FilterCharacterFallbacks {
    public static void main(String[] args) throws IOException {
        Document fb = LDMLUtilities.parse(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY + File.separator + "characters.xml", true);
        if (fb != null) {
            PrintWriter out = FileUtilities.openUTF8Writer(".", "report");
            Node n = LDMLUtilities.getNode(fb, "//supplementalData/characters/character-fallback");
            for (Node cf = n.getFirstChild(); cf != null; cf = cf.getNextSibling()) {
                String srcChar = LDMLUtilities.getAttributeValue(cf, "value");
                if (srcChar == null) continue;
                for (Node sb = cf.getFirstChild(); sb != null; sb = sb.getNextSibling()) {
                    String toNFKC;
                    boolean canonicallyEquivalent;
                    String subChars = LDMLUtilities.getNodeValue(sb);
                    if (subChars == null) continue;
                    boolean bl = canonicallyEquivalent = Normalizer.compare(srcChar, subChars, 0) == 0;
                    if (canonicallyEquivalent) {
                        out.println("Remove Character \"" + srcChar + "\" (" + Utility.escape(srcChar) + ")    Substitute \"" + subChars + "\" (" + Utility.escape(subChars) + ") - Canonically equivalent.");
                    }
                    if (subChars.equals(toNFKC = Normalizer.normalize(srcChar, Normalizer.NFKC))) {
                        out.println("Remove Character \"" + srcChar + "\" (" + Utility.escape(srcChar) + ")    Substitute \"" + subChars + "\" (" + Utility.escape(subChars) + ") - a toNFKC form.");
                        continue;
                    }
                    out.println("OK - Character \"" + srcChar + "\" (" + Utility.escape(srcChar) + ")    Substitute \"" + subChars + "\" (" + Utility.escape(subChars) + ")");
                }
            }
            out.close();
        } else {
            System.out.println("Couldn't open characters.xml...");
        }
    }
}

