/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.DateTimeCanonicalizer;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.PreferredAndAllowedHour;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.With;

public class FindPreferredHours {
    private static CLDRConfig INFO = ToolConfig.getToolInstance();
    private static final CLDRFile ENGLISH = INFO.getEnglish();
    private static final UnicodeSet DIGITS = new UnicodeSet("[0-9]").freeze();
    private static final Set<Character> ONLY24 = Collections.unmodifiableSet(new LinkedHashSet<Character>(Arrays.asList(Character.valueOf('H'))));
    private static final Map<String, Set<Character>> OVERRIDE_ALLOWED = Builder.with(new HashMap()).put("RU", ONLY24).put("IL", ONLY24).freeze();
    private static final Map<String, Character> CONFLICT_RESOLUTION = Builder.with(new HashMap()).put("DJ", Character.valueOf('h')).put("KM", Character.valueOf('H')).put("MG", Character.valueOf('H')).put("MU", Character.valueOf('H')).put("MZ", Character.valueOf('H')).put("SC", Character.valueOf('H')).put("CM", Character.valueOf('H')).put("TD", Character.valueOf('h')).put("DZ", Character.valueOf('h')).put("MA", Character.valueOf('h')).put("TN", Character.valueOf('h')).put("BW", Character.valueOf('h')).put("LS", Character.valueOf('h')).put("NA", Character.valueOf('h')).put("SZ", Character.valueOf('h')).put("ZA", Character.valueOf('h')).put("GH", Character.valueOf('h')).put("MR", Character.valueOf('h')).put("NG", Character.valueOf('h')).put("TG", Character.valueOf('H')).put("CA", Character.valueOf('h')).put("US", Character.valueOf('h')).put("CN", Character.valueOf('h')).put("MO", Character.valueOf('h')).put("PH", Character.valueOf('H')).put("IN", Character.valueOf('h')).put("LK", Character.valueOf('H')).put("CY", Character.valueOf('h')).put("IL", Character.valueOf('H')).put("SY", Character.valueOf('h')).put("MK", Character.valueOf('H')).put("VU", Character.valueOf('h')).put("TO", Character.valueOf('H')).put("001", Character.valueOf('H')).freeze();

    public static void main(String[] args) {
        String region;
        Relation<String, Hours> lang2Hours = Relation.of(new TreeMap(), TreeSet.class);
        Factory factory = INFO.getCldrFactory();
        DateTimePatternGenerator.FormatParser formatDateParser = new DateTimePatternGenerator.FormatParser();
        LikelySubtags likely2Max = new LikelySubtags();
        for (String locale : factory.getAvailable()) {
            if (locale.equals("root")) continue;
            CLDRFile cldrFile = factory.make(locale, true);
            for (String path : With.in(new Iterable[]{cldrFile})) {
                DateTimeCanonicalizer.DateTimePatternType type = DateTimeCanonicalizer.DateTimePatternType.fromPath(path);
                if (type == DateTimeCanonicalizer.DateTimePatternType.NA || type == DateTimeCanonicalizer.DateTimePatternType.GMT) continue;
                String string = cldrFile.getStringValue(path);
                formatDateParser.set(string);
                for (Object item : formatDateParser.getItems()) {
                    String itemString;
                    if (!(item instanceof DateTimePatternGenerator.VariableField) || !PreferredAndAllowedHour.HourStyle.isHourCharacter(itemString = item.toString())) continue;
                    lang2Hours.put(locale, new Hours(type, itemString));
                }
            }
            System.out.println(locale + "\t" + String.valueOf(lang2Hours.get(locale)));
        }
        TreeMap<String, Relation<Character, String>> region2Preferred2locales = new TreeMap<String, Relation<Character, String>>();
        Relation<String, Character> region2Allowed = Relation.of(new TreeMap(), TreeSet.class);
        LanguageTagParser ltp = new LanguageTagParser();
        for (Map.Entry localeAndHours : lang2Hours.keyValuesSet()) {
            String locale = (String)localeAndHours.getKey();
            String string = likely2Max.maximize(locale);
            if (string == null) {
                System.out.println("*** Missing likely for " + locale);
                continue;
            }
            region = ltp.set(string).getRegion();
            if (region.isEmpty()) {
                System.out.println("*** Missing region for " + locale + ", " + string);
                continue;
            }
            if (DIGITS.containsSome(region) && !region.equals("001")) {
                System.out.println("*** Skipping multicountry region for " + locale + ", " + string);
                continue;
            }
            for (Hours hours : (Set)localeAndHours.getValue()) {
                region2Allowed.put(region, Character.valueOf(hours.variable));
                if (hours.type != DateTimeCanonicalizer.DateTimePatternType.STOCK) continue;
                Relation<Character, String> items = (Relation<Character, String>)region2Preferred2locales.get(region);
                if (items == null) {
                    items = Relation.of(new TreeMap(), TreeSet.class);
                    region2Preferred2locales.put(region, items);
                }
                items.put(Character.valueOf(hours.variable), locale);
            }
        }
        Relation<PreferredAndAllowedHour, String> preferred2Region = Relation.of(new TreeMap(), TreeSet.class);
        StringBuilder overrides = new StringBuilder("\n");
        for (Map.Entry entry : region2Preferred2locales.entrySet()) {
            region = (String)entry.getKey();
            Set allowed = region2Allowed.get(region);
            Relation preferredSet = (Relation)entry.getValue();
            Character resolvedValue = CONFLICT_RESOLUTION.get(region);
            if (resolvedValue != null) {
                if (preferredSet.size() == 1) {
                    overrides.append(region + " didn't need override!!\n");
                } else {
                    LinkedHashSet oldValues = new LinkedHashSet();
                    StringBuilder oldValuesString = new StringBuilder();
                    for (Map.Entry entry2 : preferredSet.keyValueSet()) {
                        if (((Character)entry2.getKey()).equals(resolvedValue)) continue;
                        oldValues.add(entry2);
                        oldValuesString.append(String.valueOf(entry2.getKey()) + "=" + (String)((Object)entry2.getValue()) + "; ");
                    }
                    for (Map.Entry entry3 : oldValues) {
                        preferredSet.remove((Character)entry3.getKey(), (String)((Object)entry3.getValue()));
                    }
                    overrides.append(region + " has multiple values. Overriding with CONFLICT_RESOLUTION to " + resolvedValue + " and discarded values " + String.valueOf(oldValuesString) + "\n");
                }
            }
            TreeSet<Character> allAllowed = new TreeSet();
            Character preferred = null;
            for (Map.Entry entry4 : preferredSet.keyValuesSet()) {
                allAllowed.addAll(allowed);
                if (preferred == null) {
                    preferred = (Character)entry4.getKey();
                    continue;
                }
                overrides.append(region + " has multiple preferred values! " + String.valueOf(preferredSet) + "\n");
            }
            Set<Character> overrideAllowed = OVERRIDE_ALLOWED.get(region);
            if (overrideAllowed != null) {
                allAllowed = overrideAllowed;
                overrides.append(region + " overriding allowed to " + String.valueOf(overrideAllowed) + "\n");
            }
            preferred2Region.put(new PreferredAndAllowedHour(preferred.charValue(), allAllowed), region);
            String string = Containment.getSubcontinent(region);
            String continent = Containment.getContinent(region);
            Object tag = Joiner.on(",").join(preferredSet.keySet());
            if (((String)tag).equals("h")) {
                tag = (String)tag + "*";
            }
            NameGetter englishNameGetter = ENGLISH.nameGetter();
            System.out.println((String)tag + "\t" + region + "\t" + englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, region) + "\t" + string + "\t" + englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, string) + "\t" + continent + "\t" + englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, continent) + "\t" + FindPreferredHours.showInfo(preferredSet));
        }
        System.out.println("    <timeData>");
        for (Map.Entry entry : preferred2Region.keyValuesSet()) {
            PreferredAndAllowedHour preferredAndAllowedHour = (PreferredAndAllowedHour)entry.getKey();
            Set regions = (Set)entry.getValue();
            System.out.println("        <hours preferred=\"" + String.valueOf((Object)preferredAndAllowedHour.preferred) + "\" allowed=\"" + Joiner.on(" ").join(preferredAndAllowedHour.allowed) + "\" regions=\"" + Joiner.on(" ").join(regions) + "\"/>");
        }
        System.out.println("    </timeData>");
        System.out.println(overrides);
    }

    private static String showInfo(Relation<Character, String> preferredSet) {
        StringBuilder b = new StringBuilder();
        for (Character key : Arrays.asList(Character.valueOf('H'), Character.valueOf('h'))) {
            if (b.length() != 0) {
                b.append('\t');
            }
            b.append(key).append('\t');
            Set<String> value = preferredSet.get(key);
            if (value == null) continue;
            boolean needSpace = false;
            for (String locale : value) {
                if (needSpace) {
                    b.append(" ");
                } else {
                    needSpace = true;
                }
                b.append(locale);
                boolean isOfficial = false;
                if (!(isOfficial = FindPreferredHours.isOfficial(locale, isOfficial))) continue;
                b.append('\u00b0');
            }
        }
        return b.toString();
    }

    private static boolean isOfficial(String locale, boolean isOfficial) {
        SupplementalDataInfo.OfficialStatus status;
        LanguageTagParser ltp = new LanguageTagParser().set(locale);
        SupplementalDataInfo.PopulationData data = INFO.getSupplementalDataInfo().getLanguageAndTerritoryPopulationData(ltp.getLanguageScript(), ltp.getRegion());
        if (data == null) {
            data = INFO.getSupplementalDataInfo().getLanguageAndTerritoryPopulationData(ltp.getLanguage(), ltp.getRegion());
        }
        if (data != null && ((status = data.getOfficialStatus()) == SupplementalDataInfo.OfficialStatus.official || status == SupplementalDataInfo.OfficialStatus.de_facto_official)) {
            isOfficial = true;
        }
        return isOfficial;
    }

    static final class Hours
    implements Comparable<Hours> {
        final DateTimeCanonicalizer.DateTimePatternType type;
        final char variable;

        public Hours(DateTimeCanonicalizer.DateTimePatternType type, String variable) {
            this.type = type;
            this.variable = variable.charAt(0);
        }

        @Override
        public int compareTo(Hours arg0) {
            int result = this.type.compareTo(arg0.type);
            if (result != 0) {
                return result;
            }
            return this.variable < arg0.variable ? -1 : (this.variable > arg0.variable ? 1 : 0);
        }

        public String toString() {
            return String.valueOf((Object)this.type) + ":" + this.variable;
        }

        public boolean equals(Object obj) {
            return obj instanceof Hours && this.compareTo((Hours)obj) == 0;
        }
    }
}

