/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.RegexUtilities;

public class RegexModify {
    public static void main(String[] args) throws Exception {
        MyOptions.parse(args, true);
        File sourceDirectory = new File(MyOptions.sourceDirectory.option.getValue());
        File targetDirectory = new File(MyOptions.targetDirectory.option.getValue());
        Matcher fileMatcher = Pattern.compile(MyOptions.fileRegex.option.getValue()).matcher("");
        String functionName = MyOptions.applyFunction.option.getValue();
        RegexFunction f = (RegexFunction)RegexModify.getFunction(RegexModify.class, functionName);
        for (String file : sourceDirectory.list()) {
            if (!fileMatcher.reset(file).matches()) continue;
            try (BufferedReader in = FileUtilities.openUTF8Reader(sourceDirectory.toString(), file);
                 PrintWriter out = FileUtilities.openUTF8Writer(targetDirectory.toString(), file);){
                f.clear();
                for (String line : FileUtilities.in(in)) {
                    String newLine = f.apply(line);
                    if (newLine == null) continue;
                    out.println(newLine);
                }
                System.out.println(f.getChangedCount() + " changed lines in " + file);
            }
        }
    }

    private static <T> T getFunction(Class class1, String applyFunction) {
        Map<String, Class<Function>> methods = RegexModify.getMethods(class1);
        Class<Function> result = methods.get(applyFunction);
        try {
            return (T)result.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("-a value must be in " + String.valueOf(methods.keySet()) + " but is \u201c" + applyFunction + "\u201d");
        }
    }

    private static Map<String, Class<Function>> getMethods(Class class1) {
        ImmutableMap.Builder<String, Class<?>> result = ImmutableMap.builder();
        for (Class<?> classMember : class1.getClasses()) {
            if ((0x400 & classMember.getModifiers()) != 0 || !Function.class.isAssignableFrom(classMember)) continue;
            String name = classMember.getName();
            result.put(name.substring(name.indexOf(36) + 1), classMember);
        }
        return result.build();
    }

    public static class Subdivision
    extends RegexFunction {
        @Override
        public String getCheckOnPattern() {
            return "subdivision";
        }

        @Override
        public String getPattern() {
            return "(.*<subdivision(?:Alias)? type=\")([^\"]+)(\" replacement=\")([^\"]+)(\".*)";
        }

        @Override
        public String fixLine() {
            String value = Subdivision.convertToCldr(this.lineMatcher.group(2));
            String value2 = Subdivision.convertToCldr(this.lineMatcher.group(4));
            return this.lineMatcher.replaceAll("$1" + value + "$3" + value2 + "$5");
        }

        private static boolean isRegionCode(String s2) {
            return s2.length() == 2 || s2.length() == 3 && s2.compareTo("A") < 0;
        }

        private static String convertToCldr(String regionOrSubdivision) {
            return Subdivision.isRegionCode(regionOrSubdivision) ? regionOrSubdivision.toUpperCase(Locale.ROOT) : regionOrSubdivision.replace("-", "").toLowerCase(Locale.ROOT);
        }
    }

    public static abstract class RegexFunction
    implements Function<String, String> {
        protected Matcher lineMatcher = Pattern.compile(this.getPattern()).matcher("");
        private int count;

        public void clear() {
            this.count = 0;
        }

        public int getChangedCount() {
            return this.count;
        }

        @Override
        public String apply(String line) {
            if (this.lineMatcher.reset(line).matches()) {
                String oldLine = line;
                line = this.fixLine();
                if (!line.equals(oldLine)) {
                    ++this.count;
                }
            } else if (this.getCheckOnPattern() != null && line.contains(this.getCheckOnPattern())) {
                System.out.println(RegexUtilities.showMismatch(this.lineMatcher, (CharSequence)line));
            }
            return line;
        }

        public abstract String getPattern();

        public abstract String getCheckOnPattern();

        public abstract String fixLine();
    }

    static enum MyOptions {
        verbose(new Option.Params().setHelp("verbose debugging messages")),
        sourceDirectory(new Option.Params().setHelp("sourceDirectory").setDefault(CLDRPaths.COMMON_DIRECTORY).setMatch(".+")),
        targetDirectory(new Option.Params().setHelp("targetDirectory").setDefault(CLDRPaths.GEN_DIRECTORY + "xmlModify").setMatch(".+")),
        fileRegex(new Option.Params().setHelp("filename regex").setMatch(".*").setDefault(".*\\.xml")),
        lineRegex(new Option.Params().setHelp("line regex").setMatch(".*")),
        applyFunction(new Option.Params().setHelp("function name to apply").setMatch(".*"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

