/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Objects;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ShowRegionalVariants {
    private static String MY_DIR;
    private static final boolean SKIP_SUPPRESSED_PATHS = true;
    private static final CLDRConfig CONFIG;
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO;
    private static final Factory FACTORY;
    private static final CLDRFile ENGLISH;
    private static final CLDRLocale ROOT;
    private static final CLDRLocale SWISS_HIGH_GERMAN;
    static final Option.Options myOptions;
    static final LikelySubtags LS;
    static final UnicodeSet SPREAD_SHEET_SENSITIVE;

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.targetDir, args, true);
        MY_DIR = MyOptions.targetDir.option.getValue();
        Set<String> coverageLocales = StandardCodes.make().getLocaleCoverageLocales("cldr");
        HashSet<String> dc = new HashSet<String>(SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales());
        HashSet<String> skipLocales = new HashSet<String>(Arrays.asList("root", "en_US_POSIX", "sr_Latn"));
        Relation<CLDRLocale, CLDRLocale> parentToChildren = Relation.of(new TreeMap(), TreeSet.class);
        for (String locale : FACTORY.getAvailable()) {
            CLDRLocale loc;
            if (skipLocales.contains(locale.toString()) || dc.contains(locale.toString()) || !coverageLocales.contains((loc = CLDRLocale.getInstance(locale)).getLanguage())) continue;
            CLDRLocale parent = null;
            CLDRLocale current = loc;
            while (dc.contains((parent = current.getParent()).toString())) {
                current = parent;
            }
            if (ROOT.equals(parent)) continue;
            if ("root".equals(parent.toString())) {
                throw new IllegalArgumentException("CLDRLocale failure");
            }
            parentToChildren.put(parent, loc);
        }
        System.out.println("Locale Name\tCode\tRegion\tInherits from\tCode");
        ShowRegionalVariants.showInheritance(parentToChildren);
        Relation<String, String> valueToAncestors = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
        int count = 0;
        try (PrintWriter grandSummary = FileUtilities.openUTF8Writer(MY_DIR, "GrandSummary.txt");
             PrintWriter summary = FileUtilities.openUTF8Writer(MY_DIR, "Summary.txt");
             PrintWriter detailFile = FileUtilities.openUTF8Writer(MY_DIR, "details.txt");){
            grandSummary.println("Parent\tName\tTotal Diff Count\tChildren");
            summary.println("Parent\tName\tDiff Count\tChild\tChild Name");
            detailFile.println("\u2116\tBase\tParent Locales I\tParent Locales II\tChild Locales\tEnglish value\tParent value I\tParent value II\tChild value\tCorrected Child value\tComments\tFix Parent value?\tSection\tPage\tHeader\tCode");
            PathHeader.Factory phf = PathHeader.getFactory(ENGLISH);
            String lastBase = "";
            for (Map.Entry<CLDRLocale, Set<CLDRLocale>> item : parentToChildren.keyValuesSet()) {
                CLDRLocale parent = item.getKey();
                String base = parent.getLanguage();
                CLDRFile parentFile = FACTORY.make(parent.toString(), true, CLDRFile.DraftStatus.contributed);
                ChainedMap.M4 pathToValuesToLocales = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
                Counter<CLDRLocale> childDiffs = new Counter<CLDRLocale>();
                for (CLDRLocale child : item.getValue()) {
                    String childString = child.toString();
                    CLDRFile childFile = FACTORY.make(childString, false, CLDRFile.DraftStatus.contributed);
                    for (String path : childFile) {
                        String norm;
                        String childValue;
                        if (path.contains("/currency") && path.contains("/symbol") || (childValue = childFile.getStringValue(path)) == null) continue;
                        String parentValue = parentFile.getStringValue(path);
                        if (parentValue == null) {
                            parentValue = "\u2205\u2205\u2205";
                        }
                        if (Objects.equal(childValue, parentValue) || "\u2205\u2205\u2205".equals(childValue) || "\u2205\u2205\u2205".equals(parentValue) || parentValue != null && (!child.equals(SWISS_HIGH_GERMAN) ? base.equals("en") && (ShowRegionalVariants.sameExceptEnd(childValue, "re", parentValue, "er") || ShowRegionalVariants.sameExceptEnd(childValue, "res", parentValue, "ers")) : childValue.equals(norm = parentValue.replace("\u00df", "ss")))) continue;
                        PathHeader pheader = phf.fromPath(path);
                        if (PathHeader.SectionId.Special == pheader.getSectionId()) continue;
                        pathToValuesToLocales.put(pheader, childValue, child, Boolean.TRUE);
                        childDiffs.add(child, 1L);
                    }
                }
                long totalChildDiffs = childDiffs.getTotal();
                if (totalChildDiffs == 0L) continue;
                if (!base.equals(lastBase)) {
                    detailFile.println();
                }
                grandSummary.println(String.valueOf(parent) + "\t" + ENGLISH.nameGetter().getNameFromIdentifier(parent.toString()) + "\t" + totalChildDiffs + "\t" + String.valueOf(item.getValue()));
                for (CLDRLocale s2 : childDiffs.getKeysetSortedByKey()) {
                    long childDiffValue = childDiffs.get(s2);
                    if (childDiffValue == 0L) continue;
                    summary.println(String.valueOf(parent) + "\t" + ENGLISH.nameGetter().getNameFromIdentifier(parent.toString()) + "\t" + childDiffValue + "\t" + String.valueOf(s2) + "\t" + ENGLISH.nameGetter().getNameFromIdentifier(s2.toString()));
                }
                ArrayList<CLDRFile> parentChain = new ArrayList<CLDRFile>();
                CLDRLocale current = parent;
                while (true) {
                    parentChain.add(FACTORY.make(current.toString(), true));
                    CLDRLocale grand = current.getParent();
                    if (ROOT.equals(grand)) break;
                    current = grand;
                }
                for (PathHeader ph : pathToValuesToLocales.keySet()) {
                    ChainedMap.M3 values = pathToValuesToLocales.get(ph);
                    valueToAncestors.clear();
                    for (String value : values.keySet()) {
                        Set childLocales = values.get(value).keySet();
                        String englishValue = ENGLISH.getStringValue(ph.getOriginalPath());
                        String originalPath = ph.getOriginalPath();
                        for (CLDRFile grand : parentChain) {
                            valueToAncestors.put(ShowRegionalVariants.quote(grand.getStringValue(originalPath)), grand.getLocaleID());
                        }
                        Set keyValuesSet = valueToAncestors.keyValuesSet();
                        int countParents = keyValuesSet.size();
                        if (countParents < 1 || countParents > 2) {
                            throw new IllegalArgumentException("Too few/many parents");
                        }
                        detailFile.print(++count + "\t" + base);
                        for (Map.Entry entry : keyValuesSet) {
                            detailFile.print("\t" + String.valueOf(entry.getValue()));
                        }
                        if (countParents == 1) {
                            detailFile.print("\t");
                        }
                        detailFile.print("\t" + String.valueOf(childLocales) + "\t" + ShowRegionalVariants.quote(englishValue));
                        for (Map.Entry entry : keyValuesSet) {
                            detailFile.print("\t" + (String)entry.getKey());
                        }
                        if (countParents == 1) {
                            detailFile.print("\t");
                        }
                        detailFile.print("\t" + ShowRegionalVariants.quote(value) + "\t\t\t\t" + String.valueOf(ph));
                        detailFile.println();
                    }
                }
            }
        }
        System.out.println("DONE");
    }

    private static void showInheritance(Relation<CLDRLocale, CLDRLocale> parentToChildren) {
        Set<CLDRLocale> values = parentToChildren.values();
        TreeSet<CLDRLocale> topParents = new TreeSet<CLDRLocale>(parentToChildren.keySet());
        topParents.removeAll(values);
        ShowRegionalVariants.showInheritance(topParents, "", parentToChildren);
    }

    private static void showInheritance(Set<CLDRLocale> topParents, String prefix, Relation<CLDRLocale, CLDRLocale> parentToChildren) {
        for (CLDRLocale locale : topParents) {
            String current = ShowRegionalVariants.nameForLocale(locale) + "\t" + prefix;
            System.out.println(current);
            Set<CLDRLocale> newChildren = parentToChildren.get(locale);
            if (newChildren == null) continue;
            ShowRegionalVariants.showInheritance(newChildren, current, parentToChildren);
        }
    }

    private static String nameForLocale(CLDRLocale key) {
        Object country = key.getCountry();
        if (((String)country).isEmpty()) {
            String max = LS.maximize(key.toString());
            LanguageTagParser ltp = new LanguageTagParser().set(max);
            country = "(" + ltp.getRegion() + ")";
        }
        return ENGLISH.nameGetter().getNameFromIdentifierOptAlt(key.toString(), NameGetter.NameOpt.DEFAULT, CLDRFile.SHORT_ALTS) + "\t" + String.valueOf(key) + "\t" + (String)country;
    }

    private static boolean sameExceptEnd(String childValue, String childEnding, String parentValue, String parentEnding) {
        return childValue.endsWith(childEnding) && parentValue.endsWith(parentEnding) && childValue.substring(0, childValue.length() - childEnding.length()).equals(parentValue.substring(0, parentValue.length() - parentEnding.length()));
    }

    private static String quote(String value) {
        if (value == null || value.isEmpty()) {
            return "\u2205\u2205\u2205";
        }
        int first = value.codePointAt(0);
        return SPREAD_SHEET_SENSITIVE.contains(first) ? "'" + value : value;
    }

    static {
        CONFIG = CLDRConfig.getInstance();
        SUPPLEMENTAL_DATA_INFO = CONFIG.getSupplementalDataInfo();
        FACTORY = CONFIG.getCldrFactory();
        ENGLISH = CONFIG.getEnglish();
        ROOT = CLDRLocale.getInstance("root");
        SWISS_HIGH_GERMAN = CLDRLocale.getInstance("de_CH");
        myOptions = new Option.Options();
        LS = new LikelySubtags();
        SPREAD_SHEET_SENSITIVE = new UnicodeSet().add(61).add(43).add(48, 57);
    }

    static enum MyOptions {
        targetDir(".*", CLDRPaths.GEN_DIRECTORY + "/regional/", "target output file.");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

