/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool.resolver;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum ResolutionType {
    SIMPLE,
    FULL,
    NO_CODE_FALLBACK;

    private static final List<String> SIMPLE_INHERITANCE;
    private static final List<String> FULLY_RESOLVED;
    private static final List<String> FULLY_RESOLVED_WITHOUT_CODE_FALLBACK;

    public static ResolutionType forString(String str) {
        if (SIMPLE_INHERITANCE.contains(str = str.toLowerCase(Locale.ENGLISH))) {
            return SIMPLE;
        }
        if (FULLY_RESOLVED.contains(str)) {
            return FULL;
        }
        if (FULLY_RESOLVED_WITHOUT_CODE_FALLBACK.contains(str)) {
            return NO_CODE_FALLBACK;
        }
        throw new IllegalArgumentException("\"" + str + "\" is not a known type of resolution.");
    }

    static {
        SIMPLE_INHERITANCE = Arrays.asList("s", "simple", "simpleinheritance", "simple-inheritance", "p", "partial");
        FULLY_RESOLVED = Arrays.asList("f", "full", "fully", "fullyresolved", "fully-resolved");
        FULLY_RESOLVED_WITHOUT_CODE_FALLBACK = Arrays.asList("n", "nc", "nocode", "no-code", "nocodefallback", "no-code-fallback");
    }
}

