/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleHtmlParser;
import org.unicode.cldr.util.SplitToArray;

public class Iso639Data {
    static Map<String, String> toAlpha3;
    static Map<String, String> fromAlpha3;
    static Map<String, String> toBiblio3;
    static Map<String, String> fromBiblio3;
    static Relation<String, String> toNames;
    static Relation<String, String> toRetirements;
    static Map<String, String> toChangeTo;
    static Map<String, Scope> toScope;
    static Map<String, List<String>> toHierarchy;
    static Map<String, Type> toType;
    static Map<String, String> encompassed_macro;
    static Relation<String, String> macro_encompassed;
    static Map<String, Source> toSource;
    private static String version;

    public static String getVersion() {
        return version;
    }

    public static Source getSource(String languageSubtag) {
        if (toAlpha3 == null) {
            Iso639Data.getData();
        }
        if (!Iso639Data.isValid(languageSubtag)) {
            return null;
        }
        Source result = toSource.get(languageSubtag);
        if (result == null) {
            return Source.ISO_639_3;
        }
        return result;
    }

    public static String toAlpha3(String languageSubtag) {
        if (toAlpha3 == null) {
            Iso639Data.getData();
        }
        if (!Iso639Data.isValid(languageSubtag)) {
            return null;
        }
        return toAlpha3.get(languageSubtag);
    }

    public static String fromAlpha3(String alpha3) {
        String alpha2;
        if (fromAlpha3 == null) {
            Iso639Data.getData();
        }
        if ((alpha2 = fromAlpha3.get(alpha3)) != null) {
            return alpha2;
        }
        if (Iso639Data.isValid(alpha3)) {
            return alpha3;
        }
        return null;
    }

    private static boolean isValid(String alpha3) {
        return toNames.containsKey(alpha3);
    }

    public static String fromBiblio3(String biblio3) {
        String result;
        if (toNames == null) {
            Iso639Data.getData();
        }
        if ((result = fromBiblio3.get(biblio3)) != null) {
            return result;
        }
        return Iso639Data.fromAlpha3(biblio3);
    }

    public static String toBiblio3(String languageTag) {
        String result;
        if (toNames == null) {
            Iso639Data.getData();
        }
        if ((result = toBiblio3.get(languageTag)) != null) {
            return result;
        }
        return Iso639Data.toAlpha3(languageTag);
    }

    public static Set<String> hasBiblio3() {
        return toBiblio3.keySet();
    }

    public static Set<String> getNames(String languageSubtag) {
        if (toNames == null) {
            Iso639Data.getData();
        }
        return toNames.getAll(languageSubtag);
    }

    public static Scope getScope(String languageSubtag) {
        if (toScope == null) {
            Iso639Data.getData();
        }
        if (!Iso639Data.isValid(languageSubtag)) {
            return Scope.Unknown;
        }
        Scope result = toScope.get(languageSubtag);
        if (result != null) {
            return result;
        }
        return Scope.Individual;
    }

    public static List<String> getHierarchy(String languageSubtag) {
        if (toHierarchy == null) {
            Iso639Data.getData();
        }
        return toHierarchy.get(languageSubtag);
    }

    public static Type getType(String languageSubtag) {
        if (toAlpha3 == null) {
            Iso639Data.getData();
        }
        if (!Iso639Data.isValid(languageSubtag)) {
            return Type.Unknown;
        }
        Type result = toType.get(languageSubtag);
        if (result != null) {
            return result;
        }
        return Type.Living;
    }

    /*
     * Unable to fully structure code
     */
    private static void getData() {
        try {
            in = CldrUtility.getUTF8Data("iso-639-3-version.tab");
            Iso639Data.version = in.readLine().trim();
            in.close();
            in = CldrUtility.getUTF8Data("iso-639-3.tab");
            tabs = new SplitToArray(Splitter.on('\t').trimResults());
            Iso639Data.toAlpha3 = new HashMap<String, String>();
            Iso639Data.fromAlpha3 = new HashMap<String, String>();
            Iso639Data.toBiblio3 = new HashMap<String, String>();
            Iso639Data.fromBiblio3 = new HashMap<String, String>();
            Iso639Data.toScope = new HashMap<String, Scope>();
            Iso639Data.toType = new HashMap<String, Type>();
            Iso639Data.toNames = Relation.of(new TreeMap<K, V>(), LinkedHashSet.class);
            Iso639Data.toRetirements = Relation.of(new TreeMap<K, V>(), LinkedHashSet.class);
            Iso639Data.toChangeTo = new TreeMap<String, String>();
            Iso639Data.macro_encompassed = Relation.of(new TreeMap<K, V>(), LinkedHashSet.class);
            Iso639Data.encompassed_macro = new HashMap<String, String>();
            Iso639Data.toSource = new HashMap<String, Source>();
            Iso639Data.toSource.put("sh", Source.ISO_639_1);
            count = 0;
            while (true) {
                ++count;
                line = in.readLine();
                if (line == null) break;
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if ((line = line.trim()).isEmpty() || (alpha3 = (parts = tabs.split(line))[IsoColumn.Id.ordinal()]).equals("Id")) continue;
                languageSubtag = alpha3;
                if (parts[IsoColumn.Part1.ordinal()].length() != 0) {
                    languageSubtag = parts[IsoColumn.Part1.ordinal()];
                    Iso639Data.toAlpha3.put(languageSubtag, alpha3);
                    Iso639Data.fromAlpha3.put(alpha3, languageSubtag);
                }
                if (parts[IsoColumn.Part2B.ordinal()].length() != 0 && !(biblio = parts[IsoColumn.Part2B.ordinal()]).equals(alpha3)) {
                    Iso639Data.toBiblio3.put(languageSubtag, biblio);
                    Iso639Data.fromBiblio3.put(biblio, languageSubtag);
                }
                Iso639Data.toNames.put(languageSubtag, parts[IsoColumn.Ref_Name.ordinal()]);
                scope = Iso639Data.findMatchToPrefix(parts[IsoColumn.Scope.ordinal()], Scope.values());
                if (scope != Scope.Individual) {
                    Iso639Data.toScope.put(languageSubtag, scope);
                }
                if ((type = Iso639Data.findMatchToPrefix(parts[IsoColumn.Type.ordinal()], Type.values())) == Type.Living) continue;
                Iso639Data.toType.put(languageSubtag, type);
            }
            in.close();
            in = CldrUtility.getUTF8Data("iso-639-3_Retirements.tab");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if ((alpha3 = (parts = tabs.split(line))[0]).equals("Id")) continue;
                Iso639Data.toNames.put(alpha3, parts[1]);
                if (!parts[3].isEmpty()) {
                    Iso639Data.toChangeTo.put(alpha3, parts[3]);
                }
                Iso639Data.toRetirements.put(alpha3, line);
            }
            in.close();
            in = CldrUtility.getUTF8Data("iso-639-3-macrolanguages.tab");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if ((prefix = (parts = tabs.split(line))[0]).equals("M_Id")) continue;
                prefix = Iso639Data.fromAlpha3(prefix);
                suffix = Iso639Data.fromAlpha3(parts[1]);
                if (suffix == null || prefix == null) {
                    throw new IllegalArgumentException();
                }
                Iso639Data.encompassed_macro.put(suffix, prefix);
                Iso639Data.macro_encompassed.put(prefix, suffix);
            }
            in.close();
            in = CldrUtility.getUTF8Data("iso-639-3_Name_Index.tab");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if ((alpha3 = (parts = tabs.split(line))[IsoColumn.Id.ordinal()]).equals("Id")) continue;
                languageSubTag = Iso639Data.fromAlpha3(alpha3);
                Iso639Data.toNames.put(languageSubTag, parts[IsoNamesColumn.Print_Name.ordinal()]);
            }
            in.close();
            in = CldrUtility.getUTF8Data("ISO-639-2_values_8bits.txt");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if ((alpha3 = (parts = line.split("\\s*\\|\\s*"))[0]).equals("qaa-qtz")) {
                    for (second = 'a'; second <= 't'; second = (char)(second + '\u0001')) {
                        for (third = 'a'; third <= 'z'; third = (char)(third + '\u0001')) {
                            languageSubtag = "q" + second + third;
                            Iso639Data.toScope.put(languageSubtag, Scope.PrivateUse);
                            Iso639Data.toType.put(languageSubtag, Type.Special);
                            Iso639Data.toNames.put(languageSubtag, "private-use");
                            Iso639Data.toSource.put(languageSubtag, Source.ISO_639_2);
                        }
                    }
                    continue;
                }
                if (parts[1].length() != 0) {
                    alpha3 = parts[1];
                }
                if ((languageSubtag = parts[2]).length() == 0) {
                    languageSubtag = alpha3;
                }
                english = parts[3].split(";");
                Iso639Data.toSource.put(languageSubtag, languageSubtag.length() == 2 ? Source.ISO_639_1 : Source.ISO_639_2);
                if (Iso639Data.isValid(languageSubtag)) continue;
                if (languageSubtag.length() == 2) {
                    Iso639Data.toAlpha3.put(languageSubtag, alpha3);
                    Iso639Data.fromAlpha3.put(alpha3, languageSubtag);
                }
                Iso639Data.toScope.put(languageSubtag, Scope.Collection);
                Iso639Data.toType.put(languageSubtag, Type.Special);
                Iso639Data.toNames.putAll(languageSubtag, Arrays.asList(english));
            }
            in.close();
            toHierarchyTemp = new TreeMap<String, Object>();
            in = CldrUtility.getUTF8Data("external/Iso639-5.html");
            lastCode = null;
            column = 0;
            lastAttributeIsScope = false;
            lastElementIsTD = false;
            hadPop = true;
            simple = new SimpleHtmlParser().setReader(in);
            result = new StringBuilder();
            block28: while (true) {
                x = simple.next(result);
                switch (1.$SwitchMap$org$unicode$cldr$util$SimpleHtmlParser$Type[x.ordinal()]) {
                    case 1: {
                        hadPop = false;
                        lastElementIsTD = false;
                        ** GOTO lbl191
                    }
                    case 2: {
                        if (!SimpleHtmlParser.equals("tr", result)) ** GOTO lbl151
                        column = 0;
                        ** GOTO lbl191
lbl151:
                        // 1 sources

                        if (!SimpleHtmlParser.equals("td", result)) ** GOTO lbl191
                        lastElementIsTD = true;
                        ** GOTO lbl191
                    }
                    case 3: {
                        hadPop = true;
                        ** GOTO lbl191
                    }
                    case 4: {
                        if (!lastElementIsTD || !hadPop || column <= 0) ** GOTO lbl191
                        ++column;
                        ** GOTO lbl191
                    }
                    case 5: {
                        switch (column) {
                            case 1: {
                                lastCode = result.toString();
                                break;
                            }
                            case 5: {
                                old = (String)toHierarchyTemp.get(lastCode);
                                toHierarchyTemp.put(lastCode, old == null || old.length() == 0 ? result.toString().trim() : old + " " + result.toString().trim());
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                break;
                            }
                            case 0: {
                                break;
                            }
                        }
                        ** GOTO lbl191
                    }
                    case 6: {
                        lastAttributeIsScope = SimpleHtmlParser.equals("scope", result);
                        ** GOTO lbl191
                    }
                    case 7: {
                        if (!lastAttributeIsScope || !SimpleHtmlParser.equals("row", result)) ** GOTO lbl191
                        column = 1;
                        ** GOTO lbl191
                    }
                    case 8: {
                        ** GOTO lbl191
                    }
                    case 9: {
                        break block28;
                    }
lbl191:
                    // 13 sources

                    default: {
                        continue block28;
                    }
                }
                break;
            }
            in.close();
            SPLIT_HIERARCHY = PatternCache.get("\\s*:\\s*");
            Iso639Data.toHierarchy = new TreeMap<String, List<String>>();
            for (String code : toHierarchyTemp.keySet()) {
                valueString = (String)toHierarchyTemp.get(code);
                for (String value : values = SPLIT_HIERARCHY.split(valueString)) {
                    if (Iso639Data.toScope.get(value) != null || toHierarchyTemp.get(value) != null) continue;
                    throw new IllegalArgumentException("Unexpected value in hierarchy:\t" + value + "\t" + code + "\t" + valueString);
                }
                Iso639Data.toHierarchy.put(code, Arrays.asList(values));
            }
            Iso639Data.toAlpha3 = Collections.unmodifiableMap(Iso639Data.toAlpha3);
            Iso639Data.fromAlpha3 = Collections.unmodifiableMap(Iso639Data.fromAlpha3);
            Iso639Data.toBiblio3 = Collections.unmodifiableMap(Iso639Data.toBiblio3);
            Iso639Data.fromBiblio3 = Collections.unmodifiableMap(Iso639Data.fromBiblio3);
            Iso639Data.toScope = Collections.unmodifiableMap(Iso639Data.toScope);
            Iso639Data.toType = Collections.unmodifiableMap(Iso639Data.toType);
            Iso639Data.toHierarchy = Collections.unmodifiableMap(Iso639Data.toHierarchy);
            Iso639Data.toNames.freeze();
            Iso639Data.toRetirements.freeze();
            Iso639Data.macro_encompassed.freeze();
            Iso639Data.toChangeTo = XCldrStub.ImmutableMap.copyOf(Iso639Data.toChangeTo);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Cannot parse file", e);
        }
    }

    public static <T> T findMatchToPrefix(String prefix, T[] values) {
        for (T x : values) {
            if (!x.toString().startsWith(prefix)) continue;
            return x;
        }
        throw new IllegalArgumentException("Prefix <" + prefix + "> not found in " + String.valueOf(Arrays.asList(values)));
    }

    public static Set<String> getAvailable() {
        if (toAlpha3 == null) {
            Iso639Data.getData();
        }
        return toNames.keySet();
    }

    public static String getMacroForEncompassed(String suffix) {
        String prefix = encompassed_macro.get(suffix);
        if (prefix != null) {
            return prefix;
        }
        if (suffix.equals("sgn")) {
            return null;
        }
        Set<String> names = toNames.getAll(suffix);
        if (names == null) {
            return null;
        }
        for (String name : names) {
            if (!name.contains("Sign Language")) continue;
            return "sgn";
        }
        return null;
    }

    public static Set<String> getEncompassedForMacro(String prefix) {
        return macro_encompassed.getAll(prefix);
    }

    public static Set<String> getMacros() {
        return macro_encompassed.keySet();
    }

    public static Set<String> getEncompassed() {
        return encompassed_macro.keySet();
    }

    public static String getChangeTo(String subtag) {
        return Iso639Data.getChangeToMap().get(subtag);
    }

    public static Map<String, String> getChangeToMap() {
        if (toChangeTo == null) {
            Iso639Data.getData();
        }
        return toChangeTo;
    }

    static enum IsoNamesColumn {
        Id,
        Print_Name,
        Inverted_Name;

    }

    static enum IsoColumn {
        Id,
        Part2B,
        Part2T,
        Part1,
        Scope,
        Type,
        Ref_Name;

    }

    public static enum Source {
        ISO_639_1,
        ISO_639_2,
        ISO_639_3,
        BCP47,
        CLDR;

    }

    public static enum Type {
        Ancient,
        Constructed,
        Extinct,
        Historical,
        Living,
        Special,
        Collection,
        Unknown;

    }

    public static enum Scope {
        Individual,
        Macrolanguage,
        Special,
        Collection,
        PrivateUse,
        Unknown;


        public static Scope fromString(String input) {
            input = input.replace("-", "");
            for (Scope item : Scope.values()) {
                if (!item.toString().equalsIgnoreCase(input)) continue;
                return item;
            }
            return Scope.valueOf(input);
        }
    }
}

