/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.SourceUriGenerator;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.Definition;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Include;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaWalker;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class NamespaceManager {
    private final Schema schema;
    private final Map<Name, NameInfo> elementNameMap = new HashMap<Name, NameInfo>();
    private final Map<Name, NameInfo> attributeNameMap = new HashMap<Name, NameInfo>();
    private final Map<Object, Name> substitutionGroupMap = new HashMap<Object, Name>();
    private final Map<String, Name> groupDefinitionAbstractElementMap = new HashMap<String, Name>();
    private final Map<Name, List<Name>> abstractElementSubstitutionGroupMemberMap = new HashMap<Name, List<Name>>();
    private final Map<String, SourceUri> sourceUriMap = new HashMap<String, SourceUri>();
    private final Map<String, TargetNamespace> targetNamespaceMap = new HashMap<String, TargetNamespace>();

    NamespaceManager(Schema schema, Guide guide, SourceUriGenerator sourceUriGenerator) {
        this.schema = schema;
        new IncludeFinder(schema);
        schema.accept(new RootMarker());
        this.assignTargetNamespaces();
        new GlobalElementSelector(schema);
        this.findSubstitutionGroups(guide);
        this.chooseRootSchemas(sourceUriGenerator);
        schema.accept(new StructureMover(this.getTargetNamespace(schema.getUri())));
    }

    private void assignTargetNamespaces() {
        new TargetNamespaceSelector(this.schema);
        String string = this.filterUpTargetNamespace(this.schema.getUri());
        if (string == null) {
            this.lookupTargetNamespace("");
            this.lookupSourceUri((String)this.schema.getUri()).targetNamespace = "";
            string = "";
        }
        this.inheritDownTargetNamespace(this.schema.getUri(), string);
    }

    private String filterUpTargetNamespace(String string) {
        String string2 = this.getTargetNamespace(string);
        if (string2 != null) {
            return string2;
        }
        List<String> list = this.lookupSourceUri((String)string).includes;
        if (list.size() == 0) {
            return null;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (String string3 : list) {
            String string4 = this.filterUpTargetNamespace(string3);
            if (string4 == null) continue;
            Integer object2 = (Integer)hashMap.get(string4);
            hashMap.put(string4, object2 == null ? 1 : object2 + 1);
        }
        Object object = null;
        boolean bl = false;
        for (Map.Entry entry : hashMap.entrySet()) {
            if (object == null || (Integer)entry.getValue() > (Integer)object.getValue()) {
                object = entry;
                bl = false;
                continue;
            }
            if (((Integer)entry.getValue()).intValue() != ((Integer)object.getValue()).intValue()) continue;
            bl = true;
        }
        if (object == null || bl) {
            return null;
        }
        this.lookupSourceUri((String)string).targetNamespace = string2 = (String)object.getKey();
        return string2;
    }

    private void inheritDownTargetNamespace(String string, String string2) {
        for (String string3 : this.lookupSourceUri((String)string).includes) {
            String string4 = this.lookupSourceUri((String)string3).targetNamespace;
            if (string4 == null) {
                this.lookupSourceUri((String)string3).targetNamespace = string4 = string2;
            }
            this.inheritDownTargetNamespace(string3, string4);
        }
    }

    private void chooseRootSchemas(SourceUriGenerator sourceUriGenerator) {
        for (Map.Entry<String, TargetNamespace> entry : this.targetNamespaceMap.entrySet()) {
            String string = entry.getKey();
            Vector<String> vector = new Vector<String>();
            this.findRootSchemas(this.schema.getUri(), string, vector);
            if (vector.size() == 1) {
                entry.getValue().rootSchema = (String)vector.get(0);
                continue;
            }
            String string2 = sourceUriGenerator.generateSourceUri(string);
            this.lookupSourceUri((String)string2).includes.addAll(vector);
            this.lookupSourceUri((String)string2).targetNamespace = string;
            entry.getValue().rootSchema = string2;
            this.schema.addInclude(string2, this.schema.getEncoding(), null, null);
        }
    }

    boolean isGlobal(Element element) {
        return element.equals(this.lookupElementName((Name)element.getName()).globalType);
    }

    Element getGlobalElement(Name name) {
        NameInfo nameInfo = this.elementNameMap.get(name);
        if (nameInfo == null) {
            return null;
        }
        return (Element)nameInfo.globalType;
    }

    boolean isGlobal(Attribute attribute) {
        return attribute.equals(this.lookupAttributeName((Name)attribute.getName()).globalType);
    }

    String getProxyName(Structure structure) {
        String string = structure.getName().getNamespaceUri();
        TargetNamespace targetNamespace = this.lookupTargetNamespace(string);
        String string2 = targetNamespace.movedStructureNameMap.get(structure);
        if (string2 == null) {
            string2 = this.generateName(string, targetNamespace, structure.getName().getLocalName(), structure instanceof Element);
            targetNamespace.movedStructureNameMap.put(structure, string2);
        }
        return string2;
    }

    String getOtherElementName(String string) {
        TargetNamespace targetNamespace = this.lookupTargetNamespace(string);
        if (!targetNamespace.movedOtherElement) {
            return null;
        }
        if (targetNamespace.otherElementName == null) {
            targetNamespace.otherElementName = this.generateName(string, targetNamespace, "local", true);
        }
        return targetNamespace.otherElementName;
    }

    String getOtherAttributeName(String string) {
        TargetNamespace targetNamespace = this.lookupTargetNamespace(string);
        if (!targetNamespace.movedOtherAttribute) {
            return null;
        }
        if (targetNamespace.otherAttributeName == null) {
            targetNamespace.otherAttributeName = this.generateName(string, targetNamespace, "local", false);
        }
        return targetNamespace.otherAttributeName;
    }

    private String generateName(String string, TargetNamespace targetNamespace, String string2, boolean bl) {
        Definition definition;
        Set<String> set = bl ? targetNamespace.movedElementNameSet : targetNamespace.movedAttributeNameSet;
        String string3 = string2;
        int n = 1;
        while (set.contains(string3) || (definition = bl ? this.schema.getGroup(string3) : this.schema.getAttributeGroup(string3)) != null && this.getTargetNamespace(definition.getParentSchema().getUri()).equals(string) && (!(definition instanceof GroupDefinition) || this.getElementNameForGroupRef((GroupDefinition)definition) == null)) {
            string3 = string2 + Integer.toString(n);
            ++n;
        }
        set.add(string3);
        return string3;
    }

    private void findSubstitutionGroups(Guide guide) {
        List<GroupDefinition> list = GroupDefinitionFinder.findGroupDefinitions(this.schema);
        HashMap<Name, String> hashMap = new HashMap<Name, String>();
        while (this.addAbstractElements(guide, list, hashMap)) {
        }
        this.cleanSubstitutionGroupMap(hashMap);
        this.cleanAbstractElementSubstitutionGroupMemberMap(hashMap);
    }

    private boolean addAbstractElements(Guide guide, List<GroupDefinition> list, Map<Name, String> map) {
        HashSet<Name> hashSet = new HashSet<Name>();
        for (GroupDefinition object : list) {
            List<Name> list2;
            Name name;
            if (!guide.getGroupEnableAbstractElement(object.getName()) || this.getGroupDefinitionAbstractElementName(object) != null || (name = this.abstractElementName(object)) == null || (list2 = this.substitutionGroupMembers(object)) == null) continue;
            map.put(name, object.getName());
            this.addSubstitutionGroup(name, list2, hashSet);
        }
        if (hashSet.size() == 0) {
            return false;
        }
        for (Name name : hashSet) {
            this.groupDefinitionAbstractElementMap.put(map.get(name), name);
        }
        return true;
    }

    private void addSubstitutionGroup(Name name, List<Name> list, Set<Name> set) {
        for (Name name2 : list) {
            Name name3 = this.getSubstitutionGroup(name2);
            if (name3 != null && !name3.equals(name)) {
                set.remove(name3);
                return;
            }
            this.substitutionGroupMap.put(name2, name);
        }
        set.add(name);
        this.abstractElementSubstitutionGroupMemberMap.put(name, list);
    }

    private void cleanSubstitutionGroupMap(Map<Name, String> map) {
        Iterator<Map.Entry<Object, Name>> iterator = this.substitutionGroupMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Name> entry = iterator.next();
            Name name = entry.getValue();
            if (this.groupDefinitionAbstractElementMap.get(map.get(name)) != null) continue;
            iterator.remove();
        }
    }

    private void cleanAbstractElementSubstitutionGroupMemberMap(Map<Name, String> map) {
        Iterator<Name> iterator = this.abstractElementSubstitutionGroupMemberMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (this.groupDefinitionAbstractElementMap.get(map.get(iterator.next())) != null) continue;
            iterator.remove();
        }
    }

    private Name abstractElementName(GroupDefinition groupDefinition) {
        Name name = new Name(this.getTargetNamespace(groupDefinition.getParentSchema().getUri()), groupDefinition.getName());
        if (this.lookupElementName((Name)name).globalType != null) {
            return null;
        }
        return name;
    }

    private List<Name> substitutionGroupMembers(GroupDefinition groupDefinition) {
        if (groupDefinition.getParticle() instanceof Element) {
            return null;
        }
        Vector<Name> vector = new Vector<Name>();
        if (!this.particleMembers(groupDefinition.getParticle(), vector)) {
            return null;
        }
        return vector;
    }

    private boolean particleMembers(Particle particle, List<Name> list) {
        if (particle instanceof Element) {
            Element element = (Element)particle;
            if (!this.isGlobal(element)) {
                return false;
            }
            list.add(element.getName());
        } else if (particle instanceof GroupRef) {
            Name name = this.getElementNameForGroupRef(this.schema.getGroup(((GroupRef)particle).getName()));
            if (name == null) {
                return false;
            }
            list.add(name);
        } else if (particle instanceof ParticleChoice) {
            for (Particle particle2 : ((ParticleChoice)particle).getChildren()) {
                if (this.particleMembers(particle2, list)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    Name getElementNameForGroupRef(GroupDefinition groupDefinition) {
        Name name = this.getGroupDefinitionAbstractElementName(groupDefinition);
        if (name != null) {
            return name;
        }
        return this.getGroupDefinitionSingleElementName(groupDefinition);
    }

    boolean isGroupDefinitionOmitted(GroupDefinition groupDefinition) {
        return this.getGroupDefinitionSingleElementName(groupDefinition) != null;
    }

    Name getGroupDefinitionAbstractElementName(GroupDefinition groupDefinition) {
        return this.groupDefinitionAbstractElementMap.get(groupDefinition.getName());
    }

    List<Name> getAbstractElementSubstitutionGroupMembers(Name name) {
        return this.abstractElementSubstitutionGroupMemberMap.get(name);
    }

    private Name getGroupDefinitionSingleElementName(GroupDefinition groupDefinition) {
        Particle particle = groupDefinition.getParticle();
        if (!(particle instanceof Element) || !this.isGlobal((Element)particle)) {
            return null;
        }
        return ((Element)particle).getName();
    }

    Name getSubstitutionGroup(Name name) {
        return this.substitutionGroupMap.get(name);
    }

    String getTargetNamespace(String string) {
        return this.lookupSourceUri((String)string).targetNamespace;
    }

    boolean isTargetNamespace(String string) {
        return this.targetNamespaceMap.get(string) != null;
    }

    Set<String> getTargetNamespaces() {
        return this.targetNamespaceMap.keySet();
    }

    String getRootSchema(String string) {
        return this.lookupTargetNamespace((String)string).rootSchema;
    }

    List<Structure> getMovedStructures(String string) {
        return this.lookupTargetNamespace((String)string).movedStructures;
    }

    List<String> effectiveIncludes(String string) {
        String string2 = this.getTargetNamespace(string);
        Vector<String> vector = new Vector<String>();
        for (String string3 : this.lookupSourceUri((String)string).includes) {
            this.findRootSchemas(string3, string2, vector);
        }
        return vector;
    }

    private void findRootSchemas(String string, String string2, List<String> list) {
        if (this.getTargetNamespace(string).equals(string2)) {
            list.add(string);
        } else {
            for (String string3 : this.lookupSourceUri((String)string).includes) {
                this.findRootSchemas(string3, string2, list);
            }
        }
    }

    private SourceUri lookupSourceUri(String string) {
        SourceUri sourceUri = this.sourceUriMap.get(string);
        if (sourceUri == null) {
            sourceUri = new SourceUri();
            this.sourceUriMap.put(string, sourceUri);
        }
        return sourceUri;
    }

    private TargetNamespace lookupTargetNamespace(String string) {
        TargetNamespace targetNamespace = this.targetNamespaceMap.get(string);
        if (targetNamespace == null) {
            targetNamespace = new TargetNamespace();
            this.targetNamespaceMap.put(string, targetNamespace);
        }
        return targetNamespace;
    }

    private NameInfo lookupElementName(Name name) {
        NameInfo nameInfo = this.elementNameMap.get(name);
        if (nameInfo == null) {
            nameInfo = new NameInfo();
            this.elementNameMap.put(name, nameInfo);
        }
        return nameInfo;
    }

    private NameInfo lookupAttributeName(Name name) {
        NameInfo nameInfo = this.attributeNameMap.get(name);
        if (nameInfo == null) {
            nameInfo = new NameInfo();
            this.attributeNameMap.put(name, nameInfo);
        }
        return nameInfo;
    }

    static String otherNamespace(Wildcard wildcard) {
        if (wildcard.isPositive()) {
            return null;
        }
        Set<String> set = wildcard.getNamespaces();
        switch (set.size()) {
            case 2: {
                if (!set.contains("")) {
                    return null;
                }
                Iterator<String> iterator = set.iterator();
                String string = iterator.next();
                if (!string.equals("")) {
                    return string;
                }
                return iterator.next();
            }
            case 1: {
                if (!set.contains("")) break;
                return "";
            }
        }
        return null;
    }

    static class GroupDefinitionFinder
    extends SchemaWalker {
        final List<GroupDefinition> list = new Vector<GroupDefinition>();

        GroupDefinitionFinder() {
        }

        @Override
        public void visitGroup(GroupDefinition groupDefinition) {
            this.list.add(groupDefinition);
        }

        static List<GroupDefinition> findGroupDefinitions(Schema schema) {
            GroupDefinitionFinder groupDefinitionFinder = new GroupDefinitionFinder();
            schema.accept(groupDefinitionFinder);
            return groupDefinitionFinder.list;
        }
    }

    class StructureMover
    extends SchemaWalker {
        private final String currentNamespace;

        StructureMover(String string) {
            this.currentNamespace = string;
        }

        @Override
        public VoidValue visitElement(Element element) {
            NameInfo nameInfo = NamespaceManager.this.lookupElementName(element.getName());
            String string = element.getName().getNamespaceUri();
            if (string.equals(this.currentNamespace) || string.equals("") && !element.equals(nameInfo.globalType)) {
                element.getComplexType().accept(this);
            } else {
                this.noteMoved(nameInfo, element);
                this.moveStructure(element);
                element.getComplexType().accept(new StructureMover(string));
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitAttribute(Attribute attribute) {
            String string = attribute.getName().getNamespaceUri();
            if (!string.equals("") && !string.equals(this.currentNamespace)) {
                this.noteMoved(NamespaceManager.this.lookupAttributeName(attribute.getName()), attribute);
                this.moveStructure(attribute);
            }
            return VoidValue.VOID;
        }

        private void noteMoved(NameInfo nameInfo, Structure structure) {
            if (nameInfo.occur < 3) {
                nameInfo.occur = 3;
                nameInfo.globalType = structure;
            } else if (nameInfo.occur == 3 && !structure.equals(nameInfo.globalType)) {
                nameInfo.globalType = null;
            }
        }

        private void moveStructure(Structure structure) {
            TargetNamespace targetNamespace = NamespaceManager.this.lookupTargetNamespace(structure.getName().getNamespaceUri());
            if (!targetNamespace.movedStructureSet.contains(structure)) {
                targetNamespace.movedStructureSet.add(structure);
                targetNamespace.movedStructures.add(structure);
            }
        }

        @Override
        public void visitInclude(Include include) {
            Schema schema = include.getIncludedSchema();
            schema.accept(new StructureMover(NamespaceManager.this.getTargetNamespace(schema.getUri())));
        }

        @Override
        public VoidValue visitWildcardElement(WildcardElement wildcardElement) {
            return this.visitWildcard(wildcardElement.getWildcard(), true);
        }

        @Override
        public VoidValue visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return this.visitWildcard(wildcardAttribute.getWildcard(), false);
        }

        private VoidValue visitWildcard(Wildcard wildcard, boolean bl) {
            String string = NamespaceManager.otherNamespace(wildcard);
            if (string != null && !string.equals(this.currentNamespace)) {
                TargetNamespace targetNamespace = NamespaceManager.this.lookupTargetNamespace(string);
                if (bl) {
                    targetNamespace.movedOtherElement = true;
                } else {
                    targetNamespace.movedOtherAttribute = true;
                }
            }
            return VoidValue.VOID;
        }
    }

    class GlobalElementSelector
    extends SchemaWalker {
        private final boolean absentTargetNamespace;
        private boolean nested = false;

        GlobalElementSelector(Schema schema) {
            this.absentTargetNamespace = NamespaceManager.this.getTargetNamespace(schema.getUri()).equals("");
            schema.accept(this);
        }

        @Override
        public VoidValue visitElement(Element element) {
            Name name = element.getName();
            if (!name.getNamespaceUri().equals("") || this.absentTargetNamespace) {
                int n;
                NameInfo nameInfo = NamespaceManager.this.lookupElementName(name);
                int n2 = n = this.nested ? 1 : 2;
                if (n > nameInfo.occur) {
                    nameInfo.occur = n;
                    nameInfo.globalType = element;
                } else if (n == nameInfo.occur && !element.equals(nameInfo.globalType)) {
                    nameInfo.globalType = null;
                }
            }
            boolean bl = this.nested;
            this.nested = true;
            element.getComplexType().accept(this);
            this.nested = bl;
            return VoidValue.VOID;
        }

        @Override
        public void visitInclude(Include include) {
            new GlobalElementSelector(include.getIncludedSchema());
        }
    }

    class TargetNamespaceSelector
    extends SchemaWalker {
        private boolean nested;
        private final Map<String, NamespaceUsage> namespaceUsageMap = new HashMap<String, NamespaceUsage>();

        TargetNamespaceSelector(Schema schema) {
            schema.accept(this);
            ((NamespaceManager)NamespaceManager.this).lookupSourceUri((String)schema.getUri()).targetNamespace = this.selectTargetNamespace();
        }

        @Override
        public VoidValue visitElement(Element element) {
            NamespaceUsage namespaceUsage = this.getUsage(element.getName().getNamespaceUri());
            if (!this.nested) {
                ++namespaceUsage.elementCount;
            }
            boolean bl = this.nested;
            this.nested = true;
            element.getComplexType().accept(this);
            this.nested = bl;
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitAttribute(Attribute attribute) {
            NamespaceUsage namespaceUsage = this.getUsage(attribute.getName().getNamespaceUri());
            if (!this.nested) {
                ++namespaceUsage.attributeCount;
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitWildcardElement(WildcardElement wildcardElement) {
            return this.visitWildcard(wildcardElement.getWildcard());
        }

        @Override
        public VoidValue visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return this.visitWildcard(wildcardAttribute.getWildcard());
        }

        private VoidValue visitWildcard(Wildcard wildcard) {
            String string = NamespaceManager.otherNamespace(wildcard);
            if (string != null) {
                NamespaceManager.this.lookupTargetNamespace(string);
                if (!this.nested) {
                    ++this.getUsage((String)string).attributeCount;
                }
            }
            return VoidValue.VOID;
        }

        private NamespaceUsage getUsage(String string) {
            NamespaceUsage namespaceUsage = this.namespaceUsageMap.get(string);
            if (namespaceUsage == null) {
                namespaceUsage = new NamespaceUsage();
                this.namespaceUsageMap.put(string, namespaceUsage);
                if (!string.equals("")) {
                    NamespaceManager.this.lookupTargetNamespace(string);
                }
            }
            return namespaceUsage;
        }

        @Override
        public void visitInclude(Include include) {
            new TargetNamespaceSelector(include.getIncludedSchema());
        }

        String selectTargetNamespace() {
            Map.Entry<String, NamespaceUsage> entry = null;
            for (Map.Entry<String, NamespaceUsage> entry2 : this.namespaceUsageMap.entrySet()) {
                if (entry != null && !NamespaceUsage.isBetter(entry2.getValue(), entry.getValue()) && (!entry2.getValue().equals(entry.getValue()) || entry2.getKey().compareTo(entry.getKey()) >= 0)) continue;
                entry = entry2;
            }
            this.namespaceUsageMap.clear();
            if (entry == null) {
                return null;
            }
            String string = (String)entry.getKey();
            NamespaceManager.this.lookupTargetNamespace(string);
            return string;
        }
    }

    static class NamespaceUsage {
        int elementCount;
        int attributeCount;

        NamespaceUsage() {
        }

        static boolean isBetter(NamespaceUsage namespaceUsage, NamespaceUsage namespaceUsage2) {
            return namespaceUsage.elementCount > namespaceUsage2.elementCount || namespaceUsage.elementCount == namespaceUsage2.elementCount && namespaceUsage.attributeCount > namespaceUsage2.attributeCount;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NamespaceUsage)) {
                return false;
            }
            NamespaceUsage namespaceUsage = (NamespaceUsage)object;
            return this.elementCount == namespaceUsage.elementCount && this.attributeCount == namespaceUsage.attributeCount;
        }
    }

    class RootMarker
    extends SchemaWalker {
        RootMarker() {
        }

        @Override
        public void visitGroup(GroupDefinition groupDefinition) {
        }

        @Override
        public VoidValue visitElement(Element element) {
            NameInfo nameInfo = NamespaceManager.this.lookupElementName(element.getName());
            nameInfo.globalType = element;
            nameInfo.occur = 4;
            NamespaceManager.this.lookupTargetNamespace(element.getName().getNamespaceUri());
            return VoidValue.VOID;
        }
    }

    class IncludeFinder
    extends SchemaWalker {
        private final SourceUri source;

        IncludeFinder(Schema schema) {
            this.source = NamespaceManager.this.lookupSourceUri(schema.getUri());
            schema.accept(this);
        }

        @Override
        public void visitInclude(Include include) {
            Schema schema = include.getIncludedSchema();
            this.source.includes.add(schema.getUri());
            new IncludeFinder(schema);
        }
    }

    static class NameInfo {
        static final int OCCUR_NONE = 0;
        static final int OCCUR_NESTED = 1;
        static final int OCCUR_TOP = 2;
        static final int OCCUR_MOVE = 3;
        static final int OCCUR_ROOT = 4;
        int occur = 0;
        Structure globalType = null;

        NameInfo() {
        }
    }

    static class TargetNamespace {
        String rootSchema;
        final List<Structure> movedStructures = new Vector<Structure>();
        final Set<Structure> movedStructureSet = new HashSet<Structure>();
        final Map<Structure, String> movedStructureNameMap = new HashMap<Structure, String>();
        final Set<String> movedElementNameSet = new HashSet<String>();
        final Set<String> movedAttributeNameSet = new HashSet<String>();
        boolean movedOtherElement = false;
        boolean movedOtherAttribute = false;
        String otherElementName;
        String otherAttributeName;

        TargetNamespace() {
        }
    }

    static class SourceUri {
        String targetNamespace;
        final List<String> includes = new Vector<String>();

        SourceUri() {
        }
    }
}

