/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.DateTimePatternGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckDates;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DateTimeCanonicalizer;
import org.unicode.cldr.util.PatternCache;

public class DateOrder
implements Comparable<DateOrder> {
    private int etype1;
    private int etype2;

    public DateOrder(int a, int b) {
        this.etype1 = a;
        this.etype2 = b;
    }

    public boolean equals(Object obj) {
        DateOrder that = (DateOrder)obj;
        return that.etype1 == this.etype1 && that.etype2 == this.etype2;
    }

    public int hashCode() {
        return this.etype1 * 37 + this.etype2;
    }

    public String toString() {
        return "<" + this.toString2(this.etype1) + "," + this.toString2(this.etype2) + ">";
    }

    private String toString2(int etype) {
        int cfr_ignored_0 = etype >> 1;
        return DateTimePatternGenerator.VariableField.getCanonicalCode(etype >> 1) + ((etype & 1) == 0 ? "\u0086\u0086\u0086" : "\u207f");
    }

    @Override
    public int compareTo(DateOrder that) {
        int diff = this.etype1 - that.etype1;
        if (0 != diff) {
            return diff;
        }
        return this.etype2 - that.etype2;
    }

    public static Map<String, Map<DateOrder, String>> getOrderingInfo(CLDRFile plain, CLDRFile resolved, DateTimePatternGenerator.FormatParser fp) {
        HashMap<String, Map<DateOrder, String>> pathsWithConflictingOrder2sample = new HashMap<String, Map<DateOrder, String>>();
        CLDRFile.Status status = new CLDRFile.Status();
        HashMap type2order2set = new HashMap();
        Matcher typeMatcher = PatternCache.get("\\[@type=\"([^\"]*)\"]").matcher("");
        int[] soFar = new int[50];
        int lenSoFar = 0;
        for (String string : resolved) {
            if (!DateTimeCanonicalizer.DateTimePatternType.STOCK_AVAILABLE_INTERVAL_PATTERNS.contains((Object)DateTimeCanonicalizer.DateTimePatternType.fromPath(string)) || string.contains("[@id=\"Ed\"]") || !string.equals(status.pathWhereFound)) continue;
            typeMatcher.reset(string).find();
            String type = typeMatcher.group(1);
            HashMap<DateOrder, HashSet<String>> pairCount = (HashMap<DateOrder, HashSet<String>>)type2order2set.get(type);
            if (pairCount == null) {
                pairCount = new HashMap<DateOrder, HashSet<String>>();
                type2order2set.put(type, pairCount);
            }
            boolean isInterval = string.contains("intervalFormatItem");
            lenSoFar = 0;
            String value = resolved.getStringValue(string);
            for (Object item : fp.set(value).getItems()) {
                if (!(item instanceof DateTimePatternGenerator.VariableField)) continue;
                DateTimePatternGenerator.VariableField variable = (DateTimePatternGenerator.VariableField)item;
                int eType = variable.getType() * 2 + (variable.isNumeric() ? 1 : 0);
                if (isInterval && DateOrder.find(eType, soFar, lenSoFar)) {
                    lenSoFar = 0;
                    soFar[lenSoFar++] = eType;
                    continue;
                }
                for (int i = 0; i < lenSoFar; ++i) {
                    DateOrder order = new DateOrder(soFar[i], eType);
                    HashSet<String> paths = (HashSet<String>)pairCount.get(order);
                    if (paths == null) {
                        paths = new HashSet<String>();
                        pairCount.put(order, paths);
                    }
                    paths.add(string);
                }
                soFar[lenSoFar++] = eType;
            }
        }
        for (Map.Entry entry : type2order2set.entrySet()) {
            Map pairCount = (Map)entry.getValue();
            HashSet<DateOrder> alreadySeen = new HashSet<DateOrder>();
            for (Map.Entry entry2 : pairCount.entrySet()) {
                DateOrder thisOrder = (DateOrder)entry2.getKey();
                if (alreadySeen.contains(thisOrder)) continue;
                DateOrder reverseOrder = new DateOrder(thisOrder.etype2, thisOrder.etype1);
                Set reverseSet = (Set)pairCount.get(reverseOrder);
                DateOrder sample = thisOrder.compareTo(reverseOrder) < 0 ? thisOrder : reverseOrder;
                Set thisPaths = (Set)entry2.getValue();
                if (reverseSet == null) continue;
                DateOrder.addConflictingPaths(plain, sample, reverseSet, thisPaths, pathsWithConflictingOrder2sample);
                DateOrder.addConflictingPaths(plain, sample, thisPaths, reverseSet, pathsWithConflictingOrder2sample);
                alreadySeen.add(reverseOrder);
            }
        }
        if (CheckDates.GREGORIAN_ONLY) {
            for (Map.Entry entry : pathsWithConflictingOrder2sample.entrySet()) {
                String path1 = (String)entry.getKey();
                String locale1 = resolved.getSourceLocaleID(path1, status);
                String value1 = resolved.getStringValue(path1);
                Map orderString = (Map)entry.getValue();
                for (Map.Entry entry2 : orderString.entrySet()) {
                    DateOrder order2 = (DateOrder)entry2.getKey();
                    String path2 = (String)entry2.getValue();
                    String locale2 = resolved.getSourceLocaleID(path2, status);
                    String value2 = resolved.getStringValue(path2);
                    System.out.println(String.valueOf(order2) + "\t" + value1 + "\t" + value2 + "\t" + locale1 + "\t" + locale2 + "\t" + path1 + "\t" + path2);
                }
            }
        }
        return pathsWithConflictingOrder2sample;
    }

    private static void addConflictingPaths(CLDRFile cldrFile, DateOrder order, Set<String> paths, Set<String> conflictingPaths, Map<String, Map<DateOrder, String>> pathsWithConflictingOrder2sample) {
        block0: for (String first : paths) {
            FormatType firstType = FormatType.getType(first);
            for (String otherPath : conflictingPaths) {
                FormatType otherType = FormatType.getType(otherPath);
                if (otherType.isLessImportantThan(firstType)) continue;
                DateOrder.addItem(cldrFile, first, order, otherPath, pathsWithConflictingOrder2sample);
                continue block0;
            }
        }
    }

    private static boolean find(int eType, int[] soFar, int lenSoFar) {
        for (int i = 0; i < lenSoFar; ++i) {
            if (eType != soFar[i]) continue;
            return true;
        }
        return false;
    }

    private static void addItem(CLDRFile plain, String path, DateOrder sample, String conflictingPath, Map<String, Map<DateOrder, String>> pathsWithConflictingOrder2sample) {
        String value = plain.getStringValue(path);
        if (value == null) {
            return;
        }
        Map<DateOrder, String> order2path = pathsWithConflictingOrder2sample.get(path);
        if (order2path == null) {
            order2path = new TreeMap<DateOrder, String>();
            pathsWithConflictingOrder2sample.put(path, order2path);
        }
        order2path.put(sample, conflictingPath);
    }

    private static enum FormatType {
        DATE(3),
        TIME(3),
        AVAILABLE(2),
        INTERVAL(1);

        private static final Pattern DATETIME_PATTERN;
        private int importance;

        private FormatType(int importance) {
            this.importance = importance;
        }

        public static FormatType getType(String path) {
            Matcher matcher = DATETIME_PATTERN.matcher(path);
            if (matcher.find()) {
                return FormatType.valueOf(matcher.group(1).toUpperCase());
            }
            throw new IllegalArgumentException("Path is not a datetime format type: " + path);
        }

        public boolean isLessImportantThan(FormatType otherType) {
            return otherType.importance - this.importance > 0;
        }

        static {
            DATETIME_PATTERN = PatternCache.get("/(date|time|available|interval)Formats");
        }
    }
}

