/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class GenerateEnglishChanged {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final File TRUNK_DIRECTORY = new File(CLDRPaths.BASE_DIRECTORY);
    private static final File RELEASE_DIRECTORY = new File(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + ToolConstants.LAST_RELEASE_VERSION + "/");
    private static final boolean TRIAL = false;
    static Matcher partToRemove = Pattern.compile("(\\[@type=\"tts\"]|/listPatternPart\\[@type=\"[^\"]*\"]|/displayName|/unitPattern\\[@count=\"[^\"]*\"])$").matcher("");

    public static void main(String[] args) {
        String[] base = new String[]{"common"};
        File[] addStandardSubdirectories = CLDR_CONFIG.addStandardSubdirectories(CLDRConfig.fileArrayFromStringArray(TRUNK_DIRECTORY, base));
        Factory factoryTrunk = SimpleFactory.make(addStandardSubdirectories, ".*");
        CLDRFile englishTrunk = factoryTrunk.make("en", true);
        addStandardSubdirectories = CLDR_CONFIG.addStandardSubdirectories(CLDRConfig.fileArrayFromStringArray(RELEASE_DIRECTORY, base));
        Factory factoryLastRelease = SimpleFactory.make(addStandardSubdirectories, ".*");
        CLDRFile englishLastRelease = factoryLastRelease.make("en", true);
        TreeSet paths = new TreeSet();
        With.in(new Iterable[]{englishTrunk}).toCollection(paths);
        With.in(new Iterable[]{englishLastRelease}).toCollection(paths);
        String placeholder = "\u00d7";
        LinkedHashSet<String> abbreviatedPaths = new LinkedHashSet<String>();
        LinkedHashMultimap<String, ImmutableList<String>> pathsDiffer = LinkedHashMultimap.create();
        for (String path : paths) {
            String abbrPath;
            String valueLastRelease;
            String valueTrunk = englishTrunk.getStringValue(path);
            if (valueTrunk == null || (valueLastRelease = englishLastRelease.getStringValue(path)) == null || valueTrunk.equals(valueLastRelease) || pathsDiffer.containsKey(abbrPath = GenerateEnglishChanged.abbreviatePath(path))) continue;
            abbreviatedPaths.add(abbrPath);
            String starred = PathStarrer.getWithPattern(abbrPath, "\u00d7");
            pathsDiffer.put(starred, ImmutableList.copyOf(XPathParts.getFrozenInstance(abbrPath).getAttributeValues()));
        }
        int errorCount = 0;
        for (String path : abbreviatedPaths) {
            if (SubmissionLocales.pathAllowedInLimitedSubmission(path)) continue;
            System.out.println("Failed to match: " + path);
            ++errorCount;
        }
        System.out.println("Errors: " + errorCount);
    }

    private static String abbreviatePath(String path) {
        return partToRemove.reset(path).replaceAll("");
    }
}

