/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.XMLValidator;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KeyboardFlatten {
    public static void flatten(String path, OutputStream stream) throws MalformedURLException, SAXException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        String filename = PathUtilities.getNormalizedPathString(path, new String[0]);
        String docURI = XMLValidator.filenameToURL(filename);
        KeyboardFlatten.flatten(new InputSource(docURI), filename, stream);
    }

    public static void flatten(InputSource inputSource, String filename, OutputStream stream) throws SAXException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError, MalformedURLException {
        DocumentBuilderFactory dfactory = KeyboardFlatten.getKeyboardDocFactory();
        ErrorHandler nullHandler = KeyboardFlatten.getNullHandler(filename);
        Document doc = KeyboardFlatten.parseDocument(inputSource, filename, dfactory, nullHandler);
        KeyboardFlatten.flattenDoc(dfactory, doc);
        KeyboardFlatten.write(doc, stream);
    }

    private static void flattenDoc(DocumentBuilderFactory dfactory, Document doc) throws MalformedURLException {
        NodeList imports = doc.getElementsByTagName("import");
        if (imports.getLength() == 0) {
            System.err.println("No imports");
        } else {
            for (int i = 0; i < imports.getLength(); ++i) {
                Node item = imports.item(i);
                KeyboardFlatten.flattenImport(dfactory, doc, item);
            }
            while (imports.getLength() > 0) {
                Node item = imports.item(0);
                item.getParentNode().removeChild(item);
            }
        }
    }

    private static void flattenImport(DocumentBuilderFactory dfactory, Document doc, Node item) throws MalformedURLException {
        String base = KeyboardFlatten.getBase(item);
        String path = KeyboardFlatten.getPath(item);
        System.err.println("Import: " + base + ":" + path);
        if (base.equals("cldr")) {
            if (!path.startsWith("45/")) {
                throw new IllegalArgumentException("Unknown cldr base: " + path);
            }
        } else {
            throw new IllegalArgumentException("Unknown base: " + base);
        }
        String subpath = path.replaceFirst("45/", "");
        File importDir = new File(CLDRConfig.getInstance().getCldrBaseDirectory(), "keyboards/import");
        File importFile = new File(importDir, subpath);
        KeyboardFlatten.applyImportFile(dfactory, doc, item, path, importFile);
    }

    private static void applyImportFile(DocumentBuilderFactory dfactory, Document doc, Node item, String path, File importFile) throws MalformedURLException {
        if (!importFile.exists()) {
            throw new IllegalArgumentException("File " + String.valueOf(importFile) + " does not exist");
        }
        System.err.println("Importing: " + importFile.getAbsolutePath());
        String ifilename = PathUtilities.getNormalizedPathString(importFile.getAbsolutePath(), new String[0]);
        String docURI = XMLValidator.filenameToURL(ifilename);
        Document importDoc = KeyboardFlatten.parseDocument(new InputSource(docURI), ifilename, dfactory, KeyboardFlatten.getNullHandler(ifilename));
        System.err.println("Parsed import OK");
        Element importedRoot = importDoc.getDocumentElement();
        Node importParentNode = item.getParentNode();
        if (importParentNode.getNodeType() != 1) {
            throw new IllegalArgumentException("import parent is not an element");
        }
        Element importParent = (Element)importParentNode;
        if (!importParent.getTagName().equals(importedRoot.getTagName())) {
            throw new IllegalArgumentException("trying to import " + importedRoot.getTagName() + " root into child of " + importParent.getTagName());
        }
        System.err.println("Importing into " + importParent.getTagName());
        Comment preComment = doc.createComment("Begin Imports from " + path);
        Comment postComment = doc.createComment("End Imports from " + path);
        NodeList moveChildren = importedRoot.getChildNodes();
        importParent.insertBefore(preComment, item);
        for (int j = 0; j < moveChildren.getLength(); ++j) {
            Node child = moveChildren.item(j);
            Node clone = doc.importNode(child, true);
            importParent.insertBefore(clone, item);
        }
        System.err.println("Moved " + moveChildren.getLength() + " children");
        importParent.insertBefore(postComment, item);
    }

    private static ErrorHandler getNullHandler(final String filename2) {
        ErrorHandler nullHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                System.err.println(filename2 + ": Warning: " + e.getMessage());
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                int col = e.getColumnNumber();
                System.err.println(filename2 + ":" + e.getLineNumber() + (String)(col >= 0 ? ":" + col : "") + ": ERROR: Element " + e.getPublicId() + " is not valid because " + e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println(filename2 + ": ERROR ");
                throw e;
            }
        };
        return nullHandler;
    }

    private static DocumentBuilderFactory getKeyboardDocFactory() throws SAXException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(true);
        SchemaFactory sfac = SchemaFactory.newDefaultInstance();
        Schema schema = sfac.newSchema(new File(CLDRConfig.getInstance().getCldrBaseDirectory(), DtdType.keyboard3.getXsdPath()));
        dfactory.setSchema(schema);
        return dfactory;
    }

    private static String getBase(Node item) {
        String attrName = "base";
        return KeyboardFlatten.getAttributeValue(item, "base");
    }

    private static String getPath(Node item) {
        String attrName = "path";
        return KeyboardFlatten.getAttributeValue(item, "path");
    }

    private static String getAttributeValue(Node item, String attrName) {
        return item.getAttributes().getNamedItem(attrName).getTextContent();
    }

    private static Document parseDocument(InputSource inputSource, String filename, DocumentBuilderFactory dfactory, ErrorHandler nullHandler) {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            docBuilder.setErrorHandler(nullHandler);
            doc = docBuilder.parse(inputSource);
        }
        catch (Throwable se) {
            if (se instanceof SAXParseException) {
                SAXParseException pe = (SAXParseException)se;
                int col = pe.getColumnNumber();
                System.err.println(filename + ":" + pe.getLineNumber() + (String)(col >= 0 ? ":" + col : "") + ": ERROR:" + se.toString());
            }
            System.err.println(filename + ": ERROR:" + se.toString());
        }
        System.err.println("Doc parse OK");
        return doc;
    }

    private static void write(Document doc, OutputStream stream) throws TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(stream));
    }
}

