/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;

public class ListSurveyToolStatus {
    public static void main(String[] args) {
        MyOptions.parse(args);
        Matcher locales = Pattern.compile(MyOptions.locale.option.getValue()).matcher("");
        Matcher paths = Pattern.compile(MyOptions.paths.option.getValue()).matcher("");
        Factory factory = CLDRConfig.getInstance().getCldrFactory();
        CLDRFile.Status status = new CLDRFile.Status();
        for (String locale : factory.getAvailable()) {
            if (!locales.reset(locale).find()) continue;
            CLDRFile cldrFile = factory.make(locale, true);
            String testValue = cldrFile.getStringValue("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"duration-day-person\"]/displayName");
            TreeSet<PathHeader> sorted = new TreeSet<PathHeader>();
            for (String path : cldrFile.fullIterable()) {
                sorted.add(PathHeader.getFactory().fromPath(path));
            }
            for (PathHeader pathHeader : sorted) {
                String path = pathHeader.getOriginalPath();
                if (!paths.reset(path).find()) continue;
                String value = cldrFile.getStringValue(path);
                String localeFound = cldrFile.getSourceLocaleID(path, status);
                System.out.println(locale + (String)(locale.equals(localeFound) ? "" : "/" + localeFound) + "\t" + String.valueOf(pathHeader) + "\n\tvalue:\t" + value + "\n\tpath:\t" + path + (String)(path.equals(status.pathWhereFound) ? "" : "\n\toPath:\t" + status.pathWhereFound) + "\n");
            }
        }
        System.out.println("DONE");
    }

    private static enum MyOptions {
        locale(new Option.Params().setHelp("Regex for locales").setMatch(".*").setDefault("^root$")),
        paths(new Option.Params().setHelp("Regex for paths").setMatch(".+").setDefault("/unit.*day")),
        verbose(new Option.Params().setHelp("verbose debugging messages"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

