/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class UnLiteracyParser
extends XMLFileReader.SimpleHandler {
    private static final String VALUE = "Value";
    private static final String RELIABILITY = "Reliability";
    private static final String LITERACY = "Literacy";
    private static final String YEAR = "Year";
    private static final String COUNTRY_OR_AREA = "Country or Area";
    private static final String AGE = "Age";
    static final String LITERATE = "Literate";
    static final String ILLITERATE = "Illiterate";
    private static final String UNKNOWN = "Unknown";
    private static final String TOTAL = "Total";
    int recCount = 0;
    public static final String UN_LITERACY = "external/un_literacy.xml";
    final Map<String, String> thisRecord = new HashMap<String, String>();
    final Map<String, PerCountry> perCountry = new TreeMap<String, PerCountry>();

    public static void main(String[] args) {
        UnLiteracyParser ulp = new UnLiteracyParser().read();
        for (Map.Entry<String, PerCountry> e : ulp.perCountry.entrySet()) {
            String country = e.getKey();
            String latest = e.getValue().latest();
            PerYear py = e.getValue().perYear.get(latest);
            Long literate = py.total(LITERATE);
            Long illiterate = py.total(ILLITERATE);
            Long unknown = py.total(UNKNOWN);
            Long total = py.total(TOTAL);
            System.out.println(country + "\t" + latest + "\t" + literate + "/" + illiterate + ", " + unknown + " = " + total);
            if (literate + illiterate + unknown == total) continue;
            System.out.println("- doesn't add up for " + country + " - total is " + (literate + illiterate + unknown));
        }
    }

    UnLiteracyParser read() {
        System.out.println("* Reading external/un_literacy.xml");
        new XMLFileReader().setHandler(this).readCLDRResource(UN_LITERACY, XMLFileReader.CONTENT_HANDLER, false);
        this.handleNewRecord();
        LocalizedNumberFormatter nf = NumberFormatter.with().locale(Locale.ENGLISH);
        System.out.println("* Read " + String.valueOf(nf.format(this.recCount)) + " record(s) with " + String.valueOf(nf.format(this.perCountry.size())) + " region(s) from external/un_literacy.xml");
        return this;
    }

    @Override
    public void handlePathValue(String path, String value) {
        if (!path.startsWith("//ROOT/data/record")) {
            return;
        }
        String field = XPathParts.getFrozenInstance(path).getAttributeValue(-1, "name");
        this.handleField(field, value);
    }

    @Override
    public void handleElement(CharSequence path) {
        if ("//ROOT/data/record".equals(path.toString())) {
            this.handleNewRecord();
        }
    }

    private void handleField(String field, String value) {
        String old = this.thisRecord.put(field, value);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate field " + field + ", context: " + String.valueOf(this.thisRecord));
        }
    }

    private void handleNewRecord() {
        if (!this.thisRecord.isEmpty() && this.validate()) {
            ++this.recCount;
            this.handleRecord();
        }
        this.thisRecord.clear();
    }

    boolean validate() {
        try {
            this.assertEqual("Area", TOTAL);
            this.assertEqual("Sex", "Both Sexes");
            this.assertPresent(AGE);
            this.assertPresent(COUNTRY_OR_AREA);
            this.assertPresent(LITERACY);
            this.assertPresent(VALUE);
            this.assertPresent(YEAR);
            this.assertPresent(RELIABILITY);
            return true;
        }
        catch (Throwable t2) {
            String context = this.thisRecord.toString();
            throw new IllegalArgumentException("While parsing " + context, t2);
        }
    }

    void assertPresent(String field) {
        String value = this.get(field);
        if (value == null) {
            throw new NullPointerException("Missing field: " + field);
        }
        if (value.isEmpty()) {
            throw new NullPointerException("Empty field: " + field);
        }
    }

    void assertEqual(String field, String expected) {
        this.assertPresent(field);
        String value = this.get(field);
        if (!value.equals(expected)) {
            throw new NullPointerException("Expected " + field + "=" + expected + " but got " + value);
        }
    }

    private final String get(String field) {
        String value = this.thisRecord.get(field);
        if (value == null) {
            return value;
        }
        return value.trim();
    }

    private void handleRecord() {
        String country = this.get(COUNTRY_OR_AREA);
        String year = this.get(YEAR);
        String age = this.get(AGE);
        String literacy = this.get(LITERACY);
        String reliability = this.get(RELIABILITY);
        PerAge pa = this.perCountry.computeIfAbsent((String)country, (Function<String, PerCountry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handleRecord$0(java.lang.String ), (Ljava/lang/String;)Lorg/unicode/cldr/tool/UnLiteracyParser$PerCountry;)((UnLiteracyParser)this)).perYear.computeIfAbsent((String)year, (Function<String, PerYear>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handleRecord$1(java.lang.String ), (Ljava/lang/String;)Lorg/unicode/cldr/tool/UnLiteracyParser$PerYear;)((UnLiteracyParser)this)).perAge.computeIfAbsent(age, a -> new PerAge());
        if (pa.reliability == null) {
            pa.reliability = reliability;
        } else if (!pa.reliability.equals(reliability)) {
            throw new IllegalArgumentException("Inconsistent reliability " + reliability + " for " + String.valueOf(this.thisRecord));
        }
        Long new_value = this.getLongValue();
        Long old_value = pa.perLiteracy.put(literacy, new_value);
        if (old_value != null) {
            if (country.equals("Suriname")) {
                pa.perLiteracy.put(literacy, Math.max(old_value, new_value));
            } else {
                System.err.println("Duplicate record " + country + " " + year + " " + age);
            }
        }
    }

    private long getLongValue() {
        String value = this.get(VALUE);
        if (value.contains(".")) {
            return Long.parseLong(value.split("\\.")[0]);
        }
        return Long.parseLong(value);
    }

    private /* synthetic */ PerYear lambda$handleRecord$1(String y) {
        return new PerYear();
    }

    private /* synthetic */ PerCountry lambda$handleRecord$0(String c) {
        return new PerCountry();
    }

    final class PerAge {
        final Map<String, Long> perLiteracy = new TreeMap<String, Long>();
        String reliability = null;

        PerAge() {
        }
    }

    final class PerYear {
        final Map<String, PerAge> perAge = new TreeMap<String, PerAge>();

        PerYear() {
        }

        Long total(String literacy) {
            return this.perAge.values().stream().map(pa -> pa.perLiteracy.getOrDefault(literacy, 0L)).reduce(0L, (a, b) -> a + b);
        }
    }

    final class PerCountry {
        final Map<String, PerYear> perYear = new TreeMap<String, PerYear>();

        PerCountry() {
        }

        public String latest() {
            String[] y = this.perYear.keySet().toArray(new String[0]);
            return y[y.length - 1];
        }
    }
}

