/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CldrXmlWriter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.ExtraPaths;
import org.unicode.cldr.util.GlossonymConstructor;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.LocaleInheritanceInfo;
import org.unicode.cldr.util.LocaleStringProvider;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleUnicodeSetFormatter;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CLDRFile
implements Freezable<CLDRFile>,
Iterable<String>,
LocaleStringProvider {
    private static final boolean USE_LOADING_BUFFER = true;
    private static final boolean DEBUG = false;
    public static final Pattern ALT_PROPOSED_PATTERN = PatternCache.get(".*\\[@alt=\"[^\"]*proposed[^\"]*\"].*");
    public static final Pattern DRAFT_PATTERN = PatternCache.get("\\[@draft=\"([^\"]*)\"\\]");
    public static final Pattern XML_SPACE_PATTERN = PatternCache.get("\\[@xml:space=\"([^\"]*)\"\\]");
    private static final boolean LOG_PROGRESS = false;
    public static boolean HACK_ORDER = false;
    private static final boolean DEBUG_LOGGING = false;
    public static final String SUPPLEMENTAL_NAME = "supplementalData";
    public static final String GEN_VERSION = "48";
    public static final List<String> SUPPLEMENTAL_NAMES = Arrays.asList("characters", "coverageLevels", "dayPeriods", "genderList", "grammaticalFeatures", "languageInfo", "languageGroup", "likelySubtags", "metaZones", "numberingSystems", "ordinals", "pluralRanges", "plurals", "postalCodeData", "rgScope", "supplementalData", "supplementalMetadata", "telephoneCodeData", "units", "windowsZones");
    private Set<String> extraPaths = null;
    private boolean locked;
    private DtdType dtdType;
    private DtdData dtdData;
    XMLSource dataSource;
    private File supplementalDirectory;
    private final NameGetter nameGetter;
    private static final boolean DEBUG_CLDR_FILE = false;
    private String creationTime = null;
    private static final Map<String, Object> nullOptions = Collections.unmodifiableMap(new TreeMap());
    public static final int MERGE_KEEP_MINE = 0;
    public static final int MERGE_REPLACE_MINE = 1;
    public static final int MERGE_ADD_ALTERNATE = 2;
    public static final int MERGE_REPLACE_MY_DRAFT = 3;
    private static final boolean MINIMIZE_ALT_PROPOSED = false;
    private final boolean DEFAULT_ITERATION_INCLUDES_EXTRAS = true;
    private static final Object syncObject = new Object();
    static final Relation<Row.R2<String, String>, String> bcp47AliasMap = CLDRConfig.getInstance().getSupplementalDataInfo().getBcp47Aliases();
    public static final Transform<String, String> SHORT_ALTS = source -> "short";
    private static final Comparator<String> ldmlComparator = DtdData.getInstance(DtdType.ldmlICU).getDtdComparator(null);
    private static final Map<String, Map<String, String>> defaultSuppressionMap;
    static final UnicodeSet HACK_CASE_CLOSURE_SET;
    private static final DistinguishedXPath distinguishedXPath;
    @Deprecated
    public static final int LANGUAGE_NAME = 0;
    @Deprecated
    public static final int SCRIPT_NAME = 1;
    @Deprecated
    public static final int TERRITORY_NAME = 2;

    public boolean equalsOrInheritsCurrentValue(String value, String curValue, String xpathString) {
        if (value == null || curValue == null) {
            return false;
        }
        if (value.equals(curValue)) {
            return true;
        }
        if (value.equals(CldrUtility.INHERITANCE_MARKER)) {
            String baileyValue = this.getBaileyValue(xpathString, null, null);
            if (baileyValue == null) {
                return false;
            }
            if (curValue.equals(baileyValue)) {
                return true;
            }
        }
        return false;
    }

    public XMLSource getResolvingDataSource() {
        if (!this.isResolved()) {
            throw new IllegalArgumentException("CLDRFile must be resolved for getResolvingDataSource");
        }
        return this.dataSource;
    }

    public String toString() {
        return "{locked=" + this.locked + " locale=" + this.dataSource.getLocaleID() + " dataSource=" + this.dataSource.toString() + "}";
    }

    public String toString(String regex) {
        return "{locked=" + this.locked + " locale=" + this.dataSource.getLocaleID() + " regex=" + regex + " dataSource=" + this.dataSource.toString(regex) + "}";
    }

    public CLDRFile setNonInheriting(boolean isSupplemental) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.setNonInheriting(isSupplemental);
        return this;
    }

    public boolean isNonInheriting() {
        return this.dataSource.isNonInheriting();
    }

    public CLDRFile(XMLSource dataSource) {
        this.dataSource = dataSource;
        this.nameGetter = new NameGetter(this);
    }

    public CLDRFile(String localeId, List<File> dirs, DraftStatus minimalDraftStatus) {
        this.nameGetter = new NameGetter(this);
        this.dataSource = XMLSource.getFrozenInstance(localeId, dirs, minimalDraftStatus);
        this.dtdType = this.dataSource.getXMLNormalizingDtdType();
        this.dtdData = DtdData.getInstance(this.dtdType);
    }

    public CLDRFile(XMLSource dataSource, XMLSource ... resolvingParents) {
        this.nameGetter = new NameGetter(this);
        ArrayList<XMLSource> sourceList = new ArrayList<XMLSource>();
        sourceList.add(dataSource);
        sourceList.addAll(Arrays.asList(resolvingParents));
        this.dataSource = new XMLSource.ResolvingSource(sourceList);
    }

    public NameGetter nameGetter() {
        return this.nameGetter;
    }

    public static CLDRFile loadFromFile(File f, String localeName, DraftStatus minimalDraftStatus, XMLSource source) {
        CLDRFile cLDRFile;
        block8: {
            String fullFileName = f.getAbsolutePath();
            fullFileName = PathUtilities.getNormalizedPathString(f);
            InputStream fis = InputStreamFactory.createInputStream(f);
            try {
                CLDRFile cldrFile;
                cLDRFile = cldrFile = CLDRFile.load(fullFileName, localeName, fis, minimalDraftStatus, source);
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String sb = "Cannot read the file '" + fullFileName + "': " + e.getMessage();
                    throw new ICUUncheckedIOException(sb, e);
                }
            }
            fis.close();
        }
        return cLDRFile;
    }

    public static CLDRFile loadFromFiles(List<File> dirs, String localeName, DraftStatus minimalDraftStatus, XMLSource source) {
        try {
            CLDRFile cldrFile = new CLDRFile(source);
            for (File dir : dirs) {
                File f = new File(dir, localeName + ".xml");
                InputStream fis = InputStreamFactory.createInputStream(f);
                try {
                    cldrFile.loadFromInputStream(PathUtilities.getNormalizedPathString(f), localeName, fis, minimalDraftStatus, false);
                }
                finally {
                    if (fis == null) continue;
                    fis.close();
                }
            }
            return cldrFile;
        }
        catch (Exception e) {
            throw new ICUUncheckedIOException("Cannot read the file '" + String.valueOf(dirs), e);
        }
    }

    public static CLDRFile loadFromFile(File f, String localeName, DraftStatus minimalDraftStatus) {
        return CLDRFile.loadFromFile(f, localeName, minimalDraftStatus, new SimpleXMLSource(localeName));
    }

    public static CLDRFile loadFromFiles(List<File> dirs, String localeName, DraftStatus minimalDraftStatus) {
        return CLDRFile.loadFromFiles(dirs, localeName, minimalDraftStatus, new SimpleXMLSource(localeName));
    }

    static CLDRFile load(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus) {
        return CLDRFile.load(fileName, localeName, fis, minimalDraftStatus, new SimpleXMLSource(localeName));
    }

    private static CLDRFile load(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus, XMLSource source) {
        CLDRFile cldrFile = new CLDRFile(source);
        return cldrFile.loadFromInputStream(fileName, localeName, fis, minimalDraftStatus, false);
    }

    private static CLDRFile load(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus, XMLSource source, boolean leniency) {
        CLDRFile cldrFile = new CLDRFile(source);
        return cldrFile.loadFromInputStream(fileName, localeName, fis, minimalDraftStatus, leniency);
    }

    static CLDRFile load(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus, boolean leniency) {
        return CLDRFile.load(fileName, localeName, fis, minimalDraftStatus, new SimpleXMLSource(localeName), leniency);
    }

    public CLDRFile loadFromInputStream(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus, boolean leniency) {
        CLDRFile cldrFile = this;
        MyDeclHandler DEFAULT_DECLHANDLER = new MyDeclHandler(cldrFile, minimalDraftStatus);
        XMLFileReader.read(fileName, fis, -1, !leniency, (XMLFileReader.AllHandler)DEFAULT_DECLHANDLER);
        if (DEFAULT_DECLHANDLER.isSupplemental < 0) {
            throw new IllegalArgumentException("root of file must be either ldml or supplementalData");
        }
        cldrFile.setNonInheriting(DEFAULT_DECLHANDLER.isSupplemental > 0);
        if (DEFAULT_DECLHANDLER.overrideCount > 0) {
            throw new IllegalArgumentException("Internal problems: either data file has duplicate path, or CLDRFile.isDistinguishing() or CLDRFile.isOrdered() need updating: " + DEFAULT_DECLHANDLER.overrideCount + "; The exact problems are printed on the console above.");
        }
        if (localeName == null) {
            cldrFile.dataSource.setLocaleID(cldrFile.getLocaleIDFromIdentity());
        }
        return cldrFile;
    }

    @Override
    public CLDRFile cloneAsThawed() {
        try {
            CLDRFile result = (CLDRFile)super.clone();
            result.locked = false;
            result.dataSource = result.dataSource.cloneAsThawed();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }

    public CLDRFile show() {
        for (String xpath : this) {
            System.out.println(this.getFullXPath(xpath) + " =>\t" + this.getStringValue(xpath));
        }
        return this;
    }

    public void write(PrintWriter pw) {
        this.write(pw, nullOptions);
    }

    public boolean write(PrintWriter pw, Map<String, ?> options) {
        CldrXmlWriter xmlWriter = new CldrXmlWriter(this, pw, options);
        xmlWriter.write();
        return true;
    }

    @Override
    public String getStringValue(String xpath) {
        try {
            String constructedValue;
            String fallbackPath;
            String result = this.dataSource.getValueAtPath(xpath);
            if (result == null && this.dataSource.isResolving() && (fallbackPath = this.getFallbackPath(xpath, false, true)) != null) {
                result = this.dataSource.getValueAtPath(fallbackPath);
            }
            if (this.isResolved() && GlossonymConstructor.valueIsBogus(result) && GlossonymConstructor.pathIsEligible(xpath) && (constructedValue = new GlossonymConstructor(this).getValue(xpath)) != null) {
                result = constructedValue;
            }
            return result;
        }
        catch (Exception e) {
            throw new UncheckedExecutionException("Bad path: " + xpath, e);
        }
    }

    public String getBaileyValue(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        GlossonymConstructor gc;
        String constructedValue;
        String result = this.dataSource.getBaileyValue(xpath, pathWhereFound, localeWhereFound);
        if ((result == null || result.equals(CldrUtility.INHERITANCE_MARKER)) && this.dataSource.isResolving()) {
            String fallbackPath = this.getFallbackPath(xpath, false, false);
            if (xpath.equals(fallbackPath)) {
                this.getFallbackPath(xpath, false, true);
                throw new IllegalArgumentException();
            }
            if (fallbackPath != null && (result = this.dataSource.getValueAtPath(fallbackPath)) != null) {
                Status status = new Status();
                if (localeWhereFound != null) {
                    localeWhereFound.value = this.dataSource.getSourceLocaleID(fallbackPath, status);
                }
                if (pathWhereFound != null) {
                    pathWhereFound.value = status.pathWhereFound;
                }
            }
        }
        if (this.isResolved() && GlossonymConstructor.valueIsBogus(result) && GlossonymConstructor.pathIsEligible(xpath) && (constructedValue = (gc = new GlossonymConstructor(this)).getValueAndTrack(xpath, pathWhereFound, localeWhereFound)) != null) {
            result = constructedValue;
        }
        return result;
    }

    public List<LocaleInheritanceInfo> getPathsWhereFound(String xpath) {
        if (!this.isResolved()) {
            throw new IllegalArgumentException("getPathsWhereFound() is only valid on a resolved CLDRFile");
        }
        LinkedList<LocaleInheritanceInfo> list = new LinkedList<LocaleInheritanceInfo>();
        Status status = new Status();
        this.getSourceLocaleIdExtended(xpath, status, false, list);
        String path1 = status.pathWhereFound;
        if (path1.equals("constructed")) {
            Set<String> xpaths = new GlossonymConstructor(this).getPathsWhereFound(xpath, new TreeSet<String>(Comparator.reverseOrder()));
            for (String subpath : xpaths) {
                String locale2 = this.getSourceLocaleIdExtended(subpath, status, true);
                String path2 = status.pathWhereFound;
                list.addFirst(new LocaleInheritanceInfo(locale2, path2, LocaleInheritanceInfo.Reason.constructed));
            }
        }
        return list;
    }

    private String getFallbackPath(String xpath, boolean winning, boolean checkExtraPaths) {
        if (GrammarInfo.GrammaticalFeature.pathHasFeature(xpath) != null) {
            return this.getCountPathWithFallback(xpath, SupplementalDataInfo.PluralInfo.Count.other, winning);
        }
        if (checkExtraPaths && this.getRawExtraPaths().contains(xpath)) {
            return xpath;
        }
        return null;
    }

    public String getFullXPath(String xpath) {
        if (xpath == null) {
            throw new NullPointerException("Null distinguishing xpath");
        }
        String result = this.dataSource.getFullPath(xpath);
        return result != null ? result : xpath;
    }

    public Date getLastModifiedDate(String xpath) {
        return this.dataSource.getChangeDateAtDPath(xpath);
    }

    @Override
    public String getSourceLocaleID(String distinguishedXPath, Status status) {
        return this.getSourceLocaleIdExtended(distinguishedXPath, status, true);
    }

    public String getSourceLocaleIdExtended(String distinguishedXPath, Status status, boolean skipInheritanceMarker) {
        return this.getSourceLocaleIdExtended(distinguishedXPath, status, skipInheritanceMarker, null);
    }

    public String getSourceLocaleIdExtended(String distinguishedXPath, Status status, boolean skipInheritanceMarker, List<LocaleInheritanceInfo> list) {
        String result = this.dataSource.getSourceLocaleIdExtended(distinguishedXPath, status, skipInheritanceMarker, list);
        if ("code-fallback".equals(result) && this.dataSource.isResolving()) {
            String fallbackPath = this.getFallbackPath(distinguishedXPath, false, true);
            if (fallbackPath != null && !fallbackPath.equals(distinguishedXPath)) {
                if (list != null) {
                    list.add(new LocaleInheritanceInfo(this.getLocaleID(), distinguishedXPath, LocaleInheritanceInfo.Reason.fallback, null));
                }
                result = this.dataSource.getSourceLocaleIdExtended(fallbackPath, status, skipInheritanceMarker, list);
            }
            if ("code-fallback".equals(result) && this.getConstructedValue(distinguishedXPath) != null) {
                if (status != null) {
                    status.pathWhereFound = "constructed";
                }
                return this.getLocaleID();
            }
        }
        return result;
    }

    public boolean isHere(String path) {
        return this.dataSource.isHere(path);
    }

    public CLDRFile add(String currentFullXPath, String value) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(false, "ADDING: \t" + currentFullXPath + " \t" + value + "\t" + currentFullXPath);
        try {
            this.dataSource.putValueAtPath(currentFullXPath, value);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("failed adding " + currentFullXPath + ",\t" + value, e);
        }
        return this;
    }

    public CLDRFile addSourceLocation(String currentFullXPath, XMLSource.SourceLocation location) {
        this.dataSource.addSourceLocation(currentFullXPath, location);
        return this;
    }

    public XMLSource.SourceLocation getSourceLocation(String path) {
        String fullPath = this.getFullXPath(path);
        return this.dataSource.getSourceLocation(fullPath);
    }

    public CLDRFile addComment(String xpath, String comment, XPathParts.Comments.CommentType type) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(false, "ADDING Comment: \t" + String.valueOf((Object)type) + "\t" + xpath + " \t" + comment);
        if (xpath == null || xpath.isEmpty()) {
            this.dataSource.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", comment));
        } else {
            xpath = CLDRFile.getDistinguishingXPath(xpath, null);
            this.dataSource.getXpathComments().addComment(type, xpath, comment);
        }
        return this;
    }

    public CLDRFile putAll(CLDRFile other, int conflict_resolution) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        if (conflict_resolution == 0) {
            this.dataSource.putAll(other.dataSource, 0);
        } else if (conflict_resolution == 1) {
            this.dataSource.putAll(other.dataSource, 1);
        } else if (conflict_resolution == 3) {
            HashSet<String> hasDraftVersion = new HashSet<String>();
            for (String cpath : this.dataSource) {
                String fullpath = this.getFullXPath(cpath);
                if (!fullpath.contains("[@draft")) continue;
                hasDraftVersion.add(CLDRFile.getNondraftNonaltXPath(cpath));
            }
            for (String cpath : other) {
                cpath = CLDRFile.getNondraftNonaltXPath(cpath);
                String newValue = other.getStringValue(cpath);
                String newFullPath = CLDRFile.getNondraftNonaltXPath(other.getFullXPath(cpath));
                newFullPath = this.addReferencesIfNeeded(newFullPath, this.getFullXPath(cpath));
                if (!hasDraftVersion.contains(cpath)) {
                    if (cpath.startsWith("//ldml/identity/")) continue;
                    String myVersion = this.getStringValue(cpath);
                    if (myVersion == null || !newValue.equals(myVersion)) {
                        Log.logln(this.getLocaleID() + "\tDenied attempt to replace non-draft\n\tcurr: [" + cpath + ",\t" + myVersion + "]\n\twith: [" + newValue + "]");
                        continue;
                    }
                }
                Log.logln(this.getLocaleID() + "\tVETTED: [" + newFullPath + ",\t" + newValue + "]");
                this.dataSource.putValueAtPath(newFullPath, newValue);
            }
        } else if (conflict_resolution == 2) {
            block2: for (String key : other) {
                String otherValue = other.getStringValue(key);
                String myValue = this.dataSource.getValueAtPath(key);
                if (myValue == null) {
                    this.dataSource.putValueAtPath(other.getFullXPath(key), otherValue);
                    continue;
                }
                if (myValue.equals(otherValue) && CLDRFile.equalsIgnoringDraft(this.getFullXPath(key), other.getFullXPath(key)) || key.startsWith("//ldml/identity")) continue;
                int i = 0;
                while (true) {
                    String prop = "proposed" + (i == 0 ? "" : String.valueOf(i));
                    XPathParts parts = XPathParts.getFrozenInstance(other.getFullXPath(key)).cloneAsThawed();
                    String fullPath = parts.addAttribute("alt", prop).toString();
                    String path = CLDRFile.getDistinguishingXPath(fullPath, null);
                    if (this.dataSource.getValueAtPath(path) == null) {
                        this.dataSource.putValueAtPath(fullPath, otherValue);
                        continue block2;
                    }
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal operand: " + conflict_resolution);
        }
        this.dataSource.getXpathComments().setInitialComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getInitialComment(), "\n", other.dataSource.getXpathComments().getInitialComment()));
        this.dataSource.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", other.dataSource.getXpathComments().getFinalComment()));
        this.dataSource.getXpathComments().joinAll(other.dataSource.getXpathComments());
        return this;
    }

    private String addReferencesIfNeeded(String newFullPath, String fullXPath) {
        Object references;
        Map<String, String> attributes;
        if (fullXPath == null || !fullXPath.contains("[@references=")) {
            return newFullPath;
        }
        XPathParts parts = XPathParts.getFrozenInstance(fullXPath);
        Object accummulatedReferences = null;
        for (int i = 0; i < parts.size(); ++i) {
            attributes = parts.getAttributes(i);
            references = attributes.get("references");
            if (references == null) continue;
            accummulatedReferences = accummulatedReferences == null ? references : (String)accummulatedReferences + ", " + (String)references;
        }
        if (accummulatedReferences == null) {
            return newFullPath;
        }
        XPathParts newParts = XPathParts.getFrozenInstance(newFullPath);
        attributes = newParts.getAttributes(newParts.size() - 1);
        references = attributes.get("references");
        references = references == null ? accummulatedReferences : (String)references + ", " + (String)accummulatedReferences;
        attributes.put("references", (String)references);
        System.out.println("Changing " + newFullPath + " plus " + fullXPath + " to " + String.valueOf(newParts));
        return newParts.toString();
    }

    public CLDRFile remove(String xpath) {
        this.remove(xpath, false);
        return this;
    }

    public CLDRFile remove(String xpath, boolean butComment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        if (butComment) {
            this.appendFinalComment(this.dataSource.getFullPath(xpath) + "::<" + this.dataSource.getValueAtPath(xpath) + ">");
        }
        this.dataSource.removeValueAtPath(xpath);
        return this;
    }

    public CLDRFile removeAll(Set<String> xpaths, boolean butComment) {
        if (butComment) {
            this.appendFinalComment("Illegal attributes removed:");
        }
        for (String xpath : xpaths) {
            this.remove(xpath, butComment);
        }
        return this;
    }

    public CLDRFile removeDuplicates(CLDRFile other, boolean butComment, RetentionTest keepIfMatches, Collection<String> removedItems) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        boolean first = true;
        if (removedItems == null) {
            removedItems = new ArrayList<String>();
        } else {
            removedItems.clear();
        }
        HashSet<String> checked = new HashSet<String>();
        for (String curXpath : this) {
            boolean logicDuplicate = true;
            if (checked.contains(curXpath)) continue;
            Set<String> logicGroups = LogicalGrouping.getPaths(this, curXpath);
            if (logicGroups != null) {
                Iterator<String> iter = logicGroups.iterator();
                while (iter.hasNext() && logicDuplicate) {
                    String xpath = iter.next();
                    switch (keepIfMatches.getRetention(xpath)) {
                        case RETAIN: {
                            logicDuplicate = false;
                            break;
                        }
                        case RETAIN_IF_DIFFERENT: {
                            String otherFullXPath;
                            String currentValue = this.dataSource.getValueAtPath(xpath);
                            if (currentValue == null) {
                                logicDuplicate = false;
                                break;
                            }
                            String otherXpath = xpath;
                            String otherValue = other.dataSource.getValueAtPath(otherXpath);
                            if (!currentValue.equals(otherValue)) {
                                logicDuplicate = false;
                                break;
                            }
                            String currentFullXPath = this.dataSource.getFullPath(xpath);
                            if (CLDRFile.equalsIgnoringDraft(currentFullXPath, otherFullXPath = other.dataSource.getFullPath(otherXpath))) break;
                            logicDuplicate = false;
                            break;
                        }
                    }
                }
                if (first) {
                    first = false;
                    if (butComment) {
                        this.appendFinalComment("Duplicates removed:");
                    }
                }
            }
            if (logicGroups == null) continue;
            checked.addAll(logicGroups);
            if (!logicDuplicate) continue;
            removedItems.addAll(logicGroups);
        }
        for (String xpath : removedItems) {
            this.remove(xpath, butComment);
        }
        return this;
    }

    public String getFinalComment() {
        return this.dataSource.getXpathComments().getFinalComment();
    }

    public String getInitialComment() {
        return this.dataSource.getXpathComments().getInitialComment();
    }

    public XPathParts.Comments getXpath_comments() {
        return (XPathParts.Comments)this.dataSource.getXpathComments().clone();
    }

    @Override
    public String getLocaleID() {
        return this.dataSource.getLocaleID();
    }

    public String getLocaleIDFromIdentity() {
        ULocale.Builder lb = new ULocale.Builder();
        Iterator<String> i = this.iterator("//ldml/identity/");
        while (i.hasNext()) {
            XPathParts xpp = XPathParts.getFrozenInstance(i.next());
            String k = xpp.getElement(-1);
            String v = xpp.getAttributeValue(-1, "type");
            switch (k) {
                case "language": {
                    lb.setLanguage(v);
                    break;
                }
                case "script": {
                    lb.setScript(v);
                    break;
                }
                case "territory": {
                    lb.setRegion(v);
                    break;
                }
                case "variant": {
                    lb.setVariant(v);
                }
            }
        }
        return lb.build().toString();
    }

    private String getDateFormatXpath(String calendar, String length) {
        String formatPattern = "//ldml/dates/calendars/calendar[@type=\"%s\"]/dateFormats/dateFormatLength[@type=\"%s\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        return String.format(formatPattern, calendar, length);
    }

    private String getDateSkeletonXpath(String calendar, String length) {
        String formatPattern = "//ldml/dates/calendars/calendar[@type=\"%s\"]/dateFormats/dateFormatLength[@type=\"%s\"]/dateFormat[@type=\"standard\"]/datetimeSkeleton";
        return String.format(formatPattern, calendar, length);
    }

    private String getTimeFormatXpath(String calendar, String length) {
        String formatPattern = "//ldml/dates/calendars/calendar[@type=\"%s\"]/timeFormats/timeFormatLength[@type=\"%s\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        return String.format(formatPattern, calendar, length);
    }

    private String getDateTimeFormatXpath(String calendar, String length, String formatType) {
        String formatPattern = "//ldml/dates/calendars/calendar[@type=\"%s\"]/dateTimeFormats/dateTimeFormatLength[@type=\"%s\"]/dateTimeFormat[@type=\"%s\"]/pattern[@type=\"standard\"]";
        return String.format(formatPattern, calendar, length, formatType);
    }

    public SimpleDateFormat getDateFormat(String calendar, String length, ICUServiceBuilder icuServiceBuilder) {
        String dateFormatXPath = this.getDateFormatXpath(calendar, length);
        String dateFormatValue = this.getWinningValue(dateFormatXPath);
        if (dateFormatValue == null) {
            return null;
        }
        XPathParts parts = XPathParts.getFrozenInstance(this.getFullXPath(dateFormatXPath));
        String dateNumbersOverride = parts.findAttributeValue("pattern", "numbers");
        return icuServiceBuilder.getDateFormat(calendar, dateFormatValue, dateNumbersOverride);
    }

    public SimpleDateFormat getTimeFormat(String calendar, String length, ICUServiceBuilder icuServiceBuilder) {
        String timeFormatXPath = this.getTimeFormatXpath(calendar, length);
        String timeFormatValue = this.getWinningValue(timeFormatXPath);
        if (timeFormatValue == null) {
            return null;
        }
        XPathParts parts = XPathParts.getFrozenInstance(this.getFullXPath(timeFormatXPath));
        String timeNumbersOverride = parts.findAttributeValue("pattern", "numbers");
        return icuServiceBuilder.getDateFormat(calendar, timeFormatValue, timeNumbersOverride);
    }

    public String glueDateTimeFormat(String date, String time, String calendar, String length, String formatType, ICUServiceBuilder icuServiceBuilder) {
        String xpath = this.getDateTimeFormatXpath(calendar, length, formatType);
        String gluePattern = this.getWinningValue(xpath);
        return this.glueDateTimeFormatWithGluePattern(date, time, calendar, gluePattern, icuServiceBuilder);
    }

    public String glueDateTimeFormatWithGluePattern(String date, String time, String calendar, String gluePattern, ICUServiceBuilder icuServiceBuilder) {
        SimpleDateFormat temp = icuServiceBuilder.getDateFormat(calendar, gluePattern, null);
        TimeZone tempTimeZone = TimeZone.GMT_ZONE;
        Calendar tempCalendar = Calendar.getInstance(tempTimeZone, ULocale.ENGLISH);
        Date tempDate = tempCalendar.getTime();
        String gluePatternWithoutQuotes = temp.format(tempDate);
        return MessageFormat.format(gluePatternWithoutQuotes, time, date);
    }

    public String getDateSkeleton(String calendar, String length) {
        String dateTimeSkeletonXPath = this.getDateSkeletonXpath(calendar, length);
        return this.getWinningValue(dateTimeSkeletonXPath);
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.locked;
    }

    @Override
    public synchronized CLDRFile freeze() {
        this.locked = true;
        this.dataSource.freeze();
        return this;
    }

    public CLDRFile clearComments() {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.setXpathComments(new XPathParts.Comments());
        return this;
    }

    public CLDRFile setFinalComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setFinalComment(comment);
        return this;
    }

    public CLDRFile appendFinalComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", comment));
        return this;
    }

    public CLDRFile setInitialComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setInitialComment(comment);
        return this;
    }

    public static Set<String> getMatchingXMLFiles(File[] sourceDirs, Matcher m4) {
        TreeSet<String> s2 = new TreeSet<String>();
        for (File dir : sourceDirs) {
            File[] files;
            if (!dir.exists()) {
                throw new IllegalArgumentException("Directory doesn't exist:\t" + dir.getPath());
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Input isn't a file directory:\t" + dir.getPath());
            }
            for (File file : files = dir.listFiles()) {
                String locale;
                String name = file.getName();
                if (!name.endsWith(".xml") || name.startsWith(".") || !m4.reset(locale = name.substring(0, name.length() - 4)).matches()) continue;
                s2.add(locale);
            }
        }
        return s2;
    }

    @Override
    public Iterator<String> iterator() {
        return Iterators.filter(this.fullIterable().iterator(), p -> this.getStringValue((String)p) != null);
    }

    public Iterator<String> iterator(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.iterator();
        }
        return Iterators.filter(this.iterator(), p -> p.startsWith(prefix));
    }

    public Iterator<String> iterator(Matcher pathFilter) {
        if (pathFilter == null) {
            return this.iterator();
        }
        return Iterators.filter(this.iterator(), p -> pathFilter.reset((CharSequence)p).matches());
    }

    public Iterator<String> iterator(String prefix, Comparator<String> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("iterator requires non-null comparator");
        }
        Iterator<String> it = prefix == null || prefix.isEmpty() ? this.iterator() : this.iterator(prefix);
        TreeSet<String> orderedSet = new TreeSet<String>(comparator);
        it.forEachRemaining(orderedSet::add);
        return orderedSet.iterator();
    }

    private Iterator<String> iteratorWithoutExtras() {
        return this.dataSource.iterator();
    }

    private synchronized Iterator<String> iteratorWithoutExtras(String prefix) {
        return this.dataSource.iterator(prefix);
    }

    private Iterator<String> iteratorWithoutExtras(Matcher pathFilter) {
        return this.dataSource.iterator(pathFilter);
    }

    public Iterator<String> iteratorWithoutExtras(String prefix, Comparator<String> comparator) {
        Iterator<String> it;
        Iterator<String> iterator = it = prefix == null || prefix.isEmpty() ? this.dataSource.iterator() : this.dataSource.iterator(prefix);
        if (comparator == null) {
            return it;
        }
        TreeSet<String> orderedSet = new TreeSet<String>(comparator);
        it.forEachRemaining(orderedSet::add);
        return orderedSet.iterator();
    }

    public Iterable<String> iterableWithoutExtras() {
        return this::iteratorWithoutExtras;
    }

    public Iterable<String> fullIterable() {
        return new FullIterable(this);
    }

    public static String getDistinguishingXPath(String xpath, String[] normalizedPath) {
        return DistinguishedXPath.getDistinguishingXPath(xpath, normalizedPath);
    }

    private static boolean equalsIgnoringDraft(String path1, String path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.equals(path2)) {
            return true;
        }
        if (!path1.contains("[@draft=") && !path2.contains("[@draft=")) {
            return false;
        }
        return CLDRFile.getNondraftNonaltXPath(path1).equals(CLDRFile.getNondraftNonaltXPath(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNondraftNonaltXPath(String xpath) {
        if (!xpath.contains("draft=\"") && !xpath.contains("alt=\"")) {
            return xpath;
        }
        Object object = syncObject;
        synchronized (object) {
            XPathParts parts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
            HashSet<String> toRemove = new HashSet<String>();
            for (int i = 0; i < parts.size(); ++i) {
                if (parts.getAttributeCount(i) == 0) continue;
                Map<String, String> attributes = parts.getAttributes(i);
                toRemove.clear();
                String restore = null;
                for (String attribute : attributes.keySet()) {
                    String value;
                    int proposedPos;
                    if (attribute.equals("draft")) {
                        toRemove.add(attribute);
                        continue;
                    }
                    if (!attribute.equals("alt") || (proposedPos = (value = attributes.get(attribute)).indexOf("proposed")) < 0) continue;
                    toRemove.add(attribute);
                    if (proposedPos <= 0) continue;
                    restore = value.substring(0, proposedPos - 1);
                }
                parts.removeAttributes(i, toRemove);
                if (restore == null) continue;
                attributes.put("alt", restore);
            }
            return parts.toString();
        }
    }

    public static boolean isDistinguishing(DtdType type, String elementName, String attribute) {
        return DtdData.getInstance(type).isDistinguishing(elementName, attribute);
    }

    public static XMLReader createXMLReader(boolean validating) {
        String[] testList = new String[]{"org.apache.xerces.parsers.SAXParser", "org.apache.crimson.parser.XMLReaderImpl", "gnu.xml.aelfred2.XmlReader", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", ""};
        XMLReader result = null;
        for (String s2 : testList) {
            try {
                result = !s2.isEmpty() ? XMLReaderFactory.createXMLReader(s2) : XMLReaderFactory.createXMLReader();
                result.setFeature("http://xml.org/sax/features/validation", validating);
                break;
            }
            catch (SAXException sAXException) {
            }
        }
        if (result == null) {
            throw new NoClassDefFoundError("No SAX parser is available, or unable to set validation correctly");
        }
        return result;
    }

    public File getSupplementalDirectory() {
        if (this.supplementalDirectory == null) {
            this.supplementalDirectory = CLDRConfig.getInstance().getSupplementalDataInfo().getDirectory();
        }
        return this.supplementalDirectory;
    }

    public CLDRFile setSupplementalDirectory(File supplementalDirectory) {
        this.supplementalDirectory = supplementalDirectory;
        return this;
    }

    public static boolean isSupplementalName(String localeName) {
        return SUPPLEMENTAL_NAMES.contains(localeName);
    }

    public static String showSAX(SAXParseException exception) {
        return exception.getMessage() + ";\t SystemID: " + exception.getSystemId() + ";\t PublicID: " + exception.getPublicId() + ";\t LineNumber: " + exception.getLineNumber() + ";\t ColumnNumber: " + exception.getColumnNumber();
    }

    public boolean isDraft() {
        String item = this.iterator().next();
        return item.startsWith("//ldml[@draft=\"unconfirmed\"]");
    }

    public Iterator<String> getAvailableIterator(NameType type) {
        String s2 = type.getPathStart();
        return this.iterator(s2);
    }

    public static String getLongTzid(String code) {
        Set<String> codes;
        if (!code.contains("/") && (codes = bcp47AliasMap.get(Row.of("tz", code))) != null && !codes.isEmpty()) {
            code = codes.iterator().next();
        }
        return code;
    }

    @Deprecated
    public static List<String> getElementOrder() {
        return Collections.emptyList();
    }

    public static List<String> getAttributeOrder() {
        return CLDRFile.getAttributeOrdering().getOrder();
    }

    public static boolean isOrdered(String element, DtdType type) {
        return DtdData.getInstance(type).isOrdered(element);
    }

    public static Map<String, Map<String, String>> getDefaultSuppressionMap() {
        return defaultSuppressionMap;
    }

    private static Map asMap(String[][] data, boolean tree) {
        AbstractMap tempmain = tree ? new TreeMap() : new HashMap();
        int len = data[0].length;
        for (int i = 0; i < data.length; ++i) {
            AbstractMap temp = tempmain;
            if (len != data[i].length) {
                throw new IllegalArgumentException("Must be square array: fails row " + i);
            }
            for (int j = 0; j < len - 2; ++j) {
                AbstractMap newTemp = (AbstractMap)temp.get(data[i][j]);
                if (newTemp == null) {
                    newTemp = tree ? new TreeMap() : new HashMap();
                    temp.put(data[i][j], newTemp);
                }
                temp = newTemp;
            }
            temp.put(data[i][len - 2], data[i][len - 1]);
        }
        return tempmain;
    }

    public CLDRFile removeComment(String string) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().removeComment(string);
        return this;
    }

    public CLDRFile makeDraft(DraftStatus draftStatus) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        for (String path : this.dataSource) {
            XPathParts parts = XPathParts.getFrozenInstance(this.dataSource.getFullPath(path)).cloneAsThawed();
            parts.addAttribute("draft", draftStatus.toString());
            this.dataSource.putValueAtPath(parts.toString(), this.dataSource.getValueAtPath(path));
        }
        return this;
    }

    public UnicodeSet getExemplarSet(String type, WinningChoice winningChoice) {
        return this.getExemplarSet(type, winningChoice, 2);
    }

    public UnicodeSet getExemplarSet(ExemplarType type, WinningChoice winningChoice) {
        return this.getExemplarSet(type, winningChoice, 2);
    }

    public UnicodeSet getExemplarSet(String type, WinningChoice winningChoice, int option) {
        return this.getExemplarSet(ExemplarType.fromString(type), winningChoice, option);
    }

    public UnicodeSet getExemplarSet(ExemplarType type, WinningChoice winningChoice, int option) {
        UnicodeSet result = this.getRawExemplarSet(type, winningChoice);
        if (result.isEmpty()) {
            return result.cloneAsThawed();
        }
        UnicodeSet toNuke = new UnicodeSet(HACK_CASE_CLOSURE_SET).removeAll(result);
        result.closeOver(2);
        result.removeAll(toNuke);
        result.remove(32);
        return result;
    }

    public UnicodeSet getRawExemplarSet(ExemplarType type, WinningChoice winningChoice) {
        String v;
        String path = CLDRFile.getExemplarPath(type);
        if (winningChoice == WinningChoice.WINNING) {
            path = this.getWinningPath(path);
        }
        if ((v = this.getStringValueWithBailey(path)) == null) {
            return UnicodeSet.EMPTY;
        }
        return SimpleUnicodeSetFormatter.parseLenient(v);
    }

    public static String getExemplarPath(ExemplarType type) {
        return "//ldml/characters/exemplarCharacters" + (String)(type == ExemplarType.main ? "" : "[@type=\"" + String.valueOf((Object)type) + "\"]");
    }

    public UnicodeSet getExemplarsNumeric(NumberingSystem system) {
        String numberingSystem;
        String string = numberingSystem = system.path == null ? "latn" : this.getStringValue(system.path);
        if (numberingSystem == null) {
            return UnicodeSet.EMPTY;
        }
        return this.getExemplarsNumeric(numberingSystem);
    }

    public UnicodeSet getExemplarsNumeric(String numberingSystem) {
        UnicodeSet result = new UnicodeSet();
        SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
        String[] symbolPaths = new String[]{"decimal", "group", "percentSign", "perMille", "plusSign", "minusSign"};
        String digits = sdi.getDigits(numberingSystem);
        if (digits != null) {
            result.addAll(digits);
        }
        for (String path : symbolPaths) {
            String fullPath = "//ldml/numbers/symbols[@numberSystem=\"" + numberingSystem + "\"]/" + path;
            String value = this.getStringValue(fullPath);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public boolean isResolved() {
        return this.dataSource.isResolving();
    }

    public boolean isEmpty() {
        return !this.dataSource.iterator().hasNext();
    }

    public Map<String, String> getNonDistinguishingAttributes(String fullPath, Map<String, String> result, Set<String> skipList) {
        return distinguishedXPath.getNonDistinguishingAttributes(fullPath, result, skipList);
    }

    public VersionInfo getDtdVersionInfo() {
        VersionInfo result = this.dataSource.getDtdVersionInfo();
        if (result != null || this.isEmpty()) {
            return result;
        }
        String path = this.dataSource.iterator().next();
        String full = this.getFullXPath(path);
        XPathParts parts = XPathParts.getFrozenInstance(full);
        String versionString = parts.findFirstAttributeValue("version");
        return versionString == null ? null : VersionInfo.getInstance(versionString);
    }

    private boolean contains(Map<String, String> a, Map<String, String> b) {
        for (String key : b.keySet()) {
            String otherValue = a.get(key);
            if (otherValue == null) {
                return false;
            }
            String value = b.get(key);
            if (otherValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public String getFullXPath(String path, boolean ignoreOtherLeafAttributes) {
        String result = this.getFullXPath(path);
        if (result != null) {
            return result;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        Map<String, String> lastAttributes = parts.getAttributes(parts.size() - 1);
        String base = parts.toString(parts.size() - 1) + "/" + parts.getElement(parts.size() - 1);
        Iterator<String> it = this.iterator(base);
        while (it.hasNext()) {
            Map<String, String> lastOtherAttributes;
            String otherPath = it.next();
            XPathParts other = XPathParts.getFrozenInstance(otherPath);
            if (other.size() != parts.size() || !this.contains(lastOtherAttributes = other.getAttributes(other.size() - 1), lastAttributes)) continue;
            if (result == null) {
                result = this.getFullXPath(otherPath);
                continue;
            }
            throw new IllegalArgumentException("Multiple values for path: " + path);
        }
        return result;
    }

    public boolean isWinningPath(String path) {
        return this.dataSource.isWinningPath(path);
    }

    public String getWinningPath(String path) {
        return this.dataSource.getWinningPath(path);
    }

    public String getWinningValue(String path) {
        String winningPath = this.getWinningPath(path);
        return winningPath == null ? null : this.getStringValue(winningPath);
    }

    public String getWinningValueWithBailey(String path) {
        String winningPath = this.getWinningPath(path);
        return winningPath == null ? null : this.getStringValueWithBailey(winningPath);
    }

    public String getStringValueWithBailey(String path) {
        return this.getStringValueWithBailey(path, null, null);
    }

    public String getStringValueWithBailey(String path, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        String value = this.getStringValue(path);
        if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
            value = this.getBaileyValue(path, pathWhereFound, localeWhereFound);
        } else if (localeWhereFound != null || pathWhereFound != null) {
            Status status = new Status();
            String localeWhereFound2 = this.getSourceLocaleID(path, status);
            if (localeWhereFound != null) {
                localeWhereFound.value = localeWhereFound2;
            }
            if (pathWhereFound != null) {
                pathWhereFound.value = status.pathWhereFound;
            }
        }
        return value;
    }

    public Set<String> getPathsWithValue(String valueToMatch, String pathPrefix, Matcher pathMatcher, Set<String> result) {
        if (result == null) {
            result = new HashSet<String>();
        }
        this.dataSource.getPathsWithValue(valueToMatch, pathPrefix, result);
        if (pathMatcher == null) {
            return result;
        }
        result.removeIf(path -> !pathMatcher.reset((CharSequence)path).matches());
        return result;
    }

    public Set<String> getPaths(String pathPrefix, Matcher pathMatcher, Set<String> result) {
        if (result == null) {
            result = new HashSet<String>();
        }
        Iterator<String> it = this.dataSource.iterator(pathPrefix);
        while (it.hasNext()) {
            String path = it.next();
            if (pathMatcher != null && !pathMatcher.reset(path).matches()) continue;
            result.add(path);
        }
        return result;
    }

    public Collection<String> getExtraPaths() {
        if (this.getDtdType() != DtdType.ldml) {
            return Collections.emptySet();
        }
        HashSet<String> toAddTo = new HashSet<String>(this.getRawExtraPaths());
        for (String path : this.iterableWithoutExtras()) {
            toAddTo.remove(path);
        }
        return toAddTo;
    }

    public Collection<String> getExtraPaths(String prefix, Collection<String> toAddTo) {
        if (this.getDtdType() != DtdType.ldml) {
            return Collections.emptySet();
        }
        for (String item : this.getRawExtraPaths()) {
            if (!item.startsWith(prefix) || this.dataSource.getValueAtPath(item) != null) continue;
            toAddTo.add(item);
        }
        return toAddTo;
    }

    public Set<String> getRawExtraPaths() {
        if (this.getDtdType() != DtdType.ldml) {
            return Collections.emptySet();
        }
        if (this.extraPaths == null) {
            this.extraPaths = ((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getRawExtraPathsPrivate())).build();
        }
        return this.extraPaths;
    }

    private List<String> getRawExtraPathsPrivate() {
        HashSet<String> toAddTo = new HashSet<String>();
        ExtraPaths.addConstant(toAddTo);
        ExtraPaths.addLocaleDependent(toAddTo, this.iterableWithoutExtras(), this.getLocaleID());
        return toAddTo.stream().map(String::intern).collect(Collectors.toList());
    }

    public String getCountPathWithFallback(String xpath, SupplementalDataInfo.PluralInfo.Count count, boolean winning) {
        Output<String> newPath;
        XPathParts parts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
        if (this.tryDefault(parts, "gender", newPath = new Output<String>())) {
            return (String)newPath.value;
        }
        if (this.tryDefault(parts, "case", newPath)) {
            return (String)newPath.value;
        }
        boolean isDisplayName = parts.containsElement("displayName");
        String actualCount = parts.getAttributeValue(-1, "count");
        if (actualCount != null) {
            String result;
            if (CldrUtility.DIGITS.containsAll(actualCount)) {
                try {
                    int item = Integer.parseInt(actualCount);
                    String locale = this.getLocaleID();
                    SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
                    PluralRules rules = sdi.getPluralRules(new ULocale(locale), PluralRules.PluralType.CARDINAL);
                    String keyword = rules.select(item);
                    SupplementalDataInfo.PluralInfo.Count itemCount = SupplementalDataInfo.PluralInfo.Count.valueOf(keyword);
                    result = this.getCountPathWithFallback2(parts, xpath, itemCount, winning);
                    if (result != null && this.isNotRoot(result)) {
                        return result;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((result = this.getCountPathWithFallback2(parts, xpath, count, winning)) != null && this.isNotRoot(result)) {
                return result;
            }
            if (count != SupplementalDataInfo.PluralInfo.Count.other && (result = this.getCountPathWithFallback2(parts, xpath, SupplementalDataInfo.PluralInfo.Count.other, winning)) != null && this.isNotRoot(result)) {
                return result;
            }
            if (isDisplayName) {
                result = this.getCountPathWithFallback2(parts, xpath, null, winning);
            }
            return result;
        }
        return null;
    }

    private boolean tryDefault(XPathParts parts, String attribute, Output<String> newPath) {
        String oldValue = parts.getAttributeValue(-1, attribute);
        if (oldValue != null) {
            parts.setAttribute(-1, attribute, null);
            newPath.value = parts.toString();
            if (this.dataSource.getValueAtPath((String)newPath.value) != null) {
                return true;
            }
        }
        return false;
    }

    private String getCountPathWithFallback2(XPathParts parts, String xpathWithNoCount, SupplementalDataInfo.PluralInfo.Count count, boolean winning) {
        parts.addAttribute("count", count == null ? null : count.toString());
        String newPath = parts.toString();
        if (!newPath.equals(xpathWithNoCount)) {
            String temp;
            if (winning && (temp = this.getWinningPath(newPath)) != null) {
                newPath = temp;
            }
            if (this.dataSource.getValueAtPath(newPath) != null) {
                return newPath;
            }
        }
        return null;
    }

    public String getFillInValue(String distinguishedPath) {
        String value;
        String winningPath = this.getWinningPath(distinguishedPath);
        if (this.isNotRoot(winningPath)) {
            return this.getStringValue(winningPath);
        }
        String fallbackPath = this.getFallbackPath(winningPath, true, true);
        if (fallbackPath != null && (value = this.getWinningValue(fallbackPath)) != null) {
            return value;
        }
        return this.getStringValue(winningPath);
    }

    public boolean isNotRoot(String distinguishedPath) {
        String source = this.getSourceLocaleID(distinguishedPath, null);
        return source != null && !source.equals("root") && !source.equals("code-fallback");
    }

    public boolean isAliasedAtTopLevel() {
        return this.iterator("//ldml/alias").hasNext();
    }

    public static Comparator<String> getComparator(DtdType dtdType) {
        if (dtdType == null) {
            return ldmlComparator;
        }
        switch (dtdType) {
            case ldml: 
            case ldmlICU: {
                return ldmlComparator;
            }
        }
        return DtdData.getInstance(dtdType).getDtdComparator(null);
    }

    public Comparator<String> getComparator() {
        return CLDRFile.getComparator(this.dtdType);
    }

    public DtdType getDtdType() {
        return this.dtdType != null ? this.dtdType : this.dataSource.getDtdType();
    }

    public DtdData getDtdData() {
        return this.dtdData != null ? this.dtdData : DtdData.getInstance(this.getDtdType());
    }

    public static MapComparator<String> getAttributeOrdering() {
        return DtdData.getInstance(DtdType.ldmlICU).getAttributeComparator();
    }

    public CLDRFile getUnresolved() {
        if (!this.isResolved()) {
            return this;
        }
        XMLSource source = this.dataSource.getUnresolving();
        return new CLDRFile(source);
    }

    public static Comparator<String> getAttributeValueComparator(String element, String attribute) {
        return DtdData.getAttributeValueComparator(DtdType.ldml, element, attribute);
    }

    public void setDtdType(DtdType dtdType) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dtdType = dtdType;
    }

    public void disableCaching() {
        this.dataSource.disableCaching();
    }

    public String getConstructedValue(String xpath) {
        if (this.isResolved() && GlossonymConstructor.pathIsEligible(xpath)) {
            return new GlossonymConstructor(this).getValue(xpath);
        }
        return null;
    }

    public LocaleStringProvider makeOverridingStringProvider(Map<String, String> pathAndValueOverrides) {
        return new OverridingStringProvider(pathAndValueOverrides);
    }

    public String getKeyName(String key) {
        String result;
        block1: {
            String alias;
            Relation<Row.R2<String, String>, String> toAliases;
            Set<String> aliases;
            result = this.getStringValue("//ldml/localeDisplayNames/keys/key[@type=\"" + key + "\"]");
            if (result != null || (aliases = (toAliases = SupplementalDataInfo.getInstance().getBcp47Aliases()).get(Row.of(key, ""))) == null) break block1;
            Iterator<String> iterator = aliases.iterator();
            while (iterator.hasNext() && (result = this.getStringValue("//ldml/localeDisplayNames/keys/key[@type=\"" + (alias = iterator.next()) + "\"]")) == null) {
            }
        }
        return result;
    }

    public String getKeyValueName(String key, String value) {
        String result = this.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"" + key + "\"][@type=\"" + value + "\"]");
        if (result == null) {
            Relation<Row.R2<String, String>, String> toAliases = SupplementalDataInfo.getInstance().getBcp47Aliases();
            Set<String> keyAliases = toAliases.get(Row.of(key, ""));
            Set<String> valueAliases = toAliases.get(Row.of(key, value));
            if (keyAliases != null || valueAliases != null) {
                if (keyAliases == null) {
                    keyAliases = Collections.singleton(key);
                }
                if (valueAliases == null) {
                    valueAliases = Collections.singleton(value);
                }
                for (String keyAlias : keyAliases) {
                    String valueAlias;
                    Iterator<String> iterator = valueAliases.iterator();
                    while (iterator.hasNext() && (result = this.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"" + keyAlias + "\"][@type=\"" + (valueAlias = iterator.next()) + "\"]")) == null) {
                    }
                }
            }
        }
        return result;
    }

    String getStringValueWithBaileyNotConstructed(String path) {
        Output<String> pathWhereFound = new Output<String>();
        String value = this.getStringValueWithBailey(path, pathWhereFound, null);
        if (value == null || "constructed".equals(pathWhereFound.toString())) {
            return null;
        }
        return value;
    }

    @Deprecated
    public String getName(int type, String code) {
        switch (type) {
            case 0: {
                return this.nameGetter.getNameFromTypeEnumCode(NameType.LANGUAGE, code);
            }
            case 1: {
                return this.nameGetter.getNameFromTypeEnumCode(NameType.SCRIPT, code);
            }
            case 2: {
                return this.nameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, code);
            }
        }
        throw new IllegalArgumentException("Unrecognized type");
    }

    @Deprecated
    public String getName(String code) {
        return this.nameGetter.getNameFromIdentifier(code);
    }

    @Deprecated
    public String getName(String type, String code) {
        if (!type.equals("territory")) {
            throw new IllegalArgumentException("First argument should be territory");
        }
        return this.nameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, code);
    }

    static {
        String[][] data = new String[][]{{"ldml", "version", GEN_VERSION}, {"version", "cldrVersion", "*"}, {"orientation", "characters", "left-to-right"}, {"orientation", "lines", "top-to-bottom"}, {"weekendStart", "time", "00:00"}, {"weekendEnd", "time", "24:00"}, {"dateFormat", "type", "standard"}, {"timeFormat", "type", "standard"}, {"dateTimeFormat", "type", "standard"}, {"decimalFormat", "type", "standard"}, {"scientificFormat", "type", "standard"}, {"percentFormat", "type", "standard"}, {"pattern", "type", "standard"}, {"currency", "type", "standard"}, {"transform", "visibility", "external"}, {"*", "_q", "*"}};
        Map tempmain = CLDRFile.asMap(data, true);
        defaultSuppressionMap = Collections.unmodifiableMap(tempmain);
        HACK_CASE_CLOSURE_SET = new UnicodeSet("[\u017f\u1e9b\ufb00\u1e9e{i\u0307}\u1f71\u1f73\u1f75\u1f77\u1f79\u1f7b\u1f7d\u1fbb\u1fbe\u1fc9\u1fcb\u1fd3\u1fdb\u1fe3\u1feb\u1ff9\u1ffb\u2126\u212a\u212b]").freeze();
        distinguishedXPath = new DistinguishedXPath();
    }

    public class OverridingStringProvider
    implements LocaleStringProvider {
        private final Map<String, String> pathAndValueOverrides;

        public OverridingStringProvider(Map<String, String> pathAndValueOverrides) {
            this.pathAndValueOverrides = pathAndValueOverrides;
        }

        @Override
        public String getStringValue(String xpath) {
            String value = this.pathAndValueOverrides.get(xpath);
            return value != null ? value : CLDRFile.this.getStringValue(xpath);
        }

        @Override
        public String getLocaleID() {
            return CLDRFile.this.getLocaleID();
        }

        @Override
        public String getSourceLocaleID(String xpath, Status status) {
            if (this.pathAndValueOverrides.containsKey(xpath)) {
                if (status != null) {
                    status.pathWhereFound = xpath;
                }
                return this.getLocaleID() + "-override";
            }
            return CLDRFile.this.getSourceLocaleID(xpath, status);
        }
    }

    public static class TestUser
    extends CLDRFile {
        Map<String, String> userOverrides = new HashMap<String, String>();

        public TestUser(CLDRFile baseFile, String user, boolean resolved) {
            super(resolved ? baseFile.dataSource : baseFile.dataSource.getUnresolving());
            if (!baseFile.isResolved()) {
                throw new IllegalArgumentException("baseFile must be resolved");
            }
            Relation<String, String> pathMap = Relation.of(new HashMap(), TreeSet.class, new WinningComparator(user));
            for (String path : baseFile) {
                String newPath = TestUser.getNondraftNonaltXPath(path);
                pathMap.put(newPath, path);
            }
            for (String path : pathMap.keySet()) {
                String winner = null;
                for (String rowPath : pathMap.getAll(path)) {
                    if (winner == null) {
                        winner = rowPath;
                        continue;
                    }
                    this.userOverrides.put(rowPath, winner);
                }
            }
        }

        @Override
        public String getWinningPath(String path) {
            String trial = this.userOverrides.get(path);
            if (trial != null) {
                return trial;
            }
            return path;
        }
    }

    static class WinningComparator
    implements Comparator<String> {
        String user;

        public WinningComparator(String user) {
            this.user = user;
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains(this.user)) {
                if (!o2.contains(this.user)) {
                    return -1;
                }
            } else if (o2.contains(this.user)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static enum WinningChoice {
        NORMAL,
        WINNING;

    }

    public static class Status {
        public String pathWhereFound;

        public String toString() {
            return this.pathWhereFound;
        }
    }

    private static class DistinguishedXPath {
        private static final Map<String, String> distinguishingMap = new ConcurrentHashMap<String, String>();
        private static final Map<String, String> normalizedPathMap = new ConcurrentHashMap<String, String>();

        private DistinguishedXPath() {
        }

        public static String stats() {
            return "distinguishingMap:" + distinguishingMap.size() + " normalizedPathMap:" + normalizedPathMap.size();
        }

        public static String getDistinguishingXPath(String xpath, String[] normalizedPath) {
            String result = distinguishingMap.get(xpath);
            if (result == null) {
                String element;
                int i;
                XPathParts distinguishingParts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
                DtdType type = distinguishingParts.getDtdData().dtdType;
                HashSet<String> toRemove = new HashSet<String>();
                String draft = null;
                String alt = null;
                Object references = "";
                for (i = 0; i < distinguishingParts.size() - 1; ++i) {
                    if (distinguishingParts.getAttributeCount(i) == 0) continue;
                    toRemove.clear();
                    Map<String, String> attributes = distinguishingParts.getAttributes(i);
                    Iterator<String> iterator = attributes.keySet().iterator();
                    while (iterator.hasNext()) {
                        String attribute;
                        switch (attribute = iterator.next()) {
                            case "draft": {
                                draft = attributes.get(attribute);
                                toRemove.add(attribute);
                                break;
                            }
                            case "alt": {
                                alt = attributes.get(attribute);
                                toRemove.add(attribute);
                                break;
                            }
                            case "references": {
                                if (!((String)references).isEmpty()) {
                                    references = (String)references + " ";
                                }
                                references = (String)references + attributes.get("references");
                                toRemove.add(attribute);
                            }
                        }
                    }
                    distinguishingParts.removeAttributes(i, toRemove);
                }
                if (draft != null || alt != null || !((String)references).isEmpty()) {
                    String newXPath;
                    int placementIndex = distinguishingParts.size() - 1;
                    while (true) {
                        element = distinguishingParts.getElement(placementIndex);
                        if (!DtdData.getInstance(type).isOrdered(element)) break;
                        --placementIndex;
                    }
                    if (draft != null) {
                        distinguishingParts.putAttributeValue(placementIndex, "draft", draft);
                    }
                    if (alt != null) {
                        distinguishingParts.putAttributeValue(placementIndex, "alt", alt);
                    }
                    if (!((String)references).isEmpty()) {
                        distinguishingParts.putAttributeValue(placementIndex, "references", (String)references);
                    }
                    if (!(newXPath = distinguishingParts.toString()).equals(xpath)) {
                        normalizedPathMap.put(xpath, newXPath);
                    }
                }
                for (i = 0; i < distinguishingParts.size(); ++i) {
                    if (distinguishingParts.getAttributeCount(i) == 0) continue;
                    element = distinguishingParts.getElement(i);
                    toRemove.clear();
                    for (String attribute : distinguishingParts.getAttributeKeys(i)) {
                        if (CLDRFile.isDistinguishing(type, element, attribute)) continue;
                        toRemove.add(attribute);
                    }
                    distinguishingParts.removeAttributes(i, toRemove);
                }
                result = distinguishingParts.toString();
                if (result.equals(xpath)) {
                    result = xpath;
                }
                distinguishingMap.put(xpath, result);
            }
            if (normalizedPath != null) {
                normalizedPath[0] = normalizedPathMap.get(xpath);
                if (normalizedPath[0] == null) {
                    normalizedPath[0] = xpath;
                }
            }
            return result;
        }

        public Map<String, String> getNonDistinguishingAttributes(String fullPath, Map<String, String> result, Set<String> skipList) {
            if (result == null) {
                result = new LinkedHashMap<String, String>();
            } else {
                result.clear();
            }
            XPathParts distinguishingParts = XPathParts.getFrozenInstance(fullPath);
            DtdType type = distinguishingParts.getDtdData().dtdType;
            for (int i = 0; i < distinguishingParts.size(); ++i) {
                String element = distinguishingParts.getElement(i);
                Map<String, String> attributes = distinguishingParts.getAttributes(i);
                for (String attribute : attributes.keySet()) {
                    if (CLDRFile.isDistinguishing(type, element, attribute) || skipList.contains(attribute)) continue;
                    result.put(attribute, attributes.get(attribute));
                }
            }
            return result;
        }

        static {
            distinguishingMap.put("", "");
        }
    }

    public static enum NumberingSystem {
        latin(null),
        defaultSystem("//ldml/numbers/defaultNumberingSystem"),
        nativeSystem("//ldml/numbers/otherNumberingSystems/native"),
        traditional("//ldml/numbers/otherNumberingSystems/traditional"),
        finance("//ldml/numbers/otherNumberingSystems/finance");

        public final String path;

        private NumberingSystem(String path) {
            this.path = path;
        }
    }

    public static enum ExemplarType {
        main,
        auxiliary,
        index,
        punctuation,
        numbers;


        public static ExemplarType fromString(String type) {
            return type.isEmpty() ? main : ExemplarType.valueOf(type);
        }
    }

    private static class MyDeclHandler
    implements XMLFileReader.AllHandler {
        private static final UnicodeSet whitespace = new UnicodeSet("[:whitespace:]");
        private final DraftStatus minimalDraftStatus;
        private static final boolean SHOW_START_END = false;
        private int commentStack;
        private boolean justPopped = false;
        private String lastChars = "";
        private String currentFullXPath = "/";
        private String comment = null;
        private Map<String, String> attributeOrder;
        private DtdData dtdData;
        private final CLDRFile target;
        private String lastActiveLeafNode;
        private String lastLeafNode;
        private int isSupplemental = -1;
        private final int[] orderedCounter = new int[30];
        private final String[] orderedString = new String[30];
        private int level = 0;
        private int overrideCount = 0;
        private Locator documentLocator = null;
        private static final Set<String> changedTypes = new HashSet<String>(Arrays.asList("abbreviationFallback", "default", "mapping", "measurementSystem", "preferenceOrdering"));
        Matcher draftMatcher = DRAFT_PATTERN.matcher("");
        static Pattern WHITESPACE_WITH_LF = PatternCache.get("\\s*\\u000a\\s*");
        Matcher whitespaceWithLf = WHITESPACE_WITH_LF.matcher("");
        static final UnicodeSet CONTROLS = new UnicodeSet("[:cc:]");

        MyDeclHandler(CLDRFile target, DraftStatus minimalDraftStatus) {
            this.target = target;
            this.minimalDraftStatus = minimalDraftStatus;
        }

        private String show(Attributes attributes) {
            if (attributes == null) {
                return "null";
            }
            Object result = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getQName(i);
                String value = attributes.getValue(i);
                result = (String)result + "[@" + attribute + "=\"" + value + "\"]";
            }
            return result;
        }

        private void push(String qName, Attributes attributes) {
            Log.logln(false, "push\t" + qName + "\t" + this.show(attributes));
            ++this.level;
            if (!qName.equals(this.orderedString[this.level])) {
                this.orderedString[this.level] = qName;
            }
            if (!this.lastChars.isEmpty()) {
                if (whitespace.containsAll(this.lastChars)) {
                    this.lastChars = "";
                } else {
                    throw new IllegalArgumentException("Must not have mixed content: " + qName + ", " + this.show(attributes) + ", Content: " + this.lastChars);
                }
            }
            this.currentFullXPath = this.currentFullXPath + "/" + qName;
            if (this.dtdData.isOrdered(qName)) {
                this.currentFullXPath = this.currentFullXPath + this.orderingAttribute();
            }
            if (attributes.getLength() > 0) {
                String value;
                this.attributeOrder.clear();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attribute = attributes.getQName(i);
                    value = attributes.getValue(i);
                    if (attribute.equals("cldrVersion") && qName.equals("version")) {
                        ((SimpleXMLSource)this.target.dataSource).setDtdVersionInfo(VersionInfo.getInstance(value));
                        continue;
                    }
                    this.putAndFixDeprecatedAttribute(qName, attribute, value);
                }
                for (String attribute : this.attributeOrder.keySet()) {
                    value = this.attributeOrder.get(attribute);
                    String both = "[@" + attribute + "=\"" + value + "\"]";
                    this.currentFullXPath = this.currentFullXPath + both;
                }
            }
            if (this.comment != null) {
                if (this.currentFullXPath.equals("//ldml") || this.currentFullXPath.equals("//supplementalData")) {
                    this.target.setInitialComment(this.comment);
                } else {
                    this.target.addComment(this.currentFullXPath, this.comment, XPathParts.Comments.CommentType.PREBLOCK);
                }
                this.comment = null;
            }
            this.justPopped = false;
            this.lastActiveLeafNode = null;
            Log.logln(false, "currentFullXPath\t" + this.currentFullXPath);
        }

        private String orderingAttribute() {
            int n = this.level;
            int n2 = this.orderedCounter[n];
            this.orderedCounter[n] = n2 + 1;
            return "[@_q=\"" + n2 + "\"]";
        }

        private void putAndFixDeprecatedAttribute(String element, String attribute, String value) {
            if (attribute.equals("draft")) {
                if (value.equals("true")) {
                    value = "approved";
                } else if (value.equals("false")) {
                    value = "unconfirmed";
                }
            } else if (attribute.equals("type") && changedTypes.contains(element) && this.isSupplemental < 1) {
                attribute = "choice";
            }
            this.attributeOrder.put(attribute, value);
        }

        private void addPath(String fullXPath, String value) {
            String former = this.target.getStringValue(fullXPath);
            if (former != null) {
                String formerPath = this.target.getFullXPath(fullXPath);
                if (!(former.equals(value) && fullXPath.equals(formerPath) || fullXPath.startsWith("//ldml/identity/version") || fullXPath.startsWith("//ldml/identity/generation"))) {
                    this.warnOnOverride(former, formerPath);
                }
            }
            value = this.trimWhitespaceSpecial(value);
            this.target.add(fullXPath, value).addSourceLocation(fullXPath, new XMLSource.SourceLocation(this.documentLocator));
        }

        private void pop(String qName) {
            Log.logln(false, "pop\t" + qName);
            --this.level;
            if (!this.lastChars.isEmpty() || !this.justPopped) {
                boolean acceptItem;
                boolean bl = acceptItem = this.minimalDraftStatus == DraftStatus.unconfirmed;
                if (!acceptItem) {
                    if (this.draftMatcher.reset(this.currentFullXPath).find()) {
                        DraftStatus foundStatus = DraftStatus.valueOf(this.draftMatcher.group(1));
                        if (this.minimalDraftStatus.compareTo(foundStatus) <= 0) {
                            acceptItem = true;
                        }
                    } else {
                        acceptItem = true;
                    }
                }
                if (acceptItem) {
                    boolean skipAdd = false;
                    if (this.currentFullXPath.startsWith("//ldml/layout/orientation")) {
                        XPathParts parts = XPathParts.getFrozenInstance(this.currentFullXPath);
                        String value = parts.getAttributeValue(-1, "characters");
                        if (value != null) {
                            this.addPath("//ldml/layout/orientation/characterOrder", value);
                            skipAdd = true;
                        }
                        if ((value = parts.getAttributeValue(-1, "lines")) != null) {
                            this.addPath("//ldml/layout/orientation/lineOrder", value);
                            skipAdd = true;
                        }
                    }
                    if (!skipAdd) {
                        this.addPath(this.currentFullXPath, this.lastChars);
                    }
                    this.lastLeafNode = this.lastActiveLeafNode = this.currentFullXPath;
                }
                this.lastChars = "";
            } else {
                Log.logln(false, "pop: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                if (this.comment != null) {
                    this.target.addComment(this.lastLeafNode, this.comment, XPathParts.Comments.CommentType.POSTBLOCK);
                    this.comment = null;
                }
            }
            this.currentFullXPath = MyDeclHandler.stripAfter(this.currentFullXPath, qName);
            this.justPopped = true;
        }

        private String trimWhitespaceSpecial(String source) {
            if (!source.contains("\n")) {
                return source;
            }
            source = this.whitespaceWithLf.reset(source).replaceAll("\n");
            return source;
        }

        private void warnOnOverride(String former, String formerPath) {
            String distinguishing = CLDRFile.getDistinguishingXPath(formerPath, null);
            System.out.println("\tERROR in " + this.target.getLocaleID() + ";\toverriding old value <" + former + "> at path " + distinguishing + "\twith\t<" + this.lastChars + ">\n\told fullpath: " + formerPath + "\n\tnew fullpath: " + this.currentFullXPath);
            ++this.overrideCount;
        }

        private static String stripAfter(String input, String qName) {
            int pos = MyDeclHandler.findLastSlash(input);
            if (qName != null && !input.substring(pos + 1).startsWith(qName)) {
                throw new IllegalArgumentException("Internal Error: should never get here.");
            }
            return input.substring(0, pos);
        }

        private static int findLastSlash(String input) {
            int braceStack = 0;
            char inQuote = '\u0000';
            block6: for (int i = input.length() - 1; i >= 0; --i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (inQuote == '\u0000') {
                            inQuote = ch;
                            continue block6;
                        }
                        if (inQuote != ch) continue block6;
                        inQuote = '\u0000';
                        continue block6;
                    }
                    case '/': {
                        if (inQuote != '\u0000' || braceStack != 0) continue block6;
                        return i;
                    }
                    case '[': {
                        if (inQuote != '\u0000') continue block6;
                        --braceStack;
                        continue block6;
                    }
                    case ']': {
                        if (inQuote != '\u0000') continue block6;
                        ++braceStack;
                    }
                }
            }
            return -1;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Log.logln(false, "startElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName + "\tattributes " + this.show(attributes));
            try {
                if (this.isSupplemental < 0) {
                    this.attributeOrder = new TreeMap<String, String>(this.dtdData.dtdType == DtdType.ldml ? CLDRFile.getAttributeOrdering() : this.dtdData.getAttributeComparator());
                    this.isSupplemental = this.target.dtdType == DtdType.ldml ? 0 : 1;
                }
                this.push(qName, attributes);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            Log.logln(false, "endElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName);
            this.pop(qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            try {
                String value = new String(ch, start, length);
                Log.logln(false, "characters:\t" + value);
                this.lastChars = this.lastChars + value;
                this.justPopped = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
            Log.logln(false, "startDTD name: " + name + ", publicId: " + publicId + ", systemId: " + systemId);
            ++this.commentStack;
            this.target.dtdType = DtdType.fromElement(name);
            this.target.dtdData = this.dtdData = DtdData.getInstance(this.target.dtdType);
        }

        @Override
        public void endDTD() {
            Log.logln(false, "endDTD");
            --this.commentStack;
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            String string = new String(ch, start, length);
            Log.logln(false, this.commentStack + " comment " + string);
            try {
                if (this.commentStack != 0) {
                    return;
                }
                String comment0 = this.trimWhitespaceSpecial(string).trim();
                if (this.lastActiveLeafNode != null) {
                    this.target.addComment(this.lastActiveLeafNode, comment0, XPathParts.Comments.CommentType.LINE);
                } else {
                    this.comment = this.comment == null ? comment0 : this.comment + "\n" + comment0;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\n') continue;
                Log.logln(false, "\\n: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                break;
            }
        }

        @Override
        public void startDocument() {
            Log.logln(false, "startDocument");
            this.commentStack = 0;
        }

        @Override
        public void endDocument() {
            Log.logln(false, "endDocument");
            try {
                if (this.comment != null) {
                    this.target.addComment(null, this.comment, XPathParts.Comments.CommentType.LINE);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void elementDecl(String name, String model) {
            Log.logln(false, "Attribute\t" + name + "\t" + model);
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) {
            Log.logln(false, "Attribute\t" + eName + "\t" + aName + "\t" + type + "\t" + mode + "\t" + value);
        }

        @Override
        public void internalEntityDecl(String name, String value) {
            Log.logln(false, "Internal Entity\t" + name + "\t" + value);
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) {
            Log.logln(false, "Internal Entity\t" + name + "\t" + publicId + "\t" + systemId);
        }

        @Override
        public void processingInstruction(String target, String data) {
            Log.logln(false, "processingInstruction: " + target + ", " + data);
        }

        @Override
        public void skippedEntity(String name) {
            Log.logln(false, "skippedEntity: " + name);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            Log.logln(false, "setDocumentLocator Locator " + String.valueOf(locator));
            this.documentLocator = locator;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            Log.logln(false, "startPrefixMapping prefix: " + prefix + ", uri: " + uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
            Log.logln(false, "endPrefixMapping prefix: " + prefix);
        }

        @Override
        public void startEntity(String name) {
            Log.logln(false, "startEntity name: " + name);
        }

        @Override
        public void endEntity(String name) {
            Log.logln(false, "endEntity name: " + name);
        }

        @Override
        public void startCDATA() {
            Log.logln(false, "startCDATA");
        }

        @Override
        public void endCDATA() {
            Log.logln(false, "endCDATA");
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Log.logln(true, "error: " + CLDRFile.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Log.logln(false, "fatalError: " + CLDRFile.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Log.logln(false, "warning: " + CLDRFile.showSAX(exception));
            throw exception;
        }
    }

    private static class FullIterable
    implements Iterable<String>,
    With.SimpleIterator<String> {
        private final CLDRFile file;
        private final Iterator<String> iteratorWithoutExtras;
        private Iterator<String> extraPaths;

        FullIterable(CLDRFile file) {
            this.file = file;
            this.iteratorWithoutExtras = file.iteratorWithoutExtras();
        }

        @Override
        public Iterator<String> iterator() {
            return With.toIterator(this);
        }

        @Override
        public String next() {
            if (this.iteratorWithoutExtras.hasNext()) {
                return this.iteratorWithoutExtras.next();
            }
            if (this.extraPaths == null) {
                this.extraPaths = this.file.getExtraPaths().iterator();
            }
            if (this.extraPaths.hasNext()) {
                return this.extraPaths.next();
            }
            return null;
        }
    }

    public static interface RetentionTest {
        public Retention getRetention(String var1);

        public static enum Retention {
            RETAIN,
            REMOVE,
            RETAIN_IF_DIFFERENT;

        }
    }

    static final class SimpleAltPicker
    implements Transform<String, String> {
        public final String alt;

        public SimpleAltPicker(String alt) {
            this.alt = alt;
        }

        @Override
        public String transform(String source) {
            return this.alt;
        }
    }

    public static enum DraftStatus {
        unconfirmed,
        provisional,
        contributed,
        approved;


        public static DraftStatus forString(String string) {
            return string == null ? approved : DraftStatus.valueOf(string.toLowerCase(Locale.ENGLISH));
        }

        public static DraftStatus forXpath(String xpath) {
            String status = XPathParts.getFrozenInstance(xpath).getAttributeValue(-1, "draft");
            return DraftStatus.forString(status);
        }

        public String asXpath() {
            if (this == approved) {
                return "";
            }
            return "[@draft=\"" + this.name() + "\"]";
        }

        public String updateXPath(String fullXpath) {
            XPathParts xpp = XPathParts.getFrozenInstance(fullXpath).cloneAsThawed();
            String oldDraft = xpp.getAttributeValue(-1, "draft");
            if (DraftStatus.forString(oldDraft) == this) {
                return fullXpath;
            }
            if (this == approved) {
                xpp.removeAttribute(-1, "draft");
            } else {
                xpp.setAttribute(-1, "draft", this.name());
            }
            return xpp.toString();
        }
    }
}

