/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CharSource;

public class CharUtilities {
    private static final char[] utf16Fixup = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2000', '\uf800', '\uf800', '\uf800', '\uf800'};

    public static int compare(CharSource text1, CharSource text2) {
        char cp2;
        char cp1;
        int i1 = 0;
        int i2 = 0;
        do {
            if (!text1.hasCharAt(i1)) {
                if (text2.hasCharAt(i2)) {
                    return 0;
                }
                return -1;
            }
            if (!text2.hasCharAt(i2)) continue;
            return 1;
        } while ((cp1 = text1.charAt(i1++)) == (cp2 = text2.charAt(i2++)));
        return cp1 + utf16Fixup[cp1 >> 11] - (cp2 + utf16Fixup[cp2 >> 11]);
    }

    public static int compare(CharSequence text1, CharSequence text2) {
        char cp2;
        char cp1;
        int i1 = 0;
        int i2 = 0;
        do {
            if (i1 >= text1.length()) {
                if (i2 >= text2.length()) {
                    return 0;
                }
                return -1;
            }
            if (i2 < text2.length()) continue;
            return 1;
        } while ((cp1 = text1.charAt(i1++)) == (cp2 = text2.charAt(i2++)));
        return cp1 + utf16Fixup[cp1 >> 11] - (cp2 + utf16Fixup[cp2 >> 11]);
    }

    public static Set<String> internImmutableSet(Collection<String> s2) {
        return s2.stream().map(String::intern).collect(Collectors.toUnmodifiableSet());
    }

    public static class CharSourceWrapper<T extends CharSequence>
    implements CharSource {
        protected T source;

        public CharSourceWrapper(T source) {
            this.source = source;
        }

        @Override
        public boolean hasCharAt(int index) {
            return index < this.source.length();
        }

        @Override
        public char charAt(int index) {
            return this.source.charAt(index);
        }

        @Override
        public int toSourceOffset(int index) {
            return index;
        }

        @Override
        public CharSource sublist(int start, int end) {
            return new CharSourceWrapper<CharSequence>(this.source.subSequence(start, end));
        }

        @Override
        public CharSource sublist(int start) {
            return new CharSourceWrapper<CharSequence>(this.source.subSequence(start, this.source.length()));
        }

        @Override
        public int getKnownLength() {
            return this.source.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.source.subSequence(start, end);
        }

        public String toString() {
            return this.source.toString();
        }

        public CharSequence sourceSubSequence(int start, int end) {
            return this.source.subSequence(this.toSourceOffset(start), this.toSourceOffset(end));
        }

        @Override
        public int fromSourceOffset(int index) {
            return index;
        }

        @Override
        public CharSource setStart(int index) {
            return this;
        }

        @Override
        public int getStart() {
            return 0;
        }
    }
}

