/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.PreferredAndAllowedHour;
import org.unicode.cldr.util.RbnfData;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CoreCoverageInfo {
    private static final CLDRConfig config = CLDRConfig.getInstance();
    private static final String CLDR_BASE_DIRECTORY = config.getCldrBaseDirectory().toString();
    private static final SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    private static final LikelySubtags ls = new LikelySubtags();
    static UnicodeSet RTL = new UnicodeSet("[[:bc=R:][:bc=AL:]]").freeze();
    private static final String[][] ROMANIZATION_PATHS = new String[][]{{"", "-Latin"}, {"", "-Latin-BGN"}, {"Latin-", ""}};
    private static final Relation SCRIPT_NAMES = Relation.of(new HashMap(), HashSet.class);
    private static final Relation<SpecialDir, String> SPECIAL_FILES;

    public static Set<CoreItems> getCoreCoverageInfo(CLDRFile resolvedFile, Multimap<CoreItems, String> detailedErrors) {
        GrammarInfo grammarInfo;
        Map<String, PreferredAndAllowedHour> timeData;
        ScriptMetadata.Info scriptData;
        detailedErrors.clear();
        if (!resolvedFile.isResolved()) {
            throw new IllegalArgumentException("Don't call on unresolved locales: " + resolvedFile.getLocaleID());
        }
        CLDRFile file = resolvedFile.getUnresolved();
        String locale = file.getLocaleID();
        LanguageTagParser ltp = new LanguageTagParser();
        locale = ltp.set(locale).getLanguageScript();
        String baseLanguage = ltp.getLanguage();
        String script = ltp.getScript();
        String region = ltp.getRegion();
        UnicodeSet main = file.getExemplarSet(CLDRFile.ExemplarType.main, null);
        boolean isRtl = main.containsSome(RTL);
        String path = "//ldml/layout/orientation/characterOrder";
        String value = file.getStringValue(path);
        if ("right-to-left".equals(value) != isRtl) {
            detailedErrors.put(CoreItems.orientation, path);
        }
        if (!sdi.getPluralLocales(SupplementalDataInfo.PluralType.cardinal).contains(baseLanguage)) {
            detailedErrors.put(CoreItems.plurals, "//supplementalData/plurals[@type=\"cardinal\"]/pluralRules[@locales=\"" + locale + "\"]/pluralRule[@count=\"other\"]");
        }
        if (!sdi.getPluralLocales(SupplementalDataInfo.PluralType.ordinal).contains(baseLanguage)) {
            detailedErrors.put(CoreItems.ordinals, "//supplementalData/plurals[@type=\"ordinal\"]/pluralRules[@locales=\"" + locale + "\"]/pluralRule[@count=\"other\"]");
        }
        CoreCoverageInfo.rbnfHelper(baseLanguage, "spellout-cardinal", detailedErrors, CoreItems.spellout_cardinal);
        CoreCoverageInfo.rbnfHelper(baseLanguage, "spellout-ordinal", detailedErrors, CoreItems.spellout_ordinal);
        CoreCoverageInfo.rbnfHelper(baseLanguage, "digits-ordinal", detailedErrors, CoreItems.digits_ordinals);
        String defaultContent = sdi.getDefaultContentLocale(locale);
        if (defaultContent == null) {
            detailedErrors.put(CoreItems.default_content, "//supplementalData/supplementalMetadata/defaultContent");
        }
        String max = ls.maximize(locale);
        String maxLangScript = "";
        String maxScript = "";
        String maxRegion = "";
        if (max != null) {
            ltp.set(max);
            maxLangScript = ltp.getLanguageScript();
            maxScript = ltp.getScript();
            maxRegion = ltp.getRegion();
            if (maxRegion.equals("ZZ") || maxRegion.equals("001") && Iso639Data.getType(baseLanguage) != Iso639Data.Type.Constructed) {
                maxRegion = "";
            }
        }
        if (maxScript.isEmpty() || maxRegion.isEmpty()) {
            detailedErrors.put(CoreItems.likely_subtags, "//supplementalData/likelySubtags");
        }
        String bestScript = script.isEmpty() ? maxScript : script;
        String bestRegion = region.isEmpty() ? maxRegion : region;
        String languagePath = NameType.LANGUAGE.getKeyPath(baseLanguage);
        String languageName = resolvedFile.getStringValue(languagePath);
        if (languageName == null) {
            detailedErrors.put(CoreItems.own_language, languagePath);
        } else {
            String localeWhereFound = resolvedFile.getSourceLocaleID(languagePath, null);
            if ("root".equals(localeWhereFound) || "code-fallback".equals(localeWhereFound)) {
                detailedErrors.put(CoreItems.own_language, languagePath);
            }
        }
        if (bestRegion.isEmpty()) {
            detailedErrors.put(CoreItems.own_regions, "//supplementalData/likelySubtags");
        } else {
            String regionPath = NameType.TERRITORY.getKeyPath(bestRegion);
            String regionName = file.getStringValue(regionPath);
            if (regionName == null) {
                detailedErrors.put(CoreItems.own_regions, regionPath);
            } else {
                String localeWhereFound = resolvedFile.getSourceLocaleID(regionPath, null);
                if ("root".equals(localeWhereFound) || "code-fallback".equals(localeWhereFound)) {
                    detailedErrors.put(CoreItems.own_regions, regionPath);
                }
            }
        }
        Set<String> territories = sdi.getTerritoriesForPopulationData(locale);
        if (territories == null) {
            territories = sdi.getTerritoriesForPopulationData(baseLanguage);
        }
        if (territories == null && maxLangScript != null) {
            territories = sdi.getTerritoriesForPopulationData(maxLangScript);
        }
        if (territories == null || territories.isEmpty()) {
            detailedErrors.put(CoreItems.country_data, "//supplementalData/territoryInfo");
            sdi.getTerritoriesForPopulationData(locale);
        }
        if (!bestScript.equals("Latn")) {
            boolean found = false;
            Set<String> scriptLongCodes = CoreCoverageInfo.getScriptNames(bestScript);
            if (scriptLongCodes != null) {
                LinkedHashSet<String> debugErrors = new LinkedHashSet<String>();
                block0: for (String scriptLongCode : scriptLongCodes) {
                    for (String[] pair : ROMANIZATION_PATHS) {
                        String filename = pair[0] + scriptLongCode + pair[1];
                        if (CoreCoverageInfo.hasFile(SpecialDir.transforms, filename)) {
                            found = true;
                            continue block0;
                        }
                        debugErrors.add(script);
                    }
                }
            }
            if (!found) {
                detailedErrors.put(CoreItems.romanization, "//supplementalData/transforms/transform[@source=\"und-" + script + "\"][@target=\"und-Latn\"]");
            }
        }
        if ((scriptData = ScriptMetadata.getInfo(bestScript)) != null && scriptData.hasCase == ScriptMetadata.Trinary.YES && !CoreCoverageInfo.hasFile(SpecialDir.casing, baseLanguage)) {
            detailedErrors.put(CoreItems.casing, "//ldml/metadata/casingData/casingItem[@type=\"*\"]");
        }
        if (!CoreCoverageInfo.hasFile(SpecialDir.collation, baseLanguage)) {
            detailedErrors.put(CoreItems.collation, "//ldml/collations/collation[@type=\"standard\"]");
        }
        if ((timeData = sdi.getTimeData()).get(bestRegion) == null) {
            detailedErrors.put(CoreItems.time_cycle, "//supplementalData/timeData/hours");
        }
        if ((grammarInfo = sdi.getGrammarInfo(locale)) == null) {
            detailedErrors.put(CoreItems.grammar, "//supplementalData/grammaticalData/grammaticalFeatures");
        }
        return ImmutableSet.copyOf(Sets.difference(CoreItems.ALL, detailedErrors.keySet()));
    }

    private static void rbnfHelper(String stringLocale, String rbnfType, Multimap<CoreItems, String> detailedErrors, CoreItems coreItems) {
        for (CLDRLocale cldrLocale = CLDRLocale.getInstance(stringLocale); cldrLocale != null && !cldrLocale.equals(CLDRLocale.ROOT); cldrLocale = cldrLocale.getParent()) {
            Multimap<String, String> typeInfo = RbnfData.INSTANCE.getLocaleToTypesToSubtypes().get(cldrLocale.toString());
            if (typeInfo == null || !typeInfo.containsKey(rbnfType)) continue;
            return;
        }
        detailedErrors.put(coreItems, RbnfData.INSTANCE.getPath(rbnfType));
    }

    private static Set<String> getScriptNames(String script) {
        Set<String> result = SCRIPT_NAMES.get(script);
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        try {
            String name = UScript.getName(UScript.getCodeFromName(script));
            result.add(name);
            result.add(script);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean hasFile(SpecialDir type, String filename) {
        return SPECIAL_FILES.get((Object)type).contains(filename);
    }

    static {
        SCRIPT_NAMES.putAll("Arab", Arrays.asList("Arabic", "Arab"));
        SCRIPT_NAMES.putAll("Jpan", Arrays.asList("Jpan", "Han"));
        SCRIPT_NAMES.putAll("Hant", Arrays.asList("Hant", "Han"));
        SCRIPT_NAMES.putAll("Hans", Arrays.asList("Hans", "Han"));
        SCRIPT_NAMES.putAll("Kore", Arrays.asList("Hang", "Hangul"));
        SCRIPT_NAMES.freeze();
        SPECIAL_FILES = Relation.of(new EnumMap(SpecialDir.class), HashSet.class);
        for (SpecialDir dir : SpecialDir.values()) {
            File realDir = new File(CLDR_BASE_DIRECTORY + "/common/" + String.valueOf((Object)dir));
            for (String s2 : realDir.list()) {
                if (s2.endsWith(".xml")) {
                    s2 = s2.substring(0, s2.length() - 4);
                }
                SPECIAL_FILES.put(dir, s2);
            }
        }
    }

    private static enum SpecialDir {
        transforms,
        collation,
        casing;

    }

    public static enum CoreItems {
        default_content(Level.CORE),
        likely_subtags(Level.CORE),
        country_data(Level.CORE),
        orientation(Level.CORE),
        time_cycle(Level.CORE),
        own_language(Level.BASIC),
        own_regions(Level.BASIC),
        casing(Level.MODERATE, Sublevel.start),
        plurals(Level.MODERATE, Sublevel.start),
        collation(Level.MODERATE),
        spellout_cardinal(Level.MODERN),
        spellout_ordinal(Level.MODERN),
        digits_ordinals(Level.MODERN),
        ordinals(Level.MODERN),
        romanization(Level.MODERN),
        grammar(Level.MODERN, Sublevel.start);

        public static final Set<CoreItems> ALL;
        public static final Multimap<Level, CoreItems> LEVEL_TO_ITEMS;
        public final Level desiredLevel;
        public final Sublevel sublevel;

        private CoreItems() {
            this(Level.CORE);
        }

        private CoreItems(Level desiredLevel) {
            this(desiredLevel, Sublevel.end);
        }

        private CoreItems(Level desiredLevel, Sublevel sublevel) {
            this.desiredLevel = desiredLevel;
            this.sublevel = sublevel;
        }

        public String toString() {
            return this.desiredLevel.getAbbreviation() + "\u00a0" + this.name();
        }

        static {
            ALL = ImmutableSet.copyOf(CoreItems.values());
            TreeMultimap _levelToItems = TreeMultimap.create();
            ALL.forEach(x -> {
                for (Level level : Level.values()) {
                    if (level.compareTo(x.desiredLevel) > 0) continue;
                    _levelToItems.put(x.desiredLevel, x);
                }
            });
            LEVEL_TO_ITEMS = ImmutableMultimap.copyOf(_levelToItems);
        }
    }

    public static enum Sublevel {
        start,
        end;

    }
}

