/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.With;

public class FileReaders {
    public static BufferedReader openFile(Class<?> class1, String file) {
        return FileReaders.openFile(class1, file, StandardCharsets.UTF_8);
    }

    public static BufferedReader openFile(Class<?> class1, String file, Charset charset) {
        try {
            InputStream resourceAsStream = class1.getResourceAsStream(file);
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            InputStreamReader reader = new InputStreamReader(resourceAsStream, charset);
            BufferedReader bufferedReader = new BufferedReader(reader, 65536);
            return bufferedReader;
        }
        catch (Exception e) {
            String className = class1 == null ? null : class1.getCanonicalName();
            String normalizedPath = null;
            try {
                String relativeFileName = FileReaders.getRelativeFileName(class1, "../util/");
                normalizedPath = PathUtilities.getNormalizedPathString(relativeFileName, new String[0]);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Couldn't open file: " + file + "; relative to class: " + className, e);
            }
            throw new IllegalArgumentException("Couldn't open file " + file + "; in path " + normalizedPath + "; relative to class: " + className, e);
        }
    }

    public static BufferedReader openFile(String directory, String file, Charset charset) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(directory, file)), charset));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BufferedReader openFile(String directory, String file) {
        return FileReaders.openFile(directory, file, StandardCharsets.UTF_8);
    }

    public static String getRelativeFileName(Class<?> class1, String filename) {
        URL resource = class1.getResource(filename);
        String resourceString = resource.toString();
        if (resourceString.startsWith("file:")) {
            return resourceString.substring(5);
        }
        if (resourceString.startsWith("jar:file:")) {
            return resourceString.substring(9);
        }
        if (resourceString.startsWith("wsjar:file:")) {
            return resourceString.substring(11);
        }
        throw new IllegalArgumentException("File not found: " + resourceString);
    }

    public static class ReadLineSimpleIterator
    implements With.SimpleIterator<String> {
        final BufferedReader bufferedReader;

        public ReadLineSimpleIterator(BufferedReader bufferedReader) {
            this.bufferedReader = bufferedReader;
        }

        @Override
        public String next() {
            try {
                return this.bufferedReader.readLine();
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
    }
}

