/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

class LocalesTxtReader {
    Map<Organization, Map<String, Level>> platform_locale_level = null;
    Map<Organization, Relation<Level, String>> platform_level_locale = null;
    Map<String, Map<String, String>> platform_locale_levelString = null;
    Map<Organization, Map<String, Integer>> organization_locale_weight = null;
    Map<Organization, Map<String, Set<String>>> organization_locale_match = null;
    public static final String DEFAULT_NAME = "Locales.txt";

    public LocalesTxtReader read(StandardCodes sc) {
        LocalesTxtReader localesTxtReader;
        block8: {
            BufferedReader lstreg = CldrUtility.getUTF8Data(DEFAULT_NAME);
            try {
                localesTxtReader = this.read(sc, lstreg);
                if (lstreg == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lstreg != null) {
                        try {
                            lstreg.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ICUUncheckedIOException("Internal Error reading Locales.txt", e);
                }
            }
            lstreg.close();
        }
        return localesTxtReader;
    }

    public LocalesTxtReader read(StandardCodes sc, BufferedReader lstreg) {
        LocaleIDParser parser = new LocaleIDParser();
        this.platform_locale_level = new EnumMap<Organization, Map<String, Level>>(Organization.class);
        this.organization_locale_weight = new EnumMap<Organization, Map<String, Integer>>(Organization.class);
        this.organization_locale_match = new EnumMap<Organization, Map<String, Set<String>>>(Organization.class);
        SupplementalDataInfo sd = SupplementalDataInfo.getInstance();
        Set<String> defaultContentLocales = sd.getDefaultContentLocales();
        try {
            while (true) {
                Map<String, Level> locale_status;
                Level status;
                Organization organization;
                Integer weight = null;
                String pathMatch = null;
                String line = lstreg.readLine();
                if (line == null) break;
                int commentPos = line.indexOf(35);
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).length() == 0) continue;
                List<String> stuff = CldrUtility.splitList(line, ';', true);
                try {
                    organization = Organization.fromString(stuff.get(0));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid organization in Locales.txt: " + line);
                }
                String localePart = stuff.get(1).trim();
                List<String> localeStuff = CldrUtility.splitList(localePart, ' ', true);
                TreeSet<String> locales = new TreeSet<String>();
                for (String entry : localeStuff) {
                    if (entry.startsWith("@")) {
                        String atCommand;
                        List<String> kwStuff = CldrUtility.splitList(entry, '=', true);
                        if (kwStuff.size() > 2 || kwStuff.size() < 1) {
                            throw new IllegalArgumentException("Invalid @-command " + entry + " in Locales.txt: " + line);
                        }
                        switch (atCommand = kwStuff.get(0)) {
                            case "@weight": {
                                weight = Integer.parseInt(kwStuff.get(1));
                                break;
                            }
                            case "@pathMatch": {
                                pathMatch = kwStuff.get(1);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown @-command " + atCommand + " in Locales.txt: " + line);
                            }
                        }
                        continue;
                    }
                    locales.add(entry);
                }
                if (locales.size() != 1) {
                    throw new IllegalArgumentException("Expected one locale entry in Locales.txt but got " + locales.size() + ": " + line);
                }
                String locale = (String)locales.iterator().next();
                if (!locale.equals("*")) {
                    parser.set(locale);
                    String valid = sc.validate(parser);
                    if (valid.length() != 0) {
                        throw new IllegalArgumentException("Invalid locale in Locales.txt: " + line);
                    }
                    locale = parser.toString();
                    if (defaultContentLocales.contains(locale)) {
                        throw new IllegalArgumentException("Cannot have default content locale in Locales.txt: " + line);
                    }
                }
                if ((status = Level.get(stuff.get(2))) == Level.UNDETERMINED) {
                    System.out.println("Warning: Level unknown on: " + line);
                }
                if ((locale_status = this.platform_locale_level.get((Object)organization)) == null) {
                    locale_status = new TreeMap<String, Level>();
                    this.platform_locale_level.put(organization, locale_status);
                }
                locale_status.put(locale, status);
                if (weight != null) {
                    this.organization_locale_weight.computeIfAbsent(organization, ignored -> new TreeMap()).put(locale, weight);
                }
                if (pathMatch == null) continue;
                this.organization_locale_match.computeIfAbsent(organization, ignored -> new TreeMap()).put(locale, ImmutableSet.copyOf(pathMatch.split(",")));
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Internal Error", e);
        }
        this.platform_locale_levelString = new TreeMap<String, Map<String, String>>();
        this.platform_level_locale = new EnumMap<Organization, Relation<Level, String>>(Organization.class);
        for (Organization platform : this.platform_locale_level.keySet()) {
            TreeMap<String, String> locale_levelString = new TreeMap<String, String>();
            this.platform_locale_levelString.put(platform.toString(), locale_levelString);
            Map<String, Level> locale_level = this.platform_locale_level.get((Object)platform);
            for (String locale : locale_level.keySet()) {
                locale_levelString.put(locale, locale_level.get(locale).toString());
            }
            Relation<Level, String> level_locale = Relation.of(new EnumMap(Level.class), HashSet.class);
            level_locale.addAllInverted(locale_level).freeze();
            this.platform_level_locale.put(platform, level_locale);
        }
        CldrUtility.protectCollection(this.platform_level_locale);
        this.platform_locale_level = CldrUtility.protectCollection(this.platform_locale_level);
        this.platform_locale_levelString = CldrUtility.protectCollection(this.platform_locale_levelString);
        return this;
    }
}

