/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.Transform;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;

public class NameGetter {
    private final CLDRFile cldrFile;
    private static final String GETNAME_LOCALE_SEPARATOR_PATH = "//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator";
    private static final String GETNAME_LOCALE_PATTERN_PATH = "//ldml/localeDisplayNames/localeDisplayPattern/localePattern";
    private static final String GETNAME_LOCALE_KEY_TYPE_PATTERN_PATH = "//ldml/localeDisplayNames/localeDisplayPattern/localeKeyTypePattern";
    private static final Joiner JOIN_HYPHEN = Joiner.on('-');
    private static final Joiner JOIN_UNDERBAR = Joiner.on('_');
    static final Pattern CLEAN_DESCRIPTION = Pattern.compile("([^(\\[]*)[(\\[].*");
    static final Splitter DESCRIPTION_SEP = Splitter.on('\u25aa');

    public NameGetter(CLDRFile cldrFile) {
        if (cldrFile == null) {
            throw new IllegalArgumentException("NameGetter must have non-null CLDRFile");
        }
        this.cldrFile = cldrFile;
    }

    public String getNameFromTypeEnumCode(NameType type, String code) {
        return this.getNameFromTypeCodeTransformPaths(type, code, null, null);
    }

    public String getNameFromTypeCodeAltpicker(NameType type, String code, Transform<String, String> altPicker) {
        return this.getNameFromTypeCodeTransformPaths(type, code, altPicker, null);
    }

    public synchronized String getNameFromIdentifier(String localeOrTZID) {
        return this.getNameFromIdentifierOpt(localeOrTZID, NameOpt.DEFAULT);
    }

    public String getNameFromIdentifierCompoundOnly(String localeOrTZID) {
        return this.getNameFromIdentifierOpt(localeOrTZID, NameOpt.COMPOUND_ONLY);
    }

    public synchronized String getNameFromIdentifierOpt(String localeOrTZID, NameOpt nameOpt) {
        return this.getNameFromIdentifierOptAlt(localeOrTZID, nameOpt, null);
    }

    public String getNameFromParserOpt(LanguageTagParser lparser, NameOpt nameOpt) {
        return this.getNameFromOtherThings(lparser, nameOpt, null, this.cldrFile.getWinningValueWithBailey(GETNAME_LOCALE_KEY_TYPE_PATTERN_PATH), this.cldrFile.getWinningValueWithBailey(GETNAME_LOCALE_PATTERN_PATH), this.cldrFile.getWinningValueWithBailey(GETNAME_LOCALE_SEPARATOR_PATH), null);
    }

    public synchronized String getNameFromIdentifierEtc(String localeOrTZID, NameOpt nameOpt, String localeKeyTypePattern, String localePattern, String localeSeparator) {
        return this.getNameFromManyThings(localeOrTZID, nameOpt, localeKeyTypePattern, localePattern, localeSeparator, null, null);
    }

    public synchronized String getNameFromIdentifierOptAlt(String localeOrTZID, NameOpt nameOpt, Transform<String, String> altPicker) {
        return this.getNameFromIdentifierOptAltPaths(localeOrTZID, nameOpt, altPicker, null);
    }

    public synchronized String getNameFromIdentifierOptAltPaths(String localeOrTZID, NameOpt nameOpt, Transform<String, String> altPicker, Set<String> paths) {
        return this.getNameFromManyThings(localeOrTZID, nameOpt, this.cldrFile.getWinningValueWithBailey(GETNAME_LOCALE_KEY_TYPE_PATTERN_PATH), this.cldrFile.getWinningValueWithBailey(GETNAME_LOCALE_PATTERN_PATH), this.cldrFile.getWinningValueWithBailey(GETNAME_LOCALE_SEPARATOR_PATH), altPicker, paths);
    }

    private synchronized String getNameFromManyThings(String localeOrTZID, NameOpt nameOpt, String localeKeyTypePattern, String localePattern, String localeSeparator, Transform<String, String> altPicker, Set<String> paths) {
        boolean isCompound;
        String name;
        if (localePattern == null) {
            localePattern = "{0} ({1})";
        }
        String string = name = (isCompound = localeOrTZID.contains("_")) && nameOpt == NameOpt.COMPOUND_ONLY ? null : this.getNameFromTypeCodeTransformPaths(NameType.LANGUAGE, localeOrTZID, altPicker, paths);
        if (name != null && !name.contains("_") && !name.contains("-")) {
            name = NameGetter.replaceBracketsForName(name);
            return name;
        }
        LanguageTagParser lparser = new LanguageTagParser().set(localeOrTZID);
        return this.getNameFromOtherThings(lparser, nameOpt, altPicker, localeKeyTypePattern, localePattern, localeSeparator, paths);
    }

    private String getNameFromOtherThings(LanguageTagParser lparser, NameOpt nameOpt, Transform<String, String> altPicker, String localeKeyTypePattern, String localePattern, String localeSeparator, Set<String> paths) {
        String name;
        String original;
        boolean haveScript = false;
        boolean haveRegion = false;
        if (nameOpt == NameOpt.COMPOUND_ONLY) {
            original = lparser.getLanguage();
            name = this.getNameFromTypeCodeTransformPaths(NameType.LANGUAGE, original, altPicker, paths);
            if (name == null) {
                name = original;
            }
        } else {
            String x = lparser.toString(LanguageTagParser.LANGUAGE_SCRIPT_REGION);
            name = this.getNameFromTypeCodeTransformPaths(NameType.LANGUAGE, x, altPicker, paths);
            if (name != null) {
                haveRegion = true;
                haveScript = true;
            } else {
                name = this.getNameFromTypeCodeTransformPaths(NameType.LANGUAGE, lparser.toString(LanguageTagParser.LANGUAGE_SCRIPT), altPicker, paths);
                if (name != null) {
                    haveScript = true;
                } else {
                    name = this.getNameFromTypeCodeTransformPaths(NameType.LANGUAGE, lparser.toString(LanguageTagParser.LANGUAGE_REGION), altPicker, paths);
                    if (name != null) {
                        haveRegion = true;
                    } else {
                        original = lparser.getLanguage();
                        name = this.getNameFromTypeCodeTransformPaths(NameType.LANGUAGE, original, altPicker, paths);
                        if (name == null) {
                            name = original;
                        }
                    }
                }
            }
        }
        name = NameGetter.replaceBracketsForName(name);
        String extras = "";
        if (!haveScript) {
            extras = this.addDisplayName(lparser.getScript(), NameType.SCRIPT, localeSeparator, extras, altPicker, paths);
        }
        if (!haveRegion) {
            extras = this.addDisplayName(lparser.getRegion(), NameType.TERRITORY, localeSeparator, extras, altPicker, paths);
        }
        List<String> variants = lparser.getVariants();
        for (String string : variants) {
            extras = this.addDisplayName(string, NameType.VARIANT, localeSeparator, extras, altPicker, paths);
        }
        for (Map.Entry entry : lparser.getLocaleExtensionsDetailed().entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("h0")) continue;
            List keyValue = (List)entry.getValue();
            String oldFormatType = (key.equals("ca") ? JOIN_HYPHEN : JOIN_UNDERBAR).join(keyValue);
            String value = this.cldrFile.getKeyValueName(key, oldFormatType);
            if (value == null) {
                String kname = this.cldrFile.getKeyName(key);
                if (kname == null) {
                    kname = key;
                }
                switch (key) {
                    case "t": {
                        List<String> hybrid = lparser.getLocaleExtensionsDetailed().get("h0");
                        if (hybrid != null) {
                            kname = this.cldrFile.getKeyValueName("h0", JOIN_UNDERBAR.join(hybrid));
                        }
                        oldFormatType = this.getNameFromIdentifier(oldFormatType);
                        break;
                    }
                    case "cu": {
                        oldFormatType = this.getNameFromTypeCodeTransformPaths(NameType.CURRENCY_SYMBOL, oldFormatType.toUpperCase(Locale.ROOT), null, paths);
                        break;
                    }
                    case "tz": {
                        if (paths != null) {
                            throw new IllegalArgumentException("Error: getName(\u2026) with paths doesn't handle timezones.");
                        }
                        oldFormatType = this.getTZName(oldFormatType);
                        break;
                    }
                    case "kr": {
                        oldFormatType = this.getReorderName(localeSeparator, keyValue, paths);
                        break;
                    }
                    case "rg": 
                    case "sd": {
                        oldFormatType = this.getNameFromTypeCodeTransformPaths(NameType.SUBDIVISION, oldFormatType, null, paths);
                        break;
                    }
                    default: {
                        oldFormatType = JOIN_HYPHEN.join(keyValue);
                    }
                }
                value = MessageFormat.format(localeKeyTypePattern, kname, oldFormatType);
                if (paths != null) {
                    paths.add(GETNAME_LOCALE_KEY_TYPE_PATTERN_PATH);
                }
            }
            value = NameGetter.replaceBracketsForName(value);
            if (paths != null && !extras.isEmpty()) {
                paths.add(GETNAME_LOCALE_SEPARATOR_PATH);
            }
            extras = extras.isEmpty() ? value : MessageFormat.format(localeSeparator, extras, value);
        }
        for (Map.Entry entry : lparser.getExtensionsDetailed().entrySet()) {
            String value = MessageFormat.format(localeKeyTypePattern, entry.getKey(), JOIN_HYPHEN.join((Iterable)entry.getValue()));
            if (paths != null) {
                paths.add(GETNAME_LOCALE_KEY_TYPE_PATTERN_PATH);
            }
            extras = extras.isEmpty() ? value : MessageFormat.format(localeSeparator, extras, value);
        }
        if (extras.isEmpty()) {
            return name;
        }
        if (paths != null) {
            paths.add(GETNAME_LOCALE_PATTERN_PATH);
        }
        return MessageFormat.format(localePattern, name, extras);
    }

    private static String replaceBracketsForName(String value) {
        return value.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
    }

    private String getNameFromTypeCodeTransformPaths(NameType nameType, String code, Transform<String, String> codeToAlt, Set<String> paths) {
        String alt;
        String path = nameType.getKeyPath(code);
        String result = null;
        if (codeToAlt != null && (alt = codeToAlt.transform(code)) != null) {
            String altPath = path + "[@alt=\"" + alt + "\"]";
            result = this.cldrFile.getStringValueWithBaileyNotConstructed(altPath);
            if (paths != null && result != null) {
                paths.add(altPath);
            }
        }
        if (result == null) {
            result = this.cldrFile.getStringValueWithBaileyNotConstructed(path);
            if (paths != null && result != null) {
                paths.add(path);
            }
        }
        if (this.cldrFile.getLocaleID().equals("en")) {
            CLDRFile.Status status = new CLDRFile.Status();
            String sourceLocale = this.cldrFile.getSourceLocaleID(path, status);
            if (result == null || !sourceLocale.equals("en")) {
                if (nameType == NameType.LANGUAGE) {
                    Set<String> set = Iso639Data.getNames(code);
                    if (set != null) {
                        return set.iterator().next();
                    }
                    Map<String, Map<String, String>> map = StandardCodes.getLStreg().get("language");
                    Map<String, String> info = map.get(code);
                    if (info != null) {
                        result = info.get("Description");
                    }
                } else if (nameType == NameType.TERRITORY) {
                    result = this.getLstrFallback("region", code);
                } else if (nameType == NameType.SCRIPT) {
                    result = this.getLstrFallback("script", code);
                }
            }
        }
        return result;
    }

    private String getLstrFallback(String codeType, String code) {
        String temp;
        Map<String, String> info = StandardCodes.getLStreg().get(codeType).get(code);
        if (info != null && !(temp = info.get("Description")).equalsIgnoreCase("Private use")) {
            List<String> temp2 = DESCRIPTION_SEP.splitToList(temp);
            Matcher matcher = CLEAN_DESCRIPTION.matcher(temp = temp2.get(0));
            if (matcher.lookingAt()) {
                temp = matcher.group(1).trim();
            }
            return temp;
        }
        return null;
    }

    private String getTZName(String tzcode) {
        String longid = CLDRFile.getLongTzid(tzcode);
        if (tzcode.length() == 4 && !tzcode.equals("gaza")) {
            return longid;
        }
        TimezoneFormatter tzf = new TimezoneFormatter(this.cldrFile);
        return tzf.getFormattedZone(longid, "VVVV", 0L);
    }

    private String getReorderName(String localeSeparator, List<String> keyValues, Set<String> paths) {
        String result = null;
        for (String value : keyValues) {
            String name = this.getNameFromTypeCodeTransformPaths(NameType.SCRIPT, Character.toUpperCase(value.charAt(0)) + value.substring(1), null, paths);
            if (name == null && (name = this.cldrFile.getKeyValueName("kr", value)) == null) {
                name = value;
            }
            result = result == null ? name : MessageFormat.format(localeSeparator, result, name);
        }
        return result;
    }

    private String addDisplayName(String subtag, NameType type, String separatorPattern, String extras, Transform<String, String> altPicker, Set<String> paths) {
        if (subtag.isEmpty()) {
            return extras;
        }
        String sname = this.getNameFromTypeCodeTransformPaths(type, subtag, altPicker, paths);
        if (sname == null) {
            sname = subtag;
        }
        sname = NameGetter.replaceBracketsForName(sname);
        extras = ((String)extras).isEmpty() ? (String)extras + sname : MessageFormat.format(separatorPattern, extras, sname);
        return extras;
    }

    public static enum NameOpt {
        DEFAULT,
        COMPOUND_ONLY;

    }
}

