/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.SupplementalDataInfo;

public class PluralSamples {
    private static final Map<String, PluralSamples> cache = new ConcurrentHashMap<String, PluralSamples>();
    private static final int SAMPLE_SIZE = 6;
    private final Map<SupplementalDataInfo.PluralInfo.Count, Double>[] samples = new Map[6];

    public PluralSamples(String locale) {
        SupplementalDataInfo info = SupplementalDataInfo.getInstance();
        SupplementalDataInfo.PluralInfo pluralInfo = info.getPlurals(locale);
        int total = pluralInfo.getCounts().size();
        this.samples[0] = Collections.unmodifiableMap(this.getValuesForDigits(pluralInfo, total, 0, 9));
        this.samples[1] = Collections.unmodifiableMap(this.getValuesForDigits(pluralInfo, total, 10, 99));
        this.samples[2] = Collections.unmodifiableMap(this.getValuesForDigits(pluralInfo, total, 100, 999));
        this.samples[3] = Collections.unmodifiableMap(this.getValuesForDigits(pluralInfo, total, 1000, 9999));
        this.samples[4] = Collections.unmodifiableMap(this.getValuesForDigits(pluralInfo, total, 10000, 99999));
        this.samples[5] = Collections.unmodifiableMap(this.getValuesForDigits(pluralInfo, total, 100000, 999999));
    }

    private Map<SupplementalDataInfo.PluralInfo.Count, Double> getValuesForDigits(SupplementalDataInfo.PluralInfo pluralInfo, int total, int start, int end) {
        double dItem;
        SupplementalDataInfo.PluralInfo.Count count;
        Double old;
        Double old2;
        SupplementalDataInfo.PluralInfo.Count count2;
        double dItem2;
        int item;
        boolean favorPositive;
        EnumMap<SupplementalDataInfo.PluralInfo.Count, Double> set = new EnumMap<SupplementalDataInfo.PluralInfo.Count, Double>(SupplementalDataInfo.PluralInfo.Count.class);
        boolean bl = favorPositive = start == 0;
        if (favorPositive) {
            ++start;
        }
        for (item = start; item < end; ++item) {
            dItem2 = item;
            count2 = pluralInfo.getCount(dItem2);
            old2 = (Double)set.get((Object)count2);
            if (old2 != null) continue;
            set.put(count2, dItem2);
            if (set.size() != total) continue;
            return set;
        }
        if (favorPositive && (old = (Double)set.get((Object)(count = pluralInfo.getCount(dItem = 0.0)))) == null) {
            set.put(count, dItem);
            if (set.size() == total) {
                return set;
            }
        }
        end *= 10;
        for (item = start *= 10; item < end; ++item) {
            dItem2 = (double)item / 10.0;
            count2 = pluralInfo.getCount(dItem2);
            old2 = (Double)set.get((Object)count2);
            if (old2 != null) continue;
            set.put(count2, dItem2);
            if (set.size() != total) continue;
            return set;
        }
        return set;
    }

    public static PluralSamples getInstance(String locale) {
        PluralSamples result = cache.get(locale);
        if (result == null) {
            result = new PluralSamples(locale);
            cache.put(locale, result);
        }
        return result;
    }

    public Map<SupplementalDataInfo.PluralInfo.Count, Double> getSamples(int digits) {
        if (digits > 0 && digits <= 6) {
            return this.samples[digits - 1];
        }
        return null;
    }
}

