/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private static final int BUFFER_SIZE = 4096;

    public static File zipDirectory(File dir) throws IOException {
        String zipFileName = dir.getAbsolutePath() + ".zip";
        FileOutputStream fos = new FileOutputStream(zipFileName);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Zipper.zipFile(dir, dir.getName(), zos);
        zos.close();
        fos.close();
        return new File(zipFileName);
    }

    private static void zipFile(File file, String name, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            zos.putNextEntry(new ZipEntry((String)(name.endsWith("/") ? name : name + "/")));
            zos.closeEntry();
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (child.isHidden()) continue;
                    Zipper.zipFile(child, name + "/" + child.getName(), zos);
                }
            }
        } else {
            int length;
            FileInputStream fis = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(name));
            byte[] bytes = new byte[4096];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            fis.close();
        }
    }
}

