/*
This program is just an example.
See discussion <http://groups.yahoo.com/group/unicode/message/16860>.
*/

#include <stdio.h>
#include <string.h>

#include "wo_util.c" 
         /* Yes, I know that .C files are not normally #included. It's for the sake of simplicity. */

const UChar TagStart = 0x0E0001L;
const UChar TagEnd   = 0x0E007FL;
const UChar TagDtMin = 0x0E0020L;
const UChar TagDtMax = 0x0E007EL;

int main (int argc, char ** argv)
{
   UChar c;
   int color = colorBlack;
   
   /* Read characters. */
   while ((c = inputCharU8()) != UCharEof)
   {
      /* Start reading Plane-14 language tag. */
      if (c == TagStart)
      {
         char buf [3];
         int i;

         memset(buf, 0, sizeof(buf));

         for (i = 0; (c = inputCharU8()) != UCharEof; i++)
         {
            /* End of Plane-14 language tag. */
            if (c == TagEnd)
            {
               if (strcmp(buf, "e") == 0)
               {
                  /* Switch to English color (green). */
                  pushColor(color);
                  color = colorGreen;
                  switchColor(colorGreen);
               }

               else if (strcmp(buf, "i") == 0)
               {
                  /* Switch to Italian color (red). */
                  pushColor(color);
                  color = colorRed;
                  switchColor(colorRed);
               }

               else if (strcmp(buf, "^") == 0)
               {
                  /* Switch to last saved color. */
                  color = popColor();
                  switchColor(color);
               }

               /* Stop reading Plane-14 language tag. */
               break;
            }

            /* Check validity of Plane-14 language tag. */
            else if (c < TagDtMin || c > TagDtMax)
            {
               fprintf(stderr, "Error: unterminated language tag.\n");
               return 1;
            }

            /* Save language id in Plane-14 language tag. */
            else if (i < sizeof(buf) - 1)
            {
               buf[i] = (char)(c & 0x7F);
            }
         }
      }

      else
      {
         /* Write character. */
         outputCharU8(c);
      }
   }

   return 0;
}

