/*
This program is just an example.
See discussion <http://groups.yahoo.com/group/unicode/message/16860>.
*/

#include <stdio.h>

/* Unicode character type (UTF-32). */
typedef long UChar;
const UChar  UCharEof = 0xFFFFFFL;

/* Read an UTF-8 character from standard input stream (console). */
UChar inputCharU8 (void)
{
   int   i, oct, n = 0;
   UChar c = 0;

   if ((oct = getchar()) == EOF)
   {
      return UCharEof;
   }
   else if ((unsigned char)oct >= 0x00 && (unsigned char)oct <= 0x7F)
   {
      return oct;
   }
   else if ((unsigned char)oct >= 0xC2 && (unsigned char)oct <= 0xDF)
   {
      c = (UChar)((unsigned char)oct & 0x1F) << 6;
      n = 2;
   }
   else if (oct >= 0xE0 && oct <= 0xEF)
   {
      c = (UChar)((unsigned char)oct & 0x0F) << 12;
      n = 3;
   }
   else if (oct >= 0xF0 && oct <= 0xF4)
   {
      c = (UChar)((unsigned char)oct & 0x07) << 18;
      n = 4;
   }
   else 
   {
      return '?';
   }

   for (i = 1; i < n; i++)
   {
      if ((oct = getchar()) == EOF)
      {
         return UCharEof;
      }
      else if ((unsigned char)oct < 0x80 || (unsigned char)oct > 0xBF)
      {
         return '?';
      }
      else
      {
         c |= (UChar)((unsigned char)oct & 0x3F) << (6 * ((n - 1) - i));
      }
   }

   return c;
}

/* Write an UTF-8 character to standard output stream (console). */
void outputCharU8 (UChar c)
{
   if (c >= 0x00 && c <= 0x7F)
   {
      putchar((char)c);
   }
   else if (c >= 0x80 && c <= 0x7FF)
   {
      putchar((char)(0xC0 | (c >> 6)  & 0x1F));
      putchar((char)(0x80 |  c        & 0x3F));
   }
   else if (c >= 0x800 && c <= 0xFFFD)
   {
      putchar((char)(0xE0 | (c >> 12) & 0x0F));
      putchar((char)(0x80 | (c >> 6)  & 0x3F));
      putchar((char)(0x80 |  c        & 0x3F));
   }
   else if (c >= 0x1000 && c <= 0x10FFFF)
   {
      putchar((char)(0xF0 | (c >> 18) & 0x07));
      putchar((char)(0x80 | (c >> 12) & 0x3F));
      putchar((char)(0x80 | (c >> 6)  & 0x3F));
      putchar((char)(0x80 |  c        & 0x3F));
   }
   else
      putchar('?');
}

/* Color constants. */
enum Color
{ 
   colorBlack,
   colorBlue,
   colorGreen,
   colorCyan,
   colorRed,
   colorMagenta,
   colorYellow,
   colorWhite
};

/* Write to standard output stream (console) an hypotetical escape sequence to change text color. */
void switchColor(int c)
{
   printf("{{color=%d}}", c);
}

int  ColorStack [16];
long ColorStackPtr = 0;

/* Save current color */
void pushColor (int color)
{
   if (ColorStackPtr >= sizeof(ColorStack))
   {
      fprintf(stderr, "Warning: too many embedded languages.");
      return;
   }

   ColorStack[ColorStackPtr++] = color;
}

/* Retrieve previous color */
int popColor (void)
{
   if (ColorStackPtr <= 0)
   {
      return colorBlack;
   }

   return ColorStack[--ColorStackPtr];
}

