/*
This program is just an example.
See discussion <http://groups.yahoo.com/group/unicode/message/16860>.
*/

#include <stdio.h>
#include <string.h>

#include "wo_util.c" 
         /* Yes, I know that .C files are not normally #included. It's for the sake of simplicity. */

const UChar TagStart = 0xFF0000L;

UChar inputCharXML (void);

int main (int argc, char ** argv)
{
   UChar c;
   int color = colorBlack;
   
   /* Read characters. */
   while ((c = inputCharXML()) != UCharEof)
   {
      /* Start reading XML tag. */
      if (c == TagStart)
      {
         char  buf [3];
         int   i;
         int   inString = 0;

         memset(buf, 0, sizeof(buf));

         for (i = 0; (c = inputCharU8()) != UCharEof; i++)
         {
            /* End of XML tag. */
            if (c == '>' && !inString)
            {
               if (strcmp(buf, "e") == 0)
               {
                  /* Switch to English color (green). */
                  pushColor(color);
                  color = colorGreen;
                  switchColor(color);
               }

               else if (strcmp(buf, "i") == 0)
               {
                  /* Switch to Italian color (red). */
                  pushColor(color);
                  color = colorRed;
                  switchColor(color);
               }

               else if (strcmp(buf, "/e") == 0 || strcmp(buf, "/i") == 0)
               {
                  /* Switch to last saved color. */
                  color = popColor();
                  switchColor(color);
               }

               /* Stop reading XML tag. */
               break;
            }

            /* Ignore '>' characters inside strings. */
            else if (c == '\"')
            {
               inString = !inString;
            }

            /* Save XML tag. */
            else if (i < sizeof(buf) - 1)
            {
               if (c < 0x20 || c > 0x7E)
               {
                  buf[i] = '?';
               }
               else
               {
                  buf[i] = (char)c;
               }
            }
         }
      }

      else
      {
         /* Write character. */
         outputCharU8(c);
      }
   }

   return 0;
}

/* Read an XML character from standard input stream (console). */
UChar inputCharXML (void)
{
   UChar c = inputCharU8();

   switch (c)
   {
      case '<':
         c = TagStart;
         break;

      case '&':
         {
            char buf [16];
            int i = 0;
      
            while ((c == inputCharU8()) != ';')
            {
               if (c == UCharEof)
               {
                  fprintf(stderr, "Error: unterminated character entity.");
                  return colorBlack;
               }
               else if (i < sizeof(buf) - 1)
               {
                  if (c > 0x7F)
                  {
                     fprintf(stderr, "Warning: invalid character in character entity (U+%6.6X).", c);
                     c = '?';
                  }
                  buf[i++] = (char)c;
               }
            }

            buf[i] = '\0';

            if (strcmp(buf, "amp") == 0)
            {
               c = '&';
            }
            else if (strcmp(buf, "lt") == 0)
            {
               c = '<';
            }
            else if (strcmp(buf, "gt") == 0)
            {
               c = '>';
            }
            else if (buf[0] == '#')
            {
               sscanf(buf + 1, "%li", &c);
            }
            else
            {
               c = '?';
            }
         }
         break;
   }

   return c;
}

