<?xml version="1.0"?>
<xsl:stylesheet
    version="1.0"
    xmlns:math="http://www.w3.org/1998/Math/MathML"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.lib.Redirect"
    extension-element-prefixes="redirect">

<!--
This stylesheet uses Xalan extensions.
It exects a mathML input.
It wraps the mathML inside of three html files output with a given name to three directories:
amaya - for the amaya browser
webEQ - for the webEQ applet
te - for the techexplorer plug-in
Note that techexplorer can display mathML input directly as well as embedded within HTML.
-->

<xsl:strip-space elements="*"/>

<!--
-PARAM mml name
processes source mml to amaya/name.html, webeq/name.html, and te/name.html
-->
<xsl:param name="mml"/>

<!--
Name of output amaya file.
-->
<xsl:variable name="amaya">amaya/<xsl:value-of select="$mml"/>.html</xsl:variable>

<xsl:output method="html" indent="yes"/>

<lxslt:component prefix="redirect" elements="write open close" functions="">
  <lxslt:script lang="javaclass" src="org.apache.xalan.lib.Redirect"/>
</lxslt:component>  

<!--
Output the amaya example
-->
<xsl:template match="/">
  <redirect:write select="$amaya">
  <HTML>
  <HEAD>
  <TITLE><xsl:value-of select="$mml"/></TITLE>
  </HEAD>
  <BODY>
  <H1><xsl:value-of select="$mml"/> example file for Amaya</H1>
  <xsl:copy-of select="."/>
  </BODY>
  </HTML>
  </redirect:write>
</xsl:template>

<xsl:template match="math:*">
   &lt;<xsl:value-of select="name()"/>&gt;<xsl:apply-templates/>&lt;/<xsl:value-of select="name()"/>&gt;
</xsl:template>

</xsl:stylesheet>
