<?xml version="1.0"?>
<xsl:stylesheet
    version="1.0"
    xmlns:math="http://www.w3.org/1998/Math/MathML"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.lib.Redirect"
    extension-element-prefixes="redirect">

<!--
This stylesheet uses Xalan extensions.
It exects a mathML input.
It wraps the mathML inside of three html files output with a given name to three directories:
amaya - for the amaya browser
webEQ - for the webEQ applet
te - for the techexplorer plug-in
Note that techexplorer can display mathML input directly as well as embedded within HTML.
-->

<xsl:strip-space elements="*"/>

<!--
-PARAM mml name
processes source mml to amaya/name.html, webeq/name.html, and te/name.html
-->
<xsl:param name="mml"/>

<!--
Name of output amaya file.
-->
<xsl:variable name="amaya">amaya/<xsl:value-of select="$mml"/>.html</xsl:variable>

<!--
Name of output webEQ file.
-->
<xsl:variable name="webeq">webeq/<xsl:value-of select="$mml"/>.html</xsl:variable>

<!--
Name of output techexplorer file.
-->
<xsl:variable name="techexplorer">te/<xsl:value-of select="$mml"/>.html</xsl:variable>

<xsl:output method="html" indent="yes"/>

<lxslt:component prefix="redirect" elements="write open close" functions="">
  <lxslt:script lang="javaclass" src="org.apache.xalan.lib.Redirect"/>
</lxslt:component>  

<!--
Output the amaya example
-->
<xsl:template name="amaya">
  <redirect:write select="$amaya">
  <HTML>
  <HEAD>
  <TITLE><xsl:value-of select="$mml"/></TITLE>
  </HEAD>
  <BODY>
  <H1><xsl:value-of select="$mml"/> example file for Amaya</H1>
  <xsl:copy-of select="."/>
  </BODY>
  </HTML>
  </redirect:write>
</xsl:template>

<!--
Output the webEQ example
-->
<xsl:template name="webeq">
  <redirect:write select="$webeq">
  <HTML>
  <HEAD>
  <TITLE><xsl:value-of select="$mml"/></TITLE>
  </HEAD>
  <BODY>
  <H1><xsl:value-of select="$mml"/> example file for WebEQ</H1>
    <center>
      <applet code="webeq.Main" width="300" height="100">
        <param name="parser" value="mathml"/>
        <param name="color" value="#ffffff"/>
        <param name="eq">
          <xsl:attribute name="value"><xsl:apply-templates select="/math:math"/></xsl:attribute>
        </param>
      </applet>
    </center>
  </BODY>
  </HTML>
  </redirect:write>
</xsl:template>

<!--
Output the techexplorer example
-->
<xsl:template name="techexplorer">
  <redirect:write select="$techexplorer">
  <HTML>
  <HEAD>
  <TITLE><xsl:value-of select="$mml"/></TITLE>
  </HEAD>
  <BODY>
  <H1><xsl:value-of select="$mml"/> example file for techexplorer</H1>
  <center>
  <OBJECT ID="matrix"
    CLASSID="clsid:5AFAB315-AD87-11D3-98BB-002035EFB1A4">
        <PARAM NAME="AutoSize" VALUE="TRUE"/>
        <PARAM NAME="DataType" VALUE="1"/>
        <PARAM NAME="Data">
          <xsl:attribute name="VALUE"><xsl:apply-templates select="/math:math"/></xsl:attribute>
        </PARAM>
  <EMBED TYPE="text/mathml" HEIGHT="200" WIDTH="300">
    <xsl:attribute name="MMLDATA"><xsl:apply-templates select="/math:math"/></xsl:attribute>
  </EMBED>
  </OBJECT>
  </center>
  </BODY>
  </HTML>
  </redirect:write>
</xsl:template>

<xsl:template match="/">
   <xsl:call-template name="amaya"/>
   <xsl:call-template name="webeq"/>
   <xsl:call-template name="techexplorer"/>
</xsl:template>

<xsl:template match="math:*">
   &lt;<xsl:value-of select="name()"/>&gt;<xsl:apply-templates/>&lt;/<xsl:value-of select="name()"/>&gt;
</xsl:template>

</xsl:stylesheet>
